/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockAlkahestryAltar;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.BlockApothecaryMortar;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.blocks.BlockInterdictionTorch;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.BlockWraithNode;
import xreliquary.blocks.tile.TileEntityAltar;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.items.block.ItemBlockBase;
import xreliquary.items.block.ItemFertileLilyPad;
import xreliquary.reference.Reference;
import xreliquary.reference.Settings;

public class ModBlocks {
    public static final BlockApothecaryCauldron apothecaryCauldron = new BlockApothecaryCauldron();
    public static final BlockAlkahestryAltar alkahestryAltar = new BlockAlkahestryAltar(false);
    public static final BlockAlkahestryAltar alkahestryAltarActive = new BlockAlkahestryAltar(true);
    public static final BlockBase apothecaryMortar = new BlockApothecaryMortar();
    public static final BlockFertileLilypad fertileLilypad = new BlockFertileLilypad();
    public static final BlockInterdictionTorch interdictionTorch = new BlockInterdictionTorch();
    public static final BlockWraithNode wraithNode = new BlockWraithNode();
    public static final BlockPedestal pedestal = new BlockPedestal();

    public static void init() {
        ModBlocks.registerBlock(apothecaryCauldron, ItemBlockBase.class, "apothecary_cauldron");
        ModBlocks.registerBlock((Block)alkahestryAltar, ItemBlockBase.class, "altar_idle");
        ModBlocks.registerBlock((Block)alkahestryAltarActive, ItemBlockBase.class, "altar");
        ModBlocks.registerBlock(apothecaryMortar, ItemBlockBase.class, "apothecary_mortar");
        ModBlocks.registerBlock((Block)fertileLilypad, ItemFertileLilyPad.class, "fertile_lilypad");
        ModBlocks.registerBlock((Block)interdictionTorch, ItemBlockBase.class, "interdiction_torch");
        ModBlocks.registerBlock(wraithNode, ItemBlockBase.class, "wraith_node");
        ModBlocks.registerBlock(pedestal, ItemBlockBase.class, "pedestal");
    }

    public static void initTileEntities() {
        ModBlocks.registerTileEntity(TileEntityAltar.class, "reliquaryAltar");
        ModBlocks.registerTileEntity(TileEntityMortar.class, "apothecaryMortar");
        ModBlocks.registerTileEntity(TileEntityCauldron.class, "reliquaryCauldron");
        ModBlocks.registerTileEntity(TileEntityPedestal.class, "reliquaryPedestal");
    }

    private static void registerTileEntity(Class clazz, String name) {
        if (Settings.disabledItemsBlocks.contains(name)) {
            return;
        }
        GameRegistry.registerTileEntity((Class)clazz, (String)("xreliquary." + name));
    }

    private static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name) {
        if (Settings.disabledItemsBlocks.contains(name)) {
            return;
        }
        GameRegistry.registerBlock((Block)block, itemclass, (String)(Reference.DOMAIN + name));
        Reliquary.PROXY.registerJEI(block, name);
    }
}

