/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemDestructionCatalyst
extends ItemToggleable {
    public static List<String> ids = ImmutableList.of((Object)"minecraft:dirt", (Object)"minecraft:grass", (Object)"minecraft:gravel", (Object)"minecraft:cobblestone", (Object)"minecraft:stone", (Object)"minecraft:sand", (Object)"minecraft:sandstone", (Object)"minecraft:snow", (Object)"minecraft:soul_sand", (Object)"minecraft:netherrack", (Object)"minecraft:end_stone");

    public ItemDestructionCatalyst() {
        super("destruction_catalyst");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger("gunpowder", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.GRAY + Items.field_151016_H.func_77653_i(new ItemStack(Items.field_151016_H)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (NBTHelper.getInteger("gunpowder", stack) > this.gunpowderCost() || player.field_71075_bZ.field_75098_d) {
            this.doExplosion(world, pos, side, player, stack);
        }
        return true;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist) && NBTHelper.getInteger("gunpowder", ist) + this.gunpowderWorth() < this.gunpowderLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151016_H), player)) {
            NBTHelper.setInteger("gunpowder", ist, NBTHelper.getInteger("gunpowder", ist) + this.gunpowderWorth());
        }
    }

    public int getExplosionRadius() {
        return Settings.DestructionCatalyst.explosionRadius;
    }

    public boolean centeredExplosion() {
        return Settings.DestructionCatalyst.centeredExplosion;
    }

    public boolean perfectCube() {
        return Settings.DestructionCatalyst.perfectCube;
    }

    public void doExplosion(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack ist) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!this.centeredExplosion()) {
            y = pos.func_177956_o() + (side == EnumFacing.DOWN ? this.getExplosionRadius() : (side == EnumFacing.UP ? -this.getExplosionRadius() : 0));
            z = pos.func_177952_p() + (side == EnumFacing.NORTH ? this.getExplosionRadius() : (side == EnumFacing.SOUTH ? -this.getExplosionRadius() : 0));
            x = pos.func_177958_n() + (side == EnumFacing.WEST ? this.getExplosionRadius() : (side == EnumFacing.EAST ? -this.getExplosionRadius() : 0));
        }
        for (int xD = -this.getExplosionRadius(); xD <= this.getExplosionRadius(); ++xD) {
            for (int yD = -this.getExplosionRadius(); yD <= this.getExplosionRadius(); ++yD) {
                for (int zD = -this.getExplosionRadius(); zD <= this.getExplosionRadius(); ++zD) {
                    BlockPos target;
                    BlockPos origin;
                    double distance;
                    if (!this.perfectCube() && (distance = (origin = new BlockPos(x, y, z)).func_177951_i((Vec3i)(target = new BlockPos(x + xD, y + yD, z + zD)))) >= (double)this.getExplosionRadius() || !this.isBreakable(RegistryHelper.getBlockRegistryName(world.func_180495_p(new BlockPos(x + xD, y + yD, z + zD)).func_177230_c()))) continue;
                    world.func_175656_a(new BlockPos(x + xD, y + yD, z + zD), Blocks.field_150350_a.func_176223_P());
                    if (world.field_73012_v.nextInt(2) == 0) {
                        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)((float)(x + xD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(y + yD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(z + zD) + (world.field_73012_v.nextFloat() - 0.5f)), 0.0, 0.0, 0.0, new int[0]);
                    }
                    destroyedSomething = true;
                    if (!playOnce) continue;
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    playOnce = false;
                }
            }
        }
        if (destroyedSomething && !player.field_71075_bZ.field_75098_d) {
            NBTHelper.setInteger("gunpowder", ist, NBTHelper.getInteger("gunpowder", ist) - this.gunpowderCost());
        }
    }

    public boolean isBreakable(String id) {
        return Settings.DestructionCatalyst.mundaneBlocks.indexOf(id) != -1;
    }

    private int gunpowderCost() {
        return Settings.DestructionCatalyst.gunpowderCost;
    }

    private int gunpowderWorth() {
        return Settings.DestructionCatalyst.gunpowderWorth;
    }

    private int gunpowderLimit() {
        return Settings.DestructionCatalyst.gunpowderLimit;
    }
}

