/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.RegistryHelper;

public class ItemEmperorChalice
extends ItemToggleable
implements IFluidContainerItem {
    public ItemEmperorChalice() {
        super("emperor_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.DRINK;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        int multiplier = Settings.EmperorChalice.hungerSatiationMultiplier;
        player.func_71024_bL().func_75122_a(1, (float)(multiplier / 2));
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return stack;
    }

    @Override
    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player);
        }
        float coeff = 1.0f;
        double xOff = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)coeff;
        double yOff = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)coeff + (double)player.func_70047_e();
        double zOff = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)coeff;
        boolean isInDrainMode = this.isEnabled(ist);
        MovingObjectPosition mop = this.func_77621_a(world, player, isInDrainMode);
        if (mop == null) {
            if (!this.isEnabled(ist)) {
                player.func_71008_a(ist, this.func_77626_a(ist));
            }
            return ist;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            TileEntity tile;
            if (!world.func_175660_a(player, mop.func_178782_a())) {
                return ist;
            }
            if (!player.func_175151_a(mop.func_178782_a(), mop.field_178784_b, ist)) {
                return ist;
            }
            if (this.isEnabled(ist)) {
                tile = world.func_175625_s(mop.func_178782_a());
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
                    ((IFluidHandler)tile).drain(mop.field_178784_b, fluid, true);
                    return ist;
                }
            } else {
                tile = world.func_175625_s(mop.func_178782_a());
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
                    int amount = ((IFluidHandler)tile).fill(mop.field_178784_b, fluid, false);
                    if (amount > 0) {
                        ((IFluidHandler)tile).fill(mop.field_178784_b, fluid, true);
                    }
                    return ist;
                }
            }
            if (!this.isEnabled(ist)) {
                BlockPos waterPlacementPos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
                if (!player.func_175151_a(waterPlacementPos, mop.field_178784_b, ist)) {
                    return ist;
                }
                if (this.tryPlaceContainedLiquid(world, ist, xOff, yOff, zOff, waterPlacementPos)) {
                    return ist;
                }
            } else {
                String ident = RegistryHelper.getBlockRegistryName(world.func_180495_p(mop.func_178782_a()).func_177230_c());
                if (ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150358_i)) || ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150355_j))) {
                    if ((Integer)world.func_180495_p(mop.func_178782_a()).func_177229_b((IProperty)BlockStaticLiquid.field_176367_b) == 0) {
                        world.func_175656_a(mop.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                        return ist;
                    }
                }
            }
        }
        return ist;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack stack, double posX, double posY, double posZ, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_177230_c().func_149688_o();
        if (this.isEnabled(stack)) {
            return false;
        }
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_72908_a(posX + 0.5, posY + 0.5, posZ + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int var11 = 0; var11 < 8; ++var11) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 3);
        }
        return true;
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.isEnabled(container)) {
            return null;
        }
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (!this.isEnabled(container) || resource == null) {
            return 0;
        }
        if (!resource.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000))) {
            return 0;
        }
        return 1000;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.isEnabled(container)) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        return null;
    }
}

