/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.entities.EntityEnderStaffProjectile;
import xreliquary.init.ModBlocks;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemEnderStaff
extends ItemToggleable {
    public ItemEnderStaff() {
        super("ender_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    private int getEnderStaffPearlCost() {
        return Settings.EnderStaff.enderPearlCastCost;
    }

    private int getEnderStaffNodeWarpCost() {
        return Settings.EnderStaff.enderPearlNodeWarpCost;
    }

    private int getEnderPearlWorth() {
        return Settings.EnderStaff.enderPearlWorth;
    }

    private int getEnderPearlLimit() {
        return Settings.EnderStaff.enderPearlLimit;
    }

    private int getNodeWarpCastTime() {
        return Settings.EnderStaff.nodeWarpCastTime;
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString("mode", ist).equals("")) {
            this.setMode(ist, "cast");
        }
        return NBTHelper.getString("mode", ist);
    }

    public void setMode(ItemStack ist, String s) {
        NBTHelper.setString("mode", ist, s);
    }

    public void cycleMode(ItemStack ist) {
        if (this.getMode(ist).equals("cast")) {
            this.setMode(ist, "long_cast");
        } else if (this.getMode(ist).equals("long_cast")) {
            this.setMode(ist, "node_warp");
        } else {
            this.setMode(ist, "cast");
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        EntityPlayer player;
        if (entityLiving.field_70170_p.field_72995_K) {
            return true;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return true;
        }
        if (ist.func_77952_i() == 1) {
            ist.func_77964_b(0);
        }
        if ((player = (EntityPlayer)entityLiving).func_70093_af()) {
            this.cycleMode(ist);
        }
        return false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isEnabled(ist)) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (NBTHelper.getInteger("ender_pearls", ist) + this.getEnderPearlWorth() <= this.getEnderPearlLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151079_bi), player)) {
            NBTHelper.setInteger("ender_pearls", ist, NBTHelper.getInteger("ender_pearls", ist) + this.getEnderPearlWorth());
        }
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int unadjustedCount) {
        for (int particles = 0; particles < 2; ++particles) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), new int[0]);
        }
        if (unadjustedCount == 1) {
            this.doWraithNodeWarpCheck(ist, player.field_70170_p, player);
        }
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getNodeWarpCastTime();
    }

    @Override
    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            if (this.getMode(ist).equals("cast") || this.getMode(ist).equals("long_cast")) {
                if (player.field_82175_bq) {
                    return ist;
                }
                player.func_71038_i();
                if (NBTHelper.getInteger("ender_pearls", ist) < this.getEnderStaffPearlCost() && !player.field_71075_bZ.field_75098_d) {
                    return ist;
                }
                player.field_70170_p.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityEnderStaffProjectile(player.field_70170_p, player, !this.getMode(ist).equals("long_cast")));
                    if (!player.field_71075_bZ.field_75098_d) {
                        NBTHelper.setInteger("ender_pearls", ist, NBTHelper.getInteger("ender_pearls", ist) - this.getEnderStaffPearlCost());
                    }
                }
            } else {
                player.func_71008_a(ist, this.func_77626_a(ist));
            }
        }
        return super.func_77659_a(ist, world, player);
    }

    private ItemStack doWraithNodeWarpCheck(ItemStack stack, World world, EntityPlayer player) {
        if (NBTHelper.getInteger("ender_pearls", stack) < this.getEnderStaffNodeWarpCost() && !player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(player)).intValue()) {
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Out of range!"));
            }
        } else if (stack.func_77978_p() != null && RegistryHelper.blocksEqual(world.func_180495_p(new BlockPos(stack.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)))).func_177230_c(), ModBlocks.wraithNode)) {
            if (this.canTeleport(world, stack.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)))) {
                this.teleportPlayer(world, stack.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), stack.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)), player);
                if (!player.field_71075_bZ.field_75098_d) {
                    NBTHelper.setInteger("ender_pearls", stack, NBTHelper.getInteger("ender_pearls", stack) - this.getEnderStaffNodeWarpCost());
                }
            }
        } else if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("dimensionID")) {
            stack.func_77978_p().func_82580_o("dimensionID");
            stack.func_77978_p().func_82580_o("nodeX");
            stack.func_77978_p().func_82580_o("nodeY");
            stack.func_77978_p().func_82580_o("nodeZ");
            stack.func_77978_p().func_82580_o("cooldown");
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Node dosen't exist!"));
            } else {
                player.func_85030_a("mob.endermen.death", 1.0f, 1.0f);
            }
        }
        return stack;
    }

    private boolean canTeleport(World world, int x, int y, int z) {
        return world.func_175623_d(new BlockPos(x, y + 1, z)) && world.func_175623_d(new BlockPos(x, y + 2, z));
    }

    private void teleportPlayer(World world, int x, int y, int z, EntityPlayer player) {
        player.func_70634_a((double)x + 0.5, (double)y + 0.875, (double)z + 0.5);
        player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), new int[0]);
        }
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        String charge = Integer.toString(NBTHelper.getInteger("ender_pearls", ist));
        String phrase = "Currently bound to ";
        String position = "";
        if (ist.func_77978_p() != null && ist.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(player)).intValue()) {
            phrase = "Out of range!";
        } else {
            position = ist.func_77978_p() != null && ist.func_77978_p().func_74764_b("nodeX" + this.getWorld(player)) && ist.func_77978_p().func_74764_b("nodeY" + this.getWorld(player)) && ist.func_77978_p().func_74764_b("nodeZ" + this.getWorld(player)) ? "X: " + ist.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)) + " Y: " + ist.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)) + " Z: " + ist.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)) : "nowhere.";
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"position", (Object)position, (Object)"charge", (Object)charge), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.GREEN + Items.field_151079_bi.func_77653_i(new ItemStack(Items.field_151079_bi)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public boolean func_180614_a(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((ist.func_77978_p() == null || !ist.func_77978_p().func_74764_b("dimensionID")) && RegistryHelper.blocksEqual(world.func_180495_p(pos).func_177230_c(), ModBlocks.wraithNode)) {
            this.setWraithNode(ist, pos, Integer.valueOf(this.getWorld(player)), player);
            player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
            for (int particles = 0; particles < 12; ++particles) {
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), new int[0]);
            }
            return true;
        }
        return false;
    }

    public void setWraithNode(ItemStack eye, BlockPos pos, int dimensionID, EntityPlayer player) {
        NBTHelper.setInteger("nodeX" + this.getWorld(player), eye, pos.func_177958_n());
        NBTHelper.setInteger("nodeY" + this.getWorld(player), eye, pos.func_177956_o());
        NBTHelper.setInteger("nodeZ" + this.getWorld(player), eye, pos.func_177952_p());
        NBTHelper.setInteger("dimensionID", eye, dimensionID);
    }

    public String getWorld(EntityPlayer player) {
        return Integer.valueOf(player.field_70170_p.field_73011_w.func_177502_q()).toString();
    }
}

