/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import baubles.api.BaubleType;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.init.ModFluids;
import xreliquary.items.ItemBauble;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;
import xreliquary.util.XpHelper;

public class ItemFortuneCoin
extends ItemBauble
implements IPedestalActionItem {
    public ItemFortuneCoin() {
        super("fortune_coin");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnabled(stack);
    }

    private boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    public void func_77663_a(ItemStack ist, World world, Entity entity, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.disabledAudio() && NBTHelper.getShort("soundTimer", ist) > 0) {
            if (NBTHelper.getShort("soundTimer", ist) % 2 == 0) {
                world.func_72956_a(entity, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            }
            NBTHelper.setShort("soundTimer", ist, NBTHelper.getShort("soundTimer", ist) - 1);
        }
        if (!this.isEnabled(ist)) {
            return;
        }
        EntityPlayer player = null;
        if (entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
        }
        if (player == null) {
            return;
        }
        this.scanForEntitiesInRange(world, player, this.getStandardPullDistance());
    }

    private void scanForEntitiesInRange(World world, EntityPlayer player, double d) {
        List iList = world.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - d, player.field_70163_u - d, player.field_70161_v - d, player.field_70165_t + d, player.field_70163_u + d, player.field_70161_v + d));
        for (EntityItem item : iList) {
            if (!this.checkForRoom(item.func_92059_d(), player)) continue;
            item.func_174867_a(0);
            if ((double)player.func_70032_d((Entity)item) < 1.5) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
        List iList2 = world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB(player.field_70165_t - d, player.field_70163_u - d, player.field_70161_v - d, player.field_70165_t + d, player.field_70163_u + d, player.field_70161_v + d));
        for (EntityXPOrb item : iList2) {
            if (player.field_71090_bL > 0) {
                player.field_71090_bL = 0;
            }
            if ((double)player.func_70032_d((Entity)item) < 1.5) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
    }

    private void teleportEntityToPlayer(Entity item, EntityPlayer player) {
        player.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, item.field_70165_t + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, item.field_70163_u + 0.2, item.field_70161_v + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, 0.9, 0.9, 0.0, new int[0]);
        player.func_70040_Z();
        double x = player.field_70165_t + player.func_70040_Z().field_72450_a * 0.2;
        double y = player.field_70163_u;
        double z = player.field_70161_v + player.func_70040_Z().field_72449_c * 0.2;
        item.func_70107_b(x, y, z);
        if (!this.disabledAudio()) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
        }
    }

    private boolean checkForRoom(ItemStack item, EntityPlayer player) {
        int remaining = item.field_77994_a;
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != item.func_77973_b() || ist.func_77952_i() != item.func_77952_i()) continue;
            if (ist.field_77994_a + remaining <= ist.func_77976_d()) {
                return true;
            }
            for (int count = ist.field_77994_a; count < ist.func_77976_d(); ++count) {
                if (--remaining != 0) continue;
                return true;
            }
        }
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] != null) continue;
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int count) {
        this.scanForEntitiesInRange(player.field_70170_p, player, this.getLongRangePullDistance());
    }

    public double getLongRangePullDistance() {
        return Settings.FortuneCoin.longRangePullDistance;
    }

    public double getStandardPullDistance() {
        return Settings.FortuneCoin.standardPullDistance;
    }

    public int func_77626_a(ItemStack stack) {
        return 64;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!this.disabledAudio()) {
                NBTHelper.setShort("soundTimer", ist, 6);
            }
            NBTHelper.setBoolean("enabled", ist, !this.isEnabled(ist));
        } else {
            player.func_71008_a(ist, this.func_77626_a(ist));
        }
        return ist;
    }

    @Override
    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.AMULET;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    private boolean disabledAudio() {
        return Settings.FortuneCoin.disableAudio;
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        if (world.field_72995_K) {
            return;
        }
        if (this.isEnabled(stack)) {
            BlockPos pos = pedestal.getBlockPos();
            double d = this.getStandardPullDistance();
            List entities = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n() - d, (double)pos.func_177956_o() - d, (double)pos.func_177952_p() - d, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d, (double)pos.func_177952_p() + d));
            for (EntityItem entityItem : entities) {
                int numberAdded = pedestal.addToConnectedInventory(entityItem.func_92059_d().func_77946_l());
                if (numberAdded > 0) {
                    entityItem.func_92059_d().field_77994_a -= numberAdded;
                    if (entityItem.func_92059_d().field_77994_a > 0) continue;
                    entityItem.func_70106_y();
                    continue;
                }
                pedestal.setActionCoolDown(20);
            }
            List XPOrbs = world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)pos.func_177958_n() - d, (double)pos.func_177956_o() - d, (double)pos.func_177952_p() - d, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d, (double)pos.func_177952_p() + d));
            for (EntityXPOrb xpOrb : XPOrbs) {
                int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.field_70530_e);
                int amountAdded = pedestal.fillConnectedTank(new FluidStack(ModFluids.fluidXpJuice, amountToTransfer));
                if (amountAdded > 0) {
                    xpOrb.func_70106_y();
                    if (amountToTransfer <= amountAdded) continue;
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                    continue;
                }
                pedestal.setActionCoolDown(20);
            }
        }
    }
}

