/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.util.NBTHelper;

public class ItemHandgun
extends ItemBase {
    public ItemHandgun() {
        super("handgun");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        return Integer.parseInt("FFFFFF", 16);
    }

    public int getBulletCount(ItemStack ist) {
        return NBTHelper.getShort("bulletCount", ist);
    }

    public void setBulletCount(ItemStack ist, int i) {
        NBTHelper.setShort("bulletCount", ist, i);
    }

    public int getBulletType(ItemStack ist) {
        return NBTHelper.getShort("bulletType", ist);
    }

    public void setBulletType(ItemStack ist, int i) {
        NBTHelper.setShort("bulletType", ist, i);
    }

    public void setLastFiredShotType(ItemStack ist, int i) {
        NBTHelper.setShort("lastFiredShot", ist, i);
    }

    public boolean isInCooldown(ItemStack ist) {
        return NBTHelper.getBoolean("inCooldown", ist);
    }

    public void setInCooldown(ItemStack ist, boolean inCooldown) {
        NBTHelper.setBoolean("inCooldown", ist, inCooldown);
    }

    public long getCooldown(ItemStack ist) {
        return NBTHelper.getLong("cooldownTime", ist);
    }

    public void setCooldown(ItemStack ist, long i) {
        NBTHelper.setLong("cooldownTime", ist, i);
    }

    public void func_77663_a(ItemStack ist, World worldObj, Entity e, int i, boolean flag) {
        if (!worldObj.field_72995_K && (this.isInCooldown(ist) && this.isCooldownOver(worldObj, ist) || !this.isValidCooldownTime(worldObj, ist))) {
            this.setInCooldown(ist, false);
        }
    }

    private boolean isCooldownOver(World worldObj, ItemStack ist) {
        return this.getCooldown(ist) < worldObj.func_72820_D() && worldObj.func_72820_D() - this.getCooldown(ist) < 12000L;
    }

    private boolean isValidCooldownTime(World worldObj, ItemStack ist) {
        return Math.min(Math.abs(worldObj.func_72820_D() - this.getCooldown(ist)), Math.abs(worldObj.func_72820_D() - 23999L - this.getCooldown(ist))) <= (long)this.func_77626_a(ist);
    }

    public ItemStack func_77659_a(ItemStack ist, World worldObj, EntityPlayer player) {
        if (!this.isInCooldown(ist)) {
            if (this.getBulletCount(ist) <= 0 && this.getBulletType(ist) <= 0) {
                player.func_71008_a(ist, this.func_77626_a(ist));
            } else if (!worldObj.field_72995_K) {
                this.setCooldown(ist, worldObj.func_72820_D() + 20L + 5L - (long)Math.min(player.field_71068_ca, 20));
                this.setInCooldown(ist, true);
                this.fireBullet(ist, worldObj, player);
            }
        }
        return ist;
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int unadjustedCount) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = unadjustedCount - maxUseOffset;
        --actualCount;
        if (!this.hasFilledMagazine(player)) {
            this.setCooldown(ist, player.field_70170_p.func_72820_D() + 12L);
            this.setInCooldown(ist, true);
            player.func_71034_by();
            return;
        }
        if (actualCount == 0) {
            this.setCooldown(ist, player.field_70170_p.func_72820_D() + 12L);
            this.setInCooldown(ist, true);
            this.setBulletType(ist, this.getMagazineTypeAndRemoveOne(player));
            if (this.getBulletType(ist) != 0) {
                player.func_71038_i();
                this.spawnEmptyMagazine(player);
                this.setBulletCount(ist, 8);
                player.field_70170_p.func_72956_a((Entity)player, "xreliquary:xload", 0.25f, 1.0f);
            }
            if (this.getBulletCount(ist) == 0) {
                this.setBulletType(ist, 0);
            }
            player.func_71034_by();
        }
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getItemUseDuration();
    }

    private int getItemUseDuration() {
        return 30;
    }

    private void fireBullet(ItemStack ist, World worldObj, EntityPlayer player) {
        if (!worldObj.field_72995_K) {
            switch (this.getBulletType(ist)) {
                case 0: {
                    return;
                }
                case 1: {
                    worldObj.func_72838_d((Entity)new EntityNeutralShot(worldObj, player));
                    break;
                }
                case 2: {
                    worldObj.func_72838_d((Entity)new EntityExorcismShot(worldObj, player));
                    break;
                }
                case 3: {
                    worldObj.func_72838_d((Entity)new EntityBlazeShot(worldObj, player));
                    break;
                }
                case 4: {
                    worldObj.func_72838_d((Entity)new EntityEnderShot(worldObj, player));
                    break;
                }
                case 5: {
                    worldObj.func_72838_d((Entity)new EntityConcussiveShot(worldObj, player));
                    break;
                }
                case 6: {
                    worldObj.func_72838_d((Entity)new EntityBusterShot(worldObj, player));
                    break;
                }
                case 7: {
                    worldObj.func_72838_d((Entity)new EntitySeekerShot(worldObj, player));
                    break;
                }
                case 8: {
                    worldObj.func_72838_d((Entity)new EntitySandShot(worldObj, player));
                    break;
                }
                case 9: {
                    worldObj.func_72838_d((Entity)new EntityStormShot(worldObj, player));
                }
            }
            worldObj.func_72956_a((Entity)player, "xreliquary:xshot", 0.2f, 1.2f);
            this.setLastFiredShotType(ist, this.getBulletType(ist));
            this.setBulletCount(ist, this.getBulletCount(ist) - 1);
            if (this.getBulletCount(ist) == 0) {
                this.setBulletType(ist, 0);
            }
            this.spawnCasing(player);
        }
    }

    private void spawnEmptyMagazine(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.magazine, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.magazine, 1, 0), 0.1f);
        }
    }

    private void spawnCasing(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.bullet, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.bullet, 1, 0), 0.1f);
        }
    }

    private boolean hasFilledMagazine(EntityPlayer player) {
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != ModItems.magazine || ist.func_77952_i() == 0) continue;
            return true;
        }
        return false;
    }

    private int getMagazineTypeAndRemoveOne(EntityPlayer player) {
        int bulletFound = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ModItems.magazine || player.field_71071_by.field_70462_a[slot].func_77952_i() == 0) continue;
            bulletFound = player.field_71071_by.field_70462_a[slot].func_77952_i();
            player.field_71071_by.func_70298_a(slot, 1);
            return bulletFound;
        }
        return bulletFound;
    }

    public boolean func_77662_d() {
        return true;
    }

    private int getPlayerReloadDelay(EntityPlayer player) {
        return 30 - Math.min(player.field_71068_ca, 20);
    }
}

