/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.HarvestRodPlayerProps;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.StackHelper;

public class ItemHarvestRod
extends ItemToggleable {
    public static final String BONE_MEAL_MODE = "bone_meal";
    public static final String PLANTABLE_MODE = "plantable";
    public static final String HOE_MODE = "hoe";
    public static final String MODE_NBT_TAG = "mode";
    public static final String PLANTABLE_INDEX_NBT_TAG = "plantable_index";
    public static final String PLANTABLE_QUANTITIES_NBT_TAG = "plantable_quantities";
    private static final int AOE_START_COOLDOWN = 10;

    public ItemHarvestRod() {
        super("harvest_rod");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(this.getBoneMealCount(ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.WHITE + Items.field_151100_aR.func_77653_i(new ItemStack(Items.field_151100_aR, 1, 15)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public int getBonemealLimit() {
        return Settings.HarvestRod.boneMealLimit;
    }

    public int getBonemealWorth() {
        return Settings.HarvestRod.boneMealWorth;
    }

    public int getBonemealCost() {
        return Settings.HarvestRod.boneMealCost;
    }

    public int getLuckRolls() {
        return Settings.HarvestRod.boneMealLuckRolls;
    }

    public int getLuckPercent() {
        return Settings.HarvestRod.boneMealLuckPercentChance;
    }

    public int getBreakRadius() {
        return Settings.HarvestRod.AOERadius;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist)) {
            if (this.getBoneMealCount(ist) + this.getBonemealWorth() <= this.getBonemealLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151100_aR, 1, 15), player)) {
                this.setBoneMealCount(ist, this.getBoneMealCount(ist) + this.getBonemealWorth());
            }
            this.consumePlantables(ist, player);
        }
    }

    private void consumePlantables(ItemStack harvestRod, EntityPlayer player) {
        ItemStack currentStack;
        for (int slot = 0; !(slot >= player.field_71071_by.field_70462_a.length || (currentStack = player.field_71071_by.field_70462_a[slot]) != null && currentStack.func_77973_b() instanceof IPlantable && this.addPlantableToInventory(currentStack, harvestRod, player)); ++slot) {
        }
    }

    private boolean addPlantableToInventory(ItemStack stack, ItemStack harvestRod, EntityPlayer player) {
        NBTTagList itemsList = harvestRod.func_77978_p().func_150295_c("Items", 10);
        boolean addedToExistingStack = false;
        for (byte i = 0; i < itemsList.func_74745_c(); i = (byte)(i + 1)) {
            NBTTagCompound item = itemsList.func_150305_b((int)i);
            ItemStack currentStack = ItemStack.func_77949_a((NBTTagCompound)item);
            if (!StackHelper.isItemAndNbtEqual(stack, currentStack)) continue;
            int itemQuantity = this.getPlantableQuantity(harvestRod, i);
            if (itemQuantity < Settings.HarvestRod.maxCapacityPerPlantable && InventoryHelper.consumeItem(stack, player, 0, 1)) {
                this.setPlantableQuantity(harvestRod, i, ++itemQuantity);
                itemsList.func_150304_a((int)i, (NBTBase)currentStack.serializeNBT());
                addedToExistingStack = true;
                continue;
            }
            return false;
        }
        if (addedToExistingStack || !InventoryHelper.consumeItem(stack, player, 0, 1)) {
            return false;
        }
        ItemStack newStack = stack.func_77946_l();
        this.setPlantableQuantity(harvestRod, (byte)itemsList.func_74745_c(), 1);
        itemsList.func_74742_a((NBTBase)newStack.serializeNBT());
        harvestRod.func_77978_p().func_74782_a("Items", (NBTBase)itemsList);
        return true;
    }

    private void removePlantableFromInventory(ItemStack harvestRod, byte idx) {
        NBTTagCompound tagCompound = harvestRod.func_77978_p();
        NBTTagList itemsList = tagCompound.func_150295_c("Items", 10);
        itemsList.func_74744_a((int)idx);
        harvestRod.func_77978_p().func_74782_a("Items", (NBTBase)itemsList);
        NBTTagList quantities = tagCompound.func_150295_c(PLANTABLE_QUANTITIES_NBT_TAG, 3);
        quantities.func_74744_a((int)idx);
        harvestRod.func_77978_p().func_74782_a(PLANTABLE_QUANTITIES_NBT_TAG, (NBTBase)quantities);
    }

    public boolean onBlockStartBreak(ItemStack ist, BlockPos pos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        boolean brokenBlock = false;
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IPlantable || block instanceof BlockCrops || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        this.doHarvestBlockBreak(block, ist, pos, player, xOff, yOff, zOff);
                        brokenBlock = true;
                    }
                }
            }
        }
        return brokenBlock;
    }

    public boolean doHarvestBlockBreak(Block initialBlock, ItemStack ist, BlockPos pos, EntityPlayer player, int xOff, int yOff, int zOff) {
        pos = pos.func_177982_a(xOff, yOff, zOff);
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if ((initialBlock == Blocks.field_150440_ba || initialBlock == Blocks.field_150423_aK) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (!(block instanceof IPlantable) && !(block instanceof BlockCrops) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (block instanceof BlockFertileLilypad) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            for (int particles = 0; particles <= 8; ++particles) {
                player.field_70170_p.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
            }
        } else {
            List drops = block.getDrops((IBlockAccess)player.field_70170_p, pos, blockState, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)ist));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
            player.func_71020_j(0.01f);
        }
        return true;
    }

    private void boneMealBlock(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        this.boneMealBlock(ist, player, world, pos, side, true);
    }

    private boolean boneMealBlock(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side, boolean updateCharge) {
        ItemStack fakeItemStack = new ItemStack(Items.field_151100_aR, 1, 15);
        ItemDye fakeItemDye = (ItemDye)fakeItemStack.func_77973_b();
        boolean usedRod = false;
        for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > this.getLuckPercent() || !fakeItemDye.func_180614_a(fakeItemStack, player, world, pos, side, 0.0f, 0.0f, 0.0f)) continue;
            if (!usedRod) {
                usedRod = true;
            }
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        }
        if (updateCharge && usedRod && !player.field_71075_bZ.field_75098_d) {
            this.setBoneMealCount(ist, this.getBoneMealCount(ist) - this.getBonemealCost());
        }
        return usedRod;
    }

    public int getBoneMealCount(ItemStack ist) {
        return NBTHelper.getInteger("bonemeal", ist);
    }

    public void setBoneMealCount(ItemStack ist, int boneMealCount) {
        NBTHelper.setInteger("bonemeal", ist, boneMealCount);
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            return super.func_77659_a(stack, world, player);
        }
        this.setupHarvestRodPlayerProps(player);
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    private void setupHarvestRodPlayerProps(EntityPlayer player) {
        if (HarvestRodPlayerProps.get(player) == null) {
            HarvestRodPlayerProps.register(player);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 300;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, player, true);
        if (mop != null) {
            HarvestRodPlayerProps props = HarvestRodPlayerProps.get(player);
            if (!player.field_71075_bZ.field_75098_d && props.getTimesUsed() > 0) {
                if (this.getMode(stack).equals(BONE_MEAL_MODE)) {
                    this.setBoneMealCount(stack, this.getBoneMealCount(stack) - props.getTimesUsed());
                } else if (this.getMode(stack).equals(PLANTABLE_MODE)) {
                    this.setPlantableQuantity(stack, this.getCurrentPlantableIndex(stack), this.getPlantableQuantity(stack, this.getCurrentPlantableIndex(stack)) - props.getTimesUsed());
                    this.removeEmptyPlantable(stack, this.getCurrentPlantableIndex(stack));
                }
            }
            BlockPos pos = mop.func_178782_a();
            if (this.getMode(stack).equals(BONE_MEAL_MODE)) {
                if (this.getBoneMealCount(stack) >= this.getBonemealCost() || player.field_71075_bZ.field_75098_d) {
                    this.boneMealBlock(stack, player, world, pos, EnumFacing.UP);
                }
            } else if (this.getMode(stack).equals(PLANTABLE_MODE) && (this.getPlantableQuantity(stack, this.getCurrentPlantableIndex(stack)) > 0 || player.field_71075_bZ.field_75098_d)) {
                this.plantItem(stack, player, pos);
            }
            props.reset();
        } else {
            this.removeStackFromCurrent(stack, player);
        }
    }

    private void removeStackFromCurrent(ItemStack stack, EntityPlayer player) {
        if (this.getMode(stack).equals(BONE_MEAL_MODE)) {
            ItemStack boneMealStack = new ItemStack(Items.field_151100_aR, 1, 15);
            int numberToAdd = Math.min(boneMealStack.func_77976_d(), this.getBoneMealCount(stack));
            int numberAdded = InventoryHelper.tryToAddToInventory(boneMealStack, (IInventory)player.field_71071_by, 0, numberToAdd);
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - numberAdded);
        } else if (this.getMode(stack).equals(PLANTABLE_MODE)) {
            byte idx = this.getCurrentPlantableIndex(stack);
            ItemStack plantableStack = this.getPlantableItems(stack).get(idx);
            int numberToAdd = Math.min(plantableStack.func_77976_d(), this.getPlantableQuantity(stack, idx));
            int numberAdded = InventoryHelper.tryToAddToInventory(plantableStack, (IInventory)player.field_71071_by, 0, numberToAdd);
            this.setPlantableQuantity(stack, idx, this.getPlantableQuantity(stack, idx) - numberAdded);
            this.removeEmptyPlantable(stack, idx);
        }
    }

    public void removeEmptyPlantable(ItemStack stack, byte idx) {
        if (this.getPlantableQuantity(stack, idx) <= 0) {
            this.removePlantableFromInventory(stack, idx);
            if (this.getPlantableItems(stack).size() > idx) {
                this.setCurrentPlantableIndex(stack, (byte)(idx - 1));
            }
            this.cycleMode(stack);
        }
    }

    private boolean plantItem(ItemStack stack, EntityPlayer player, BlockPos pos) {
        return this.plantItem(stack, player, pos, true);
    }

    private boolean plantItem(ItemStack stack, EntityPlayer player, BlockPos pos, boolean updateCharge) {
        byte idx = this.getCurrentPlantableIndex(stack);
        ItemStack fakePlantableStack = this.getPlantableItems(stack).get(idx).func_77946_l();
        fakePlantableStack.field_77994_a = 1;
        if (fakePlantableStack.func_179546_a(player, player.field_70170_p, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f)) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            if (updateCharge && !player.field_71075_bZ.field_75098_d) {
                this.setPlantableQuantity(stack, idx, this.getPlantableQuantity(stack, idx) - 1);
                this.removeEmptyPlantable(stack, idx);
            }
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        MovingObjectPosition mop;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isCoolDownOver(stack, count) && (mop = this.func_77621_a(player.field_70170_p, player, true)) != null) {
            World world = player.field_70170_p;
            HarvestRodPlayerProps props = HarvestRodPlayerProps.get(player);
            switch (this.getMode(stack)) {
                case "bone_meal": {
                    BlockPos blockToBoneMeal;
                    if (this.getBoneMealCount(stack) < this.getBonemealCost() * props.getTimesUsed() + 1 && !player.field_71075_bZ.field_75098_d || (blockToBoneMeal = this.getNextBlockToBoneMeal(world, props, mop.func_178782_a(), Settings.HarvestRod.AOERadius)) == null) break;
                    if (this.boneMealBlock(stack, player, world, blockToBoneMeal, EnumFacing.UP, false) && !player.field_71075_bZ.field_75098_d) {
                        props.incrementTimesUsed();
                    }
                    return;
                }
                case "plantable": {
                    BlockPos blockToPlantOn;
                    if (this.getPlantableQuantity(stack, this.getCurrentPlantableIndex(stack)) < props.getTimesUsed() + 1 && !player.field_71075_bZ.field_75098_d || (blockToPlantOn = this.getNextBlockToPlantOn(world, props, mop.func_178782_a(), Settings.HarvestRod.AOERadius, (IPlantable)this.getPlantableItems(stack).get(this.getCurrentPlantableIndex(stack)).func_77973_b())) == null) break;
                    if (this.plantItem(stack, player, blockToPlantOn, false) && !player.field_71075_bZ.field_75098_d) {
                        props.incrementTimesUsed();
                    }
                    return;
                }
                case "hoe": {
                    ItemStack fakeHoe = new ItemStack(Items.field_151017_I);
                    BlockPos blockToHoe = this.getNextBlockToHoe(world, props, mop.func_178782_a(), Settings.HarvestRod.AOERadius);
                    if (blockToHoe == null) break;
                    Items.field_151017_I.func_180614_a(fakeHoe, player, world, blockToHoe, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                    return;
                }
            }
        }
    }

    private BlockPos getNextBlockToHoe(World world, HarvestRodPlayerProps props, BlockPos pos, int range) {
        if (props.isQueueEmpty() || !pos.equals((Object)props.getStartBlockPos())) {
            this.fillQueueToHoe(world, props, pos, range);
        }
        return props.getNextBlockInQueue();
    }

    private void fillQueueToHoe(World world, HarvestRodPlayerProps props, BlockPos pos, int range) {
        props.setStartBlockPos(pos);
        props.clearBlockQueue();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    Block block = blockState.func_177230_c();
                    if (!world.func_175623_d(currentPos.func_177984_a()) || block != Blocks.field_150349_c && (block != Blocks.field_150346_d || blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT && blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.COARSE_DIRT)) continue;
                    props.addBlockToQueue(currentPos);
                }
            }
        }
    }

    private BlockPos getNextBlockToPlantOn(World world, HarvestRodPlayerProps props, BlockPos pos, int range, IPlantable plantable) {
        if (props.isQueueEmpty() || !pos.equals((Object)props.getStartBlockPos())) {
            this.fillQueueToPlant(world, props, pos, range, plantable);
        }
        return props.getNextBlockInQueue();
    }

    private void fillQueueToPlant(World world, HarvestRodPlayerProps props, BlockPos pos, int range, IPlantable plantable) {
        props.setStartBlockPos(pos);
        props.clearBlockQueue();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Items.field_151080_bb || plantable == Items.field_151081_bc) {
            checkerboard = true;
            boolean xEven = pos.func_177958_n() % 2 == 0;
            boolean zEven = pos.func_177952_p() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (checkerboard && bothOddOrEven != (currentPos.func_177958_n() % 2 == 0 == (currentPos.func_177952_p() % 2 == 0)) || !blockState.func_177230_c().canSustainPlant((IBlockAccess)world, pos, EnumFacing.UP, plantable) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                    props.addBlockToQueue(currentPos);
                }
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (entityLiving.func_70093_af()) {
            this.cycleMode(stack);
            return true;
        }
        return false;
    }

    private boolean isCoolDownOver(ItemStack stack, int count) {
        return this.func_77626_a(stack) - count >= 10 && (this.func_77626_a(stack) - count) % Settings.HarvestRod.AOECooldown == 0;
    }

    private BlockPos getNextBlockToBoneMeal(World world, HarvestRodPlayerProps props, BlockPos pos, int range) {
        if (props.isQueueEmpty() || !pos.equals((Object)props.getStartBlockPos())) {
            this.fillQueueToBoneMeal(world, props, pos, range);
        }
        return props.getNextBlockInQueue();
    }

    private void fillQueueToBoneMeal(World world, HarvestRodPlayerProps props, BlockPos pos, int range) {
        props.setStartBlockPos(pos);
        props.clearBlockQueue();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (!(blockState.func_177230_c() instanceof IGrowable) || !((IGrowable)blockState.func_177230_c()).func_176473_a(world, currentPos, blockState, world.field_72995_K)) continue;
                    props.addBlockToQueue(currentPos);
                }
            }
        }
    }

    private void cycleMode(ItemStack stack) {
        String currentMode = this.getMode(stack);
        List<ItemStack> items = this.getPlantableItems(stack);
        switch (currentMode) {
            case "bone_meal": {
                if (items.size() > 0) {
                    this.setMode(stack, PLANTABLE_MODE);
                    this.setCurrentPlantableIndex(stack, (byte)0);
                    break;
                }
                this.setMode(stack, HOE_MODE);
                break;
            }
            case "plantable": {
                if (items.size() > this.getCurrentPlantableIndex(stack) + 1) {
                    this.setCurrentPlantableIndex(stack, (byte)(this.getCurrentPlantableIndex(stack) + 1));
                    break;
                }
                this.setMode(stack, HOE_MODE);
                break;
            }
            case "hoe": {
                this.setMode(stack, BONE_MEAL_MODE);
                break;
            }
        }
    }

    public byte getCurrentPlantableIndex(ItemStack stack) {
        return stack.func_77978_p().func_74771_c(PLANTABLE_INDEX_NBT_TAG);
    }

    private void setCurrentPlantableIndex(ItemStack stack, byte index) {
        stack.func_77978_p().func_74774_a(PLANTABLE_INDEX_NBT_TAG, index);
    }

    private void setMode(ItemStack stack, String mode) {
        NBTHelper.setString(MODE_NBT_TAG, stack, mode);
    }

    public String getMode(ItemStack stack) {
        String mode = NBTHelper.getString(MODE_NBT_TAG, stack);
        return mode.equals("") ? BONE_MEAL_MODE : mode;
    }

    public List<ItemStack> getPlantableItems(ItemStack stack) {
        NBTTagList itemsList = stack.func_77978_p().func_150295_c("Items", 10);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < itemsList.func_74745_c(); ++i) {
            NBTTagCompound item = itemsList.func_150305_b(i);
            byte slotIndex = item.func_74771_c("Slot");
            if (slotIndex < 0) continue;
            items.add(ItemStack.func_77949_a((NBTTagCompound)item));
        }
        return items;
    }

    public int getPlantableQuantity(ItemStack stack, byte itemIndex) {
        NBTTagList plantableQuantities = stack.func_77978_p().func_150295_c(PLANTABLE_QUANTITIES_NBT_TAG, 3);
        if (plantableQuantities.func_82582_d() || plantableQuantities.func_74745_c() <= itemIndex) {
            return 0;
        }
        return ((NBTTagInt)plantableQuantities.func_179238_g((int)itemIndex)).func_150287_d();
    }

    public void setPlantableQuantity(ItemStack stack, byte itemIndex, int quantity) {
        NBTTagList plantableQuantities = stack.func_77978_p().func_150295_c(PLANTABLE_QUANTITIES_NBT_TAG, 3);
        for (byte currentSize = (byte)plantableQuantities.func_74745_c(); currentSize <= itemIndex; currentSize = (byte)(currentSize + 1)) {
            plantableQuantities.func_74742_a((NBTBase)new NBTTagInt(0));
        }
        plantableQuantities.func_150304_a((int)itemIndex, (NBTBase)new NBTTagInt(quantity));
        stack.func_77978_p().func_74782_a(PLANTABLE_QUANTITIES_NBT_TAG, (NBTBase)plantableQuantities);
    }
}

