/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemInfernalChalice
extends ItemToggleable
implements IFluidContainerItem {
    public ItemInfernalChalice() {
        super("infernal_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        String amount = Integer.toString(NBTHelper.getInteger("fluidStacks", ist));
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"amount", (Object)amount), ist, list);
    }

    protected int fluidLimit() {
        return Settings.InfernalChalice.fluidLimit;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            return super.func_77659_a(stack, world, player);
        }
        float movementThresholdCoefficient = 1.0f;
        double xOffset = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)movementThresholdCoefficient;
        double yOffset = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)movementThresholdCoefficient + (double)player.func_70047_e();
        double zOffset = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)movementThresholdCoefficient;
        boolean isInDrainMode = this.isEnabled(stack);
        MovingObjectPosition mop = this.func_77621_a(world, player, isInDrainMode);
        if (mop == null) {
            return stack;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            TileEntity tile;
            if (!world.func_175660_a(player, mop.func_178782_a())) {
                return stack;
            }
            if (!player.func_175151_a(mop.func_178782_a(), mop.field_178784_b, stack)) {
                return stack;
            }
            if (this.isEnabled(stack) && NBTHelper.getInteger("fluidStacks", stack) + 1000 <= this.fluidLimit()) {
                tile = world.func_175625_s(mop.func_178782_a());
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                    FluidStack simulatedDrainedFluid = ((IFluidHandler)tile).drain(mop.field_178784_b, fluid, false);
                    if (simulatedDrainedFluid.amount == 1000) {
                        NBTHelper.setInteger("fluidStacks", stack, NBTHelper.getInteger("fluidStacks", stack) - 1000);
                    }
                    return stack;
                }
            } else {
                tile = world.func_175625_s(mop.func_178782_a());
                if (tile instanceof IFluidHandler && NBTHelper.getInteger("fluidStacks", stack) >= 1000) {
                    FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
                    int amount = ((IFluidHandler)tile).fill(mop.field_178784_b, fluid, false);
                    if (amount == 1000) {
                        ((IFluidHandler)tile).fill(mop.field_178784_b, fluid, true);
                        NBTHelper.setInteger("fluidStacks", stack, NBTHelper.getInteger("fluidStacks", stack) - 1000);
                    }
                    return stack;
                }
            }
            String ident = RegistryHelper.getBlockRegistryName(world.func_180495_p(mop.func_178782_a()).func_177230_c());
            if (this.isEnabled(stack) && (ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150356_k)) || ident.equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150353_l)))) {
                if ((Integer)world.func_180495_p(mop.func_178782_a()).func_177229_b((IProperty)BlockStaticLiquid.field_176367_b) == 0) {
                    world.func_175656_a(mop.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                    NBTHelper.setInteger("fluidStacks", stack, NBTHelper.getInteger("fluidStacks", stack) + 1000);
                    return stack;
                }
            }
            if (!this.isEnabled(stack) && (NBTHelper.getInteger("fluidStacks", stack) >= 1000 || player.field_71075_bZ.field_75098_d)) {
                BlockPos adjustedPos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
                if (!player.func_175151_a(adjustedPos, mop.field_178784_b, stack)) {
                    return stack;
                }
                if (this.tryPlaceContainedLiquid(world, stack, xOffset, yOffset, zOffset, adjustedPos) && !player.field_71075_bZ.field_75098_d) {
                    NBTHelper.setInteger("fluidStacks", stack, NBTHelper.getInteger("fluidStacks", stack) - 1000);
                    return stack;
                }
            }
        }
        return stack;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack ist, double par2, double par4, double par6, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_177230_c().func_149688_o();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150356_k.func_176223_P(), 3);
        return true;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.isEnabled(container)) {
            return null;
        }
        return new FluidStack(FluidRegistry.LAVA, NBTHelper.getInteger("fluidStacks", container));
    }

    public int getCapacity(ItemStack container) {
        if (this.isEnabled(container)) {
            return this.fluidLimit() - NBTHelper.getInteger("fluidStacks", container);
        }
        return this.fluidLimit();
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (!this.isEnabled(container) || resource == null) {
            return 0;
        }
        if (!resource.isFluidEqual(new FluidStack(FluidRegistry.LAVA, 1000))) {
            return 0;
        }
        int toFill = Math.min(this.fluidLimit() - NBTHelper.getInteger("fluidStacks", container), resource.amount);
        if (doFill) {
            int fluidLevel = NBTHelper.getInteger("fluidStacks", container);
            NBTHelper.setInteger("fluidStacks", container, fluidLevel += toFill);
        }
        return toFill;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.isEnabled(container)) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.LAVA, Math.min(NBTHelper.getInteger("fluidStacks", container), maxDrain));
        if (doDrain) {
            NBTHelper.setInteger("fluidStacks", container, NBTHelper.getInteger("fluidStacks", container) - stack.amount);
        }
        return stack;
    }
}

