/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.StackHelper;

public class ItemVoidTear
extends ItemToggleable {
    public ItemVoidTear() {
        super("void_tear");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        this.formatTooltip(null, stack, list);
        ItemStack contents = this.getContainedItem(stack);
        if (contents == null) {
            return;
        }
        if (this.isEnabled(stack)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.YELLOW + contents.func_82833_r())), stack, list);
            list.add(LanguageHelper.getLocalization("tooltip.absorb_tear"));
        }
        LanguageHelper.formatTooltip("tooltip.tear_quantity", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)contents.func_82833_r(), (Object)"amount", (Object)Integer.toString(NBTHelper.getInteger("itemQuantity", stack))), stack, list);
    }

    @Override
    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (NBTHelper.getInteger("itemQuantity", ist) == 0) {
                return new ItemStack((Item)ModItems.emptyVoidTear, 1, 0);
            }
            MovingObjectPosition movingObjectPosition = this.func_77621_a(world, player, false);
            if (movingObjectPosition != null && movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_175625_s(movingObjectPosition.func_178782_a()) instanceof IInventory && player.func_70093_af()) {
                return ist;
            }
            if (player.func_70093_af()) {
                return super.func_77659_a(ist, world, player);
            }
            if (this.attemptToEmptyIntoInventory(ist, player, (IInventory)player.field_71071_by, player.field_71071_by.field_70462_a.length)) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                NBTHelper.resetTag(ist);
                return new ItemStack((Item)ModItems.emptyVoidTear, 1, 0);
            }
        }
        player.field_71069_bz.func_75142_b();
        return ist;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean f) {
        if (!world.field_72995_K) {
            if (!this.isEnabled(stack) || !(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack contents = this.getContainedItem(stack);
            int itemQuantity = InventoryHelper.getItemQuantity(contents, (IInventory)player.field_71071_by);
            if (NBTHelper.getInteger("itemQuantity", stack) < Settings.VoidTear.itemLimit && itemQuantity > contents.func_77976_d() && InventoryHelper.consumeItem(contents, player, contents.func_77976_d(), itemQuantity - contents.func_77976_d()) && !player.field_71075_bZ.field_75098_d) {
                NBTHelper.setInteger("itemQuantity", stack, NBTHelper.getInteger("itemQuantity", stack) + itemQuantity - contents.func_77976_d());
            }
            this.attemptToReplenishSingleStack(player, stack);
        }
    }

    public void attemptToReplenishSingleStack(EntityPlayer player, ItemStack ist) {
        int preferredSlot = -1;
        int stackCount = 0;
        InventoryPlayer inventory = player.field_71071_by;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stackFound = inventory.func_70301_a(slot);
            if (stackFound == null || !StackHelper.isItemAndNbtEqual(stackFound, this.getContainedItem(ist))) continue;
            if (preferredSlot == -1) {
                preferredSlot = slot;
            }
            ++stackCount;
        }
        if (preferredSlot == -1 && (preferredSlot = player.field_71071_by.func_70447_i()) > -1) {
            stackCount = 1;
        }
        if (stackCount == 1 && preferredSlot != -1 && NBTHelper.getInteger("itemQuantity", ist) > 1) {
            ItemStack stackToIncrease = player.field_71071_by.func_70301_a(preferredSlot);
            if (stackToIncrease == null) {
                int quantityToDecrease;
                ItemStack newStack = this.getContainedItem(ist).func_77946_l();
                newStack.field_77994_a = quantityToDecrease = Math.min(newStack.func_77976_d(), NBTHelper.getInteger("itemQuantity", ist) - 1);
                player.field_71071_by.func_70299_a(preferredSlot, newStack);
                NBTHelper.setInteger("itemQuantity", ist, NBTHelper.getInteger("itemQuantity", ist) - quantityToDecrease);
                return;
            }
            if (stackToIncrease.field_77994_a < stackToIncrease.func_77976_d()) {
                int quantityToDecrease = Math.min(stackToIncrease.func_77976_d() - stackToIncrease.field_77994_a, NBTHelper.getInteger("itemQuantity", ist) - 1);
                stackToIncrease.field_77994_a += quantityToDecrease;
                NBTHelper.setInteger("itemQuantity", ist, NBTHelper.getInteger("itemQuantity", ist) - quantityToDecrease);
            }
        }
    }

    public boolean onItemUseFirst(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_175625_s(pos);
            if (inventory instanceof TileEntityChest && world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
                inventory = ((BlockChest)world.func_180495_p(pos).func_177230_c()).func_180676_d(world, pos);
            }
            if (this.isEnabled(ist)) {
                this.drainInventory(ist, player, inventory);
            } else {
                this.attemptToEmptyIntoInventory(ist, player, inventory, 0);
                if (!player.func_70093_af() && NBTHelper.getInteger("itemQuantity", ist) <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack getContainedItem(ItemStack ist) {
        if (NBTHelper.getString("itemID", ist).equals("") && (NBTHelper.getTagCompound("item", ist) == null || NBTHelper.getTagCompound("item", ist).func_82582_d())) {
            return null;
        }
        if (!NBTHelper.getString("itemID", ist).equals("")) {
            return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(NBTHelper.getString("itemID", ist))), NBTHelper.getInteger("itemQuantity", ist));
        }
        ItemStack stackToReturn = ItemStack.func_77949_a((NBTTagCompound)NBTHelper.getTagCompound("item", ist));
        stackToReturn.field_77994_a = NBTHelper.getInteger("itemQuantity", ist);
        return stackToReturn;
    }

    protected boolean attemptToEmptyIntoInventory(ItemStack ist, EntityPlayer player, IInventory inventory, int limit) {
        ItemStack contents = this.getContainedItem(ist);
        contents.field_77994_a = 1;
        int quantity = NBTHelper.getInteger("itemQuantity", ist);
        int maxNumberToEmpty = player.func_70093_af() ? quantity : Math.min(contents.func_77976_d(), quantity);
        NBTHelper.setInteger("itemQuantity", ist, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, limit, maxNumberToEmpty));
        if (quantity == 0) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        return false;
    }

    protected void drainInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        int quantity;
        ItemStack contents = this.getContainedItem(ist);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, Settings.VoidTear.itemLimit - (quantity = NBTHelper.getInteger("itemQuantity", ist)));
        if (quantityDrained <= 0) {
            return;
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        NBTHelper.setInteger("itemQuantity", ist, quantity + quantityDrained);
    }
}

