/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.NBTHelper;

public class ItemVoidTearEmpty
extends ItemBase {
    public ItemVoidTearEmpty() {
        super("void_tear_empty");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(16);
        this.canRepair = false;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        ItemStack createdTear;
        if (!world.field_72995_K && (createdTear = this.buildTear(ist, player, (IInventory)player.field_71071_by, true)) != null) {
            --ist.field_77994_a;
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            if (ist.field_77994_a == 0) {
                return createdTear;
            }
            this.addItemToInventory(player, createdTear);
        }
        return ist;
    }

    public boolean onItemUseFirst(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof IInventory) {
            ItemStack createdTear;
            IInventory inventory = (IInventory)world.func_175625_s(pos);
            if (inventory instanceof TileEntityChest && world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
                inventory = ((BlockChest)world.func_180495_p(pos).func_177230_c()).func_180676_d(world, pos);
            }
            if ((createdTear = this.buildTear(ist, player, inventory, false)) != null) {
                --ist.field_77994_a;
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                if (ist.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, createdTear);
                } else {
                    this.addItemToInventory(player, createdTear);
                }
                return true;
            }
        }
        return false;
    }

    protected void addItemToInventory(EntityPlayer player, ItemStack ist) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            player.field_71071_by.func_70299_a(i, ist);
            return;
        }
        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, ist));
    }

    protected ItemStack buildTear(ItemStack ist, EntityPlayer player, IInventory inventory, boolean isPlayerInventory) {
        ItemStack target = InventoryHelper.getTargetItem(ist, inventory, false);
        if (target == null) {
            return null;
        }
        ItemStack filledTear = new ItemStack((Item)ModItems.filledVoidTear, 1, 0);
        NBTHelper.setTagCompound("item", filledTear, target.func_77955_b(new NBTTagCompound()));
        int quantity = InventoryHelper.getItemQuantity(target, inventory);
        if (isPlayerInventory) {
            if (quantity - target.func_77976_d() > 0) {
                InventoryHelper.consumeItem(target, player, target.func_77976_d(), quantity - target.func_77976_d());
                quantity -= target.func_77976_d();
            } else {
                quantity = 0;
            }
        } else {
            quantity = InventoryHelper.tryToRemoveFromInventory(target, inventory, Settings.VoidTear.itemLimit);
        }
        NBTHelper.setInteger("itemQuantity", filledTear, quantity);
        NBTHelper.setBoolean("enabled", filledTear, Settings.VoidTear.absorbWhenCreated);
        return filledTear;
    }
}

