/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModBlocks;
import xreliquary.items.block.ItemBlockBase;
import xreliquary.reference.Settings;

public class ItemFertileLilyPad
extends ItemBlockBase {
    public ItemFertileLilyPad(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        boolean blockPlaced = false;
        if (mop != null) {
            blockPlaced = this.TryPlacingLilyPad(stack, world, player, mop);
        }
        if (!blockPlaced) {
            return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(worldIn, playerIn, true);
        if (movingobjectposition == null) {
            return itemStackIn;
        }
        if (!this.TryPlacingLilyPad(itemStackIn, worldIn, playerIn, movingobjectposition)) {
            return itemStackIn;
        }
        return itemStackIn;
    }

    private boolean TryPlacingLilyPad(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, MovingObjectPosition movingobjectposition) {
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos blockpos = movingobjectposition.func_178782_a();
            if (!worldIn.func_175660_a(playerIn, blockpos)) {
                return true;
            }
            if (!playerIn.func_175151_a(blockpos.func_177972_a(movingobjectposition.field_178784_b), movingobjectposition.field_178784_b, itemStackIn)) {
                return true;
            }
            BlockPos blockpos1 = blockpos.func_177984_a();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c().func_149688_o() == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && worldIn.func_175623_d(blockpos1)) {
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((World)worldIn, (BlockPos)blockpos1);
                worldIn.func_175656_a(blockpos1, ModBlocks.fertileLilypad.func_176223_P());
                if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)playerIn, (BlockSnapshot)blocksnapshot, (EnumFacing)EnumFacing.UP).isCanceled()) {
                    blocksnapshot.restore(true, false);
                    return false;
                }
                int secondsBetweenGrowthTicks = Settings.FertileLilypad.secondsBetweenGrowthTicks;
                worldIn.func_180497_b(blockpos1, (Block)ModBlocks.fertileLilypad, secondsBetweenGrowthTicks * 20, 1);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --itemStackIn.field_77994_a;
                }
            }
        }
        return true;
    }
}

