/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketHarvestRodExtPropsSync;

public class HarvestRodPlayerProps
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "HarvestRodPlayerProps";
    private BlockPos startBlockPos;
    private Queue<BlockPos> blockQueue;
    private int timesUsed;
    private EntityPlayer player;

    public HarvestRodPlayerProps(EntityPlayer player) {
        this.player = player;
        this.blockQueue = new ArrayDeque<BlockPos>();
    }

    public void setStartBlockPos(BlockPos pos) {
        this.startBlockPos = pos;
    }

    public BlockPos getStartBlockPos() {
        return this.startBlockPos;
    }

    public void addBlockToQueue(BlockPos pos) {
        this.blockQueue.add(pos);
    }

    public BlockPos getNextBlockInQueue() {
        return this.blockQueue.poll();
    }

    public void clearBlockQueue() {
        this.blockQueue.clear();
    }

    public boolean isQueueEmpty() {
        return this.blockQueue.isEmpty();
    }

    public void incrementTimesUsed() {
        ++this.timesUsed;
        this.sync();
    }

    public int getTimesUsed() {
        return this.timesUsed;
    }

    public void setTimesUsed(int timesUsed) {
        this.timesUsed = timesUsed;
    }

    public void reset() {
        this.startBlockPos = null;
        this.blockQueue.clear();
        this.timesUsed = 0;
        this.sync();
    }

    private void sync() {
        if (!this.player.field_70170_p.field_72995_K) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketHarvestRodExtPropsSync(this.getTimesUsed()), (EntityPlayerMP)this.player);
        }
    }

    public static final HarvestRodPlayerProps get(EntityPlayer player) {
        return (HarvestRodPlayerProps)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new HarvestRodPlayerProps(player));
    }

    public void saveNBTData(NBTTagCompound compound) {
    }

    public void loadNBTData(NBTTagCompound compound) {
    }

    public void init(Entity entity, World world) {
    }
}

