/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import xreliquary.util.RegistryHelper;
import xreliquary.util.StackHelper;

public class InventoryHelper {
    public static void removeItem(ItemStack stack, IInventory inventory, int quantity) {
        InventoryHelper.removeItem(stack, inventory, quantity, -1);
    }

    public static void removeItem(ItemStack stack, IInventory inventory, int quantity, int limit) {
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            ItemStack ist = inventory.func_70301_a(slot);
            if (ist == null || !StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), stack)) continue;
            while (quantity > 0 && inventory.func_70301_a(slot) != null) {
                inventory.func_70298_a(slot, 1);
                --quantity;
            }
        }
        inventory.func_70296_d();
    }

    public static ItemStack getTargetItem(ItemStack self, IInventory inventory, boolean disposeOfItem) {
        ItemStack targetItem = null;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || StackHelper.isItemAndNbtEqual(self, stack) || stack.func_77976_d() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
            if (!disposeOfItem) continue;
            inventory.func_70298_a(slot, 1);
        }
        inventory.func_70296_d();
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IInventory inventory) {
        return InventoryHelper.getItemQuantity(stack, inventory, 0);
    }

    public static int getItemQuantity(ItemStack stack, IInventory inventory, int limit) {
        int itemQuantity = 0;
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            ItemStack newStack = inventory.func_70301_a(slot);
            if (newStack == null || !StackHelper.isItemAndNbtEqual(stack, newStack)) continue;
            itemQuantity += newStack.field_77994_a;
        }
        return itemQuantity;
    }

    public static boolean consumeItem(Object item, EntityPlayer player) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, 0, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount, int amountDecreased) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, amountDecreased);
    }

    public static boolean consumeItem(Object[] itemList, EntityPlayer player, int minCount, int amountDecreased) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemList.length == 0 || !(itemList[0] instanceof ItemStack) && !(itemList[0] instanceof Item) && !(itemList[0] instanceof Block)) {
            return false;
        }
        ArrayList<Integer> suggestedSlots = new ArrayList<Integer>();
        int itemCount = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            ItemStack slotStack = player.field_71071_by.field_70462_a[slot];
            for (Object stack : itemList) {
                if (!(stack instanceof ItemStack && StackHelper.isItemAndNbtEqual(slotStack, (ItemStack)stack) || stack instanceof Block && RegistryHelper.itemsEqual(Item.func_150898_a((Block)((Block)stack)), slotStack.func_77973_b())) && (!(stack instanceof Item) || !RegistryHelper.itemsEqual((Item)stack, slotStack.func_77973_b()))) continue;
                itemCount += player.field_71071_by.field_70462_a[slot].field_77994_a;
                suggestedSlots.add(slot);
            }
        }
        int count = amountDecreased;
        if (suggestedSlots.size() > 0 && itemCount >= minCount + amountDecreased) {
            Iterator iterator = suggestedSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                int stackSize = player.field_71071_by.func_70301_a((int)slot).field_77994_a;
                if (stackSize >= count) {
                    player.field_71071_by.func_70298_a(slot, count);
                    return true;
                }
                player.field_71071_by.func_70298_a(slot, stackSize);
                count -= stackSize;
            }
        }
        return false;
    }

    public static int tryToRemoveFromInventory(ItemStack contents, IInventory inventory, int maxToRemove) {
        int numberRemoved = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null) continue;
            while (inventory.func_70301_a(slot) != null && StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents) && maxToRemove > numberRemoved) {
                numberRemoved += Math.min(maxToRemove - numberRemoved, inventory.func_70301_a((int)slot).field_77994_a);
                inventory.func_70298_a(slot, Math.min(maxToRemove, inventory.func_70301_a((int)slot).field_77994_a));
            }
            if (numberRemoved < maxToRemove) continue;
            return numberRemoved;
        }
        return numberRemoved;
    }

    public static int tryToAddToInventory(ItemStack contents, IInventory inventory, int limit, int maxToAdd) {
        int numberAdded = 0;
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            int stackAddition;
            if (inventory.func_70301_a(slot) == null) {
                while (inventory.func_70301_a(slot) == null && maxToAdd > numberAdded) {
                    ItemStack newContents = contents.func_77946_l();
                    newContents.field_77994_a = stackAddition = Math.min(Math.min(newContents.func_77976_d(), inventory.func_70297_j_()), maxToAdd - numberAdded);
                    inventory.func_70299_a(slot, newContents);
                    numberAdded += stackAddition;
                }
            } else if (StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents)) {
                if (inventory.func_70301_a((int)slot).field_77994_a == Math.min(inventory.func_70301_a(slot).func_77976_d(), inventory.func_70297_j_())) continue;
                ItemStack slotStack = inventory.func_70301_a(slot);
                stackAddition = Math.min(Math.min(slotStack.func_77976_d(), inventory.func_70297_j_()) - slotStack.field_77994_a, maxToAdd - numberAdded);
                slotStack.field_77994_a += stackAddition;
                numberAdded += stackAddition;
            }
            if (numberAdded >= maxToAdd) break;
        }
        if (numberAdded > 0) {
            inventory.func_70296_d();
        }
        return numberAdded;
    }

    public static void tryRemovingLastStack(IInventory inventory, World worldObj, BlockPos pos) {
        for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            inventory.func_70299_a(i, null);
            if (worldObj.field_72995_K) {
                return;
            }
            inventory.func_70296_d();
            EntityItem itemEntity = new EntityItem(worldObj, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            worldObj.func_72838_d((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(EntityPlayer player, IInventory inventory) {
        if (inventory.func_70301_a(0) != null) {
            return false;
        }
        inventory.func_70299_a(0, player.func_71045_bC().func_77946_l());
        --player.func_71045_bC().field_77994_a;
        if (player.func_71045_bC().field_77994_a == 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        player.field_71071_by.func_70296_d();
        return true;
    }
}

