/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

public class RegistryHelper {
    public static Item getItemFromName(String registryName) {
        return (Item)GameData.getItemRegistry().getObject(new ResourceLocation(registryName));
    }

    public static String getItemRegistryName(Item item) {
        ResourceLocation rl = GameData.getItemRegistry().getNameForObject((Object)item);
        if (rl != null) {
            return rl.toString();
        }
        return "";
    }

    public static Block getBlockFromName(String registryName) {
        return (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(registryName));
    }

    public static String getBlockRegistryName(Block block) {
        return GameData.getBlockRegistry().getNameForObject((Object)block).toString();
    }

    public static boolean blocksEqual(Block block1, Block block2) {
        return RegistryHelper.getBlockRegistryName(block1).equals(RegistryHelper.getBlockRegistryName(block2));
    }

    public static boolean itemsEqual(Item item1, Item item2) {
        return RegistryHelper.getItemRegistryName(item1).equals(RegistryHelper.getItemRegistryName(item2));
    }
}

