/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import net.minecraft.entity.player.EntityPlayer;

public class XpHelper {
    public static final int RATIO = 20;

    public static int liquidToExperience(int liquid) {
        return liquid / 20;
    }

    public static int experienceToLiquid(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return XpHelper.experienceToLiquid(XpHelper.getExperienceForLevel(level));
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (XpHelper.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)XpHelper.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = XpHelper.getPlayerXP(player) + amount;
        player.field_71068_ca = XpHelper.getLevelForExperience(experience);
        int expForLevel = XpHelper.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }
}

