/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.pedestal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.init.ModFluids;
import xreliquary.reference.Settings;

public class PedestalBucketWrapper
implements IPedestalActionItemWrapper {
    private List<BlockPos> queueToDrain = new ArrayList<BlockPos>();
    private Fluid currentFluid;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int bucketRange;
        BlockPos pos = pedestal.getBlockPos();
        if (!this.milkCows(pedestal, pos, bucketRange = Settings.Pedestal.bucketWrapperRange) && !this.drainLiquid(pedestal, pos, bucketRange)) {
            pedestal.setActionCoolDown(2 * Settings.Pedestal.bucketWrapperCooldown);
            return;
        }
        pedestal.setActionCoolDown(Settings.Pedestal.bucketWrapperCooldown);
    }

    private boolean drainLiquid(IPedestal pedestal, BlockPos pos, int bucketRange) {
        FluidStack fluidStack;
        World world = pedestal.getTheWorld();
        if (this.queueToDrain.isEmpty()) {
            this.updateQueueToDrain(world, pos, bucketRange);
        }
        if (this.queueToDrain.isEmpty()) {
            return false;
        }
        BlockPos blockToDrain = this.queueToDrain.get(0);
        IBlockState blockState = world.func_180495_p(blockToDrain);
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
        if (fluid != null && (fluidStack = this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, false)) != null) {
            if (pedestal.fillConnectedTank(fluidStack, false) != fluidStack.amount) {
                return false;
            }
            this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, true);
            pedestal.fillConnectedTank(fluidStack);
        }
        this.queueToDrain.remove(0);
        return true;
    }

    private void updateQueueToDrain(World world, BlockPos pos, int bucketRange) {
        for (int y = pos.func_177956_o() + bucketRange; y >= pos.func_177956_o() - bucketRange; --y) {
            for (int x = pos.func_177958_n() - bucketRange; x <= pos.func_177958_n() + bucketRange; ++x) {
                for (int z = pos.func_177952_p() - bucketRange; z <= pos.func_177952_p() + bucketRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentBlockPos);
                    Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
                    if (fluid == null || !this.canDrainBlock(world, currentBlockPos, blockState.func_177230_c(), blockState, fluid) || fluid != this.currentFluid && !this.queueToDrain.isEmpty()) continue;
                    if (this.queueToDrain.isEmpty()) {
                        this.currentFluid = fluid;
                    }
                    this.queueToDrain.add(currentBlockPos);
                }
            }
        }
    }

    private boolean canDrainBlock(World world, BlockPos pos, Block block, IBlockState blockState, Fluid fluid) {
        return this.drainBlock(world, pos, block, blockState, fluid, false) != null;
    }

    private FluidStack drainBlock(World world, BlockPos pos, Block block, IBlockState blockState, Fluid fluid, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (!fluidBlock.canDrain(world, pos)) {
                return null;
            }
            return fluidBlock.drain(world, pos, doDrain);
        }
        if (block instanceof BlockLiquid) {
            int level = (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (level != 0) {
                return null;
            }
            if (doDrain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    private boolean milkCows(IPedestal pedestal, BlockPos pos, int bucketRange) {
        int fluidAdded;
        World world = pedestal.getTheWorld();
        List entities = world.func_72872_a(EntityCow.class, new AxisAlignedBB((double)(pos.func_177958_n() - bucketRange), (double)(pos.func_177956_o() - bucketRange), (double)(pos.func_177952_p() - bucketRange), (double)(pos.func_177958_n() + bucketRange), (double)(pos.func_177956_o() + bucketRange), (double)(pos.func_177952_p() + bucketRange)));
        if (entities.size() == 0) {
            return false;
        }
        EntityCow cow = (EntityCow)entities.get(world.field_73012_v.nextInt(entities.size()));
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        fakePlayer.func_70062_b(0, new ItemStack(Items.field_151133_ar));
        cow.func_70085_c((EntityPlayer)fakePlayer);
        if (fakePlayer.func_71045_bC().func_77973_b() == Items.field_151117_aB && (fluidAdded = pedestal.fillConnectedTank(new FluidStack(ModFluids.milk, 1000))) == 0) {
            pedestal.replaceCurrentItem(new ItemStack(Items.field_151117_aB));
            return true;
        }
        return true;
    }
}

