/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.pedestal;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalMeleeWeaponWrapper
implements IPedestalActionItemWrapper {
    private byte swingDuration;
    private byte cooldownAfterSwing;

    public PedestalMeleeWeaponWrapper() {
        this(6, Settings.Pedestal.meleeWrapperCooldown);
    }

    public PedestalMeleeWeaponWrapper(byte swingDuration) {
        this(swingDuration, 5);
    }

    public PedestalMeleeWeaponWrapper(byte swingDuration, byte cooldownAfterSwing) {
        this.swingDuration = swingDuration;
        this.cooldownAfterSwing = cooldownAfterSwing;
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        if (!fakePlayer.func_71039_bw()) {
            World world = pedestal.getTheWorld();
            BlockPos pos = pedestal.getBlockPos();
            int meleeRange = Settings.Pedestal.meleeWrapperRange;
            List entities = world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)(pos.func_177958_n() - meleeRange), (double)(pos.func_177956_o() - meleeRange), (double)(pos.func_177952_p() - meleeRange), (double)(pos.func_177958_n() + meleeRange), (double)(pos.func_177956_o() + meleeRange), (double)(pos.func_177952_p() + meleeRange)));
            if (entities.size() == 0) {
                pedestal.setActionCoolDown(40);
                return;
            }
            EntityLiving entityToAttack = (EntityLiving)entities.get(world.field_73012_v.nextInt(entities.size()));
            if (entityToAttack instanceof IBossDisplayData) {
                return;
            }
            fakePlayer.func_70107_b((double)pos.func_177958_n(), 0.0, (double)pos.func_177952_p());
            fakePlayer.func_70062_b(0, stack);
            fakePlayer.func_70071_h_();
            fakePlayer.func_71059_n((Entity)entityToAttack);
            pedestal.setActionCoolDown(this.swingDuration + this.cooldownAfterSwing);
            if (stack.field_77994_a == 0) {
                pedestal.destroyCurrentItem();
            }
        }
    }

    public class Slow
    extends PedestalMeleeWeaponWrapper {
        public Slow() {
            super((byte)10);
        }
    }
}

