/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.pedestal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import xreliquary.api.IPedestalItemWrapper;
import xreliquary.util.LogHelper;

public class PedestalRegistry {
    private static final PedestalRegistry INSTANCE = new PedestalRegistry();
    private static final Map<LocationKey, BlockPos> positions = new HashMap<LocationKey, BlockPos>();
    private Map<Class<? extends Item>, Class<? extends IPedestalItemWrapper>> itemWrappers = new HashMap<Class<? extends Item>, Class<? extends IPedestalItemWrapper>>();
    private Map<Class<? extends Block>, Class<? extends IPedestalItemWrapper>> blockWrappers = new HashMap<Class<? extends Block>, Class<? extends IPedestalItemWrapper>>();

    public static void registerItemWrapper(Class<? extends Item> itemClass, Class<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.itemWrappers.put(itemClass, wrapperClass);
    }

    public static void registerItemBlockWrapper(Class<? extends Block> blockClass, Class<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.blockWrappers.put(blockClass, wrapperClass);
    }

    public static IPedestalItemWrapper getItemWrapper(ItemStack item) {
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.itemWrappers.keySet()) {
            if (!clazz.isInstance(item.func_77973_b())) continue;
            try {
                return PedestalRegistry.INSTANCE.itemWrappers.get(clazz).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LogHelper.error("Error instantiating pedestal action item wrapper for " + clazz.getName());
            }
        }
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.blockWrappers.keySet()) {
            if (!(item.func_77973_b() instanceof ItemBlock) || !clazz.isInstance(((ItemBlock)item.func_77973_b()).func_179223_d())) continue;
            try {
                return PedestalRegistry.INSTANCE.blockWrappers.get(clazz).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LogHelper.error("Error instantiating pedestal action item wrapper for " + clazz.getName());
            }
        }
        return null;
    }

    public static void registerPosition(int dimensionId, BlockPos pos) {
        LocationKey key = new LocationKey(dimensionId, pos.func_177986_g());
        if (!positions.containsKey(key)) {
            positions.put(key, pos);
        }
    }

    public static void unregisterPosition(int dimensionId, BlockPos pos) {
        positions.remove(new LocationKey(dimensionId, pos.func_177986_g()));
    }

    public static void clearPositions() {
        positions.clear();
    }

    public static List<BlockPos> getPositionsInRange(int dimensionId, BlockPos startPos, int range) {
        return PedestalRegistry.getPositionsInRange(dimensionId, startPos, range, range, range);
    }

    public static List<BlockPos> getPositionsInRange(int dimensionId, BlockPos startPos, int xRange, int yRange, int zRange) {
        ArrayList<BlockPos> positionsInRange = new ArrayList<BlockPos>();
        for (Map.Entry<LocationKey, BlockPos> position : positions.entrySet()) {
            BlockPos pos;
            if (position.getKey().getDimensionId() != dimensionId || (pos = position.getValue()).func_177958_n() < startPos.func_177958_n() - xRange || pos.func_177958_n() > startPos.func_177958_n() + xRange || pos.func_177956_o() < startPos.func_177956_o() - yRange || pos.func_177956_o() > startPos.func_177956_o() + yRange || pos.func_177952_p() < startPos.func_177952_p() - zRange || pos.func_177952_p() > startPos.func_177952_p() + zRange) continue;
            positionsInRange.add(pos);
        }
        return positionsInRange;
    }

    private static class LocationKey {
        private int dimensionId;
        private long location;

        public LocationKey(int dimensionId, long location) {
            this.dimensionId = dimensionId;
            this.location = location;
        }

        public int hashCode() {
            return Long.hashCode(this.location + (long)this.dimensionId);
        }

        public boolean equals(Object o) {
            LocationKey key2 = (LocationKey)o;
            return this.getDimensionId() == key2.getDimensionId() && this.getLocation() == key2.getLocation();
        }

        public int getDimensionId() {
            return this.dimensionId;
        }

        public long getLocation() {
            return this.location;
        }
    }
}

