/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xreliquary.util.potions.EffectComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class PotionEssence
extends PotionIngredient {
    public static int MAX_DURATION = 36000;
    public static int MAX_AMPLIFIER = 4;
    public List<PotionIngredient> ingredients = new ArrayList<PotionIngredient>();
    private int redstoneCount = 0;
    private int glowstoneCount = 0;
    private NBTTagCompound preAugmentationNBT = null;

    public PotionEssence(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        for (int tagIndex = 0; tagIndex < tag.func_150295_c("effects", 10).func_74745_c(); ++tagIndex) {
            NBTTagCompound effect = tag.func_150295_c("effects", 10).func_150305_b(tagIndex);
            this.effects.add(new PotionEffect(effect.func_74762_e("id"), effect.func_74762_e("duration"), effect.func_74762_e("potency")));
        }
    }

    public PotionEssence(PotionIngredient ... ingredients) {
        HashMap potionEffectCounterList = new HashMap();
        ArrayList<Integer> potionEffectList = new ArrayList<Integer>();
        for (PotionIngredient ingredient : ingredients) {
            for (PotionEffect effect : ingredient.getEffects()) {
                if (potionEffectCounterList.keySet().contains(effect.func_76456_a())) {
                    if (!potionEffectList.contains(effect.func_76456_a())) {
                        potionEffectList.add(effect.func_76456_a());
                    }
                    ((List)potionEffectCounterList.get(effect.func_76456_a())).add(effect);
                    continue;
                }
                ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                effects.add(effect);
                potionEffectCounterList.put(effect.func_76456_a(), effects);
            }
            this.ingredients.add(ingredient);
        }
        for (Integer potionID : potionEffectList) {
            List effects = (List)potionEffectCounterList.get(potionID);
            int duration = this.getCombinedDuration(effects);
            int amplifier = this.getCombinedAmplifier(effects);
            if (duration == 0) continue;
            this.effects.add(new PotionEffect(potionID.intValue(), duration, amplifier));
        }
        this.effects.sort(new EffectComparator());
    }

    private int getCombinedAmplifier(List<PotionEffect> effects) {
        int amplifier = 0;
        for (PotionEffect effect : effects) {
            amplifier += effect.func_76458_c();
        }
        return Math.min(amplifier, MAX_AMPLIFIER);
    }

    private int getCombinedDuration(List<PotionEffect> effects) {
        int count = 0;
        int duration = 0;
        for (PotionEffect effect : effects) {
            if (Potion.field_76425_a[effect.func_76456_a()].func_76403_b()) {
                return 1;
            }
            ++count;
            duration += effect.func_76459_b();
        }
        duration = (int)((double)duration / 1.2);
        if (count == 3) {
            duration = (int)((double)duration / 1.1);
        }
        return Math.min(duration, MAX_DURATION);
    }

    public void addRedstone(int redstoneLevel) {
        this.updatePreAugmentationNBT();
        ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
        int effectCnt = this.effects.size();
        double multiplier = (double)(8 + effectCnt) / (double)(3 + effectCnt) - 1.0 / (double)(3 + effectCnt) * ((double)redstoneLevel - 1.0);
        for (PotionEffect effect : this.effects) {
            int newDuration = new Double((double)effect.func_76459_b() * multiplier).intValue();
            newDuration = Math.min(newDuration, MAX_DURATION * 2);
            PotionEffect newEffect = new PotionEffect(effect.func_76456_a(), newDuration, effect.func_76458_c(), effect.func_82720_e(), effect.func_180154_f());
            newEffects.add(newEffect);
        }
        this.effects = newEffects;
        ++this.redstoneCount;
    }

    private void updatePreAugmentationNBT() {
        if (this.preAugmentationNBT == null) {
            this.preAugmentationNBT = this.writeToNBT();
        }
    }

    public void addGlowstone(int glowstoneLevel) {
        this.updatePreAugmentationNBT();
        ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
        int effectCnt = this.effects.size();
        double multiplier = (double)(11 + effectCnt) / (double)(6 + effectCnt) - 1.0 / (double)(6 + effectCnt) * (double)glowstoneLevel - 1.0;
        for (PotionEffect effect : this.effects) {
            int newAmplifier = effect.func_76458_c();
            if (XRPotionHelper.isAugmentablePotionEffect(effect)) {
                newAmplifier = Math.min(effect.func_76458_c() + 1, MAX_AMPLIFIER + 1);
            }
            PotionEffect newEffect = new PotionEffect(effect.func_76456_a(), new Double((double)effect.func_76459_b() * multiplier).intValue(), newAmplifier, effect.func_82720_e(), effect.func_180154_f());
            newEffects.add(newEffect);
        }
        this.effects = newEffects;
        ++this.glowstoneCount;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (tag.func_150295_c("effects", 10) == null) {
            return null;
        }
        NBTTagList effectList = tag.func_150295_c("effects", 10);
        for (PotionEffect object : this.effects) {
            NBTTagCompound effect = new NBTTagCompound();
            effect.func_74768_a("id", object.func_76456_a());
            effect.func_74768_a("duration", Potion.field_76425_a[object.func_76456_a()].func_76403_b() ? 1 : object.func_76459_b());
            effect.func_74768_a("potency", object.func_76458_c());
            effectList.func_74742_a((NBTBase)effect);
        }
        tag.func_74782_a("effects", (NBTBase)effectList);
        return tag;
    }

    public void apply(EntityPlayer player) {
        for (PotionEffect effect : this.effects) {
            player.func_70690_d(effect);
        }
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    public int getGlowstoneCount() {
        return this.glowstoneCount;
    }

    public NBTTagCompound getPreAugmentationNBT() {
        this.updatePreAugmentationNBT();
        return this.preAugmentationNBT;
    }
}

