/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import xreliquary.items.ItemPotionEssence;
import xreliquary.reference.Settings;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionIngredient;

public class XRPotionHelper {
    private static int[] nonAugmentableEffects = new int[]{Potion.field_76440_q.func_76396_c(), Potion.field_76431_k.func_76396_c(), Potion.field_76441_p.func_76396_c(), Potion.field_76439_r.func_76396_c(), Potion.field_76427_o.func_76396_c()};

    public static boolean isItemEssence(ItemStack ist) {
        return ist.func_77973_b() instanceof ItemPotionEssence;
    }

    public static boolean isItemIngredient(ItemStack ist) {
        for (PotionIngredient ingredient : Settings.Potions.potionMap) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals(ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static int getPotionIdByName(String name) {
        for (Potion potion : Potion.field_76425_a) {
            if (potion == null || !potion.func_76393_a().equals("potion." + name)) continue;
            return potion.func_76396_c();
        }
        return 0;
    }

    public static PotionIngredient getIngredient(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            return new PotionEssence(ist.func_77978_p());
        }
        for (PotionIngredient ingredient : Settings.Potions.potionMap) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals(ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return ingredient;
        }
        return null;
    }

    public static boolean isAugmentablePotionEffect(PotionEffect effect) {
        for (int i = 0; i < nonAugmentableEffects.length; ++i) {
            if (nonAugmentableEffects[i] != effect.func_76456_a()) continue;
            return false;
        }
        return true;
    }

    public static void addPotionInfo(PotionEssence essence, List list) {
        XRPotionHelper.addPotionInfo(essence, list, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void addPotionInfo(PotionEssence essence, List list, boolean addEffectDescription) {
        if (essence.getEffects().size() > 0) {
            HashMultimap hashmultimap = HashMultimap.create();
            if (essence.getEffects() != null && !essence.getEffects().isEmpty()) {
                for (PotionEffect potioneffect : essence.getEffects()) {
                    String s1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                    Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                    Map map = potion.func_111186_k();
                    if (map != null && map.size() > 0) {
                        for (Map.Entry entry : map.entrySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                            hashmultimap.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1);
                        }
                    }
                    if (potioneffect.func_76458_c() > 0) {
                        s1 = s1 + " " + (potioneffect.func_76458_c() + 1);
                    }
                    if (potioneffect.func_76459_b() > 20) {
                        s1 = s1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                    }
                    if (potion.func_76398_f()) {
                        list.add(EnumChatFormatting.RED + s1);
                        continue;
                    }
                    list.add(EnumChatFormatting.GRAY + s1);
                }
            } else {
                String s = StatCollector.func_74838_a((String)"potion.empty").trim();
                list.add(EnumChatFormatting.GRAY + s);
            }
            if (!hashmultimap.isEmpty() && addEffectDescription) {
                list.add("");
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
                Iterator<Object> iterator1 = hashmultimap.entries().iterator();
                while (iterator1.hasNext()) {
                    void var4_4;
                    Map.Entry entry1 = (Map.Entry)var4_4.next();
                    AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                }
            }
        }
    }
}

