/*
 * Decompiled with CFR 0.152.
 */
package xreliquary;

import net.minecraft.block.BlockCompressedPowered;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.item.Cleaver;
import xreliquary.CreativeTabXR;
import xreliquary.common.CommonProxy;
import xreliquary.compat.ICompat;
import xreliquary.handler.ConfigurationHandler;
import xreliquary.handler.config.PotionConfiguration;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModCapabilities;
import xreliquary.init.ModCompat;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.init.ModLoot;
import xreliquary.init.ModPotions;
import xreliquary.init.ModSounds;
import xreliquary.items.ItemHarvestRod;
import xreliquary.items.ItemRendingGale;
import xreliquary.network.PacketHandler;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;
import xreliquary.util.alkahestry.AlkahestCraftRecipe;
import xreliquary.util.pedestal.PedestalBucketWrapper;
import xreliquary.util.pedestal.PedestalHarvestRodWrapper;
import xreliquary.util.pedestal.PedestalMeleeWeaponWrapper;
import xreliquary.util.pedestal.PedestalRedstoneWrapper;
import xreliquary.util.pedestal.PedestalRegistry;
import xreliquary.util.pedestal.PedestalRendingGaleWrapper;
import xreliquary.util.pedestal.PedestalShearsWrapper;

@Mod(modid="xreliquary", name="Reliquary", version="1.9.4-1.3.2.404", guiFactory="xreliquary.client.gui.GuiFactory", dependencies="after:jeresources@[0.3.4,)", acceptedMinecraftVersions="[1.9.4]")
public class Reliquary {
    @Mod.Instance(value="xreliquary")
    public static Reliquary INSTANCE;
    @SidedProxy(clientSide="xreliquary.client.ClientProxy", serverSide="xreliquary.common.CommonProxy")
    public static CommonProxy PROXY;
    public static CreativeTabs CREATIVE_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        PROXY.initColors();
        ModBlocks.init();
        ModItems.init();
        ModFluids.init();
        ModLoot.init();
        ModPotions.init();
        ModCapabilities.init();
        ModSounds.init();
        PROXY.preInit();
        PotionConfiguration.loadPotionMap();
        PROXY.initPotionsJEI();
        PacketHandler.init();
        ModCompat.registerModCompat();
        ModCompat.loadCompat(ICompat.InitializationPhase.PRE_INIT, null);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModCompat.loadCompat(ICompat.InitializationPhase.INIT, null);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit();
        ConfigurationHandler.postInit();
        ModCompat.loadCompat(ICompat.InitializationPhase.POST_INIT, null);
        ModFluids.postInit();
        PedestalRegistry.registerItemWrapper(ItemSword.class, PedestalMeleeWeaponWrapper.class);
        PedestalRegistry.registerItemWrapper(ItemBucket.class, PedestalBucketWrapper.class);
        PedestalRegistry.registerItemWrapper(ItemShears.class, PedestalShearsWrapper.class);
        PedestalRegistry.registerItemWrapper(ItemRendingGale.class, PedestalRendingGaleWrapper.class);
        PedestalRegistry.registerItemWrapper(ItemHarvestRod.class, PedestalHarvestRodWrapper.class);
        PedestalRegistry.registerItemWrapper(ItemRedstone.class, PedestalRedstoneWrapper.Toggleable.class);
        PedestalRegistry.registerItemBlockWrapper(BlockCompressedPowered.class, PedestalRedstoneWrapper.AlwaysOn.class);
        if (Loader.isModLoaded((String)"tconstruct")) {
            PedestalRegistry.registerItemWrapper(Cleaver.class, PedestalMeleeWeaponWrapper.class);
            PedestalRegistry.registerItemWrapper(BroadSword.class, PedestalMeleeWeaponWrapper.class);
        }
        LogHelper.info("Loaded successfully!");
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equals("Alkahest")) continue;
            NBTTagCompound tag = message.getNBTValue();
            if (tag != null && ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")) != null && tag.func_74764_b("yield") && tag.func_74764_b("cost")) {
                if (tag.func_74764_b("dictionaryName")) {
                    Settings.AlkahestryTome.craftingRecipes.put("OreDictionary:" + tag.func_74779_i("dictionaryName"), new AlkahestCraftRecipe(tag.func_74779_i("dictionaryName"), tag.func_74762_e("yield"), tag.func_74762_e("cost")));
                } else {
                    Settings.AlkahestryTome.craftingRecipes.put(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")).func_77973_b().getRegistryName().toString(), new AlkahestCraftRecipe(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")), tag.func_74762_e("yield"), tag.func_74762_e("cost")));
                }
                LogHelper.info("[IMC] Added AlkahestRecipe ID: " + Item.field_150901_e.func_177774_c((Object)ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")).func_77973_b()) + " from " + message.getSender() + " to registry.");
                continue;
            }
            LogHelper.warn("[IMC] Invalid AlkahestRecipe from " + message.getSender() + "! Please contact the mod author if you see this error occurring.");
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        PedestalRegistry.clearPositions();
    }

    static {
        CREATIVE_TAB = new CreativeTabXR(CreativeTabs.getNextID(), "xreliquary");
    }
}

