/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.api.IPedestalItemWrapper;
import xreliquary.api.IPedestalRedstoneItem;
import xreliquary.api.IPedestalRedstoneItemWrapper;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.init.ModBlocks;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.util.InventoryHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.XRFakePlayerFactory;
import xreliquary.util.pedestal.PedestalRegistry;

public class TileEntityPedestal
extends TileEntityPedestalPassive
implements IPedestal,
IFluidHandler,
ITickable {
    private boolean tickable = false;
    private int[] actionCooldowns = new int[0];
    private int currentItemIndex;
    private Map<Integer, IPedestalActionItem> actionItems = new HashMap<Integer, IPedestalActionItem>();
    private Map<Integer, IPedestalActionItemWrapper> itemWrappers = new HashMap<Integer, IPedestalActionItemWrapper>();
    private Map<Integer, IPedestalRedstoneItem> redstoneItems = new HashMap<Integer, IPedestalRedstoneItem>();
    private Map<Integer, IItemHandler> itemHandlers = new HashMap<Integer, IItemHandler>();
    private List<ItemStack> fluidContainers = new ArrayList<ItemStack>();
    private boolean switchedOn = false;
    private List<Long> onSwitches = new ArrayList<Long>();
    private boolean enabledInitialized = false;
    private boolean powered = false;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.switchedOn = tag.func_74767_n("SwitchedOn");
        this.powered = tag.func_74767_n("Powered");
        NBTTagList onLocations = tag.func_150295_c("OnSwitches", 4);
        this.onSwitches.clear();
        for (int i = 0; i < onLocations.func_74745_c(); ++i) {
            this.onSwitches.add(((NBTTagLong)onLocations.func_179238_g(i)).func_150291_c());
        }
        this.updateSpecialItems();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("SwitchedOn", this.switchedOn);
        compound.func_74757_a("Powered", this.powered);
        NBTTagList onLocations = new NBTTagList();
        for (int i = 0; i < this.onSwitches.size(); ++i) {
            onLocations.func_74742_a((NBTBase)new NBTTagLong(this.onSwitches.get(i).longValue()));
        }
        compound.func_74782_a("OnSwitches", (NBTBase)onLocations);
        return compound;
    }

    public void func_70296_d() {
        for (IItemHandler itemHandler : this.itemHandlers.values()) {
            if (!(itemHandler instanceof FilteredItemStackHandler)) continue;
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
            filteredHandler.markDirty();
        }
        super.func_70296_d();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.unregisterPosition(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        }
        super.onChunkUnload();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.registerPosition(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        }
        super.onLoad();
    }

    private void updateSpecialItems() {
        this.tickable = false;
        this.fluidContainers.clear();
        this.itemWrappers.clear();
        this.actionItems.clear();
        this.redstoneItems.clear();
        this.itemHandlers.clear();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack item = this.inventory[i];
            if (item == null) continue;
            if (item.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                this.itemHandlers.put(i, (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            }
            if (item.func_77973_b() instanceof IPedestalActionItem) {
                this.tickable = true;
                this.actionItems.put(i, (IPedestalActionItem)item.func_77973_b());
            } else if (item.func_77973_b() instanceof IPedestalRedstoneItem) {
                this.redstoneItems.put(i, (IPedestalRedstoneItem)item.func_77973_b());
            } else {
                IPedestalItemWrapper wrapper = PedestalRegistry.getItemWrapper(item);
                if (wrapper != null) {
                    if (wrapper instanceof IPedestalActionItemWrapper) {
                        this.tickable = true;
                        this.itemWrappers.put(i, (IPedestalActionItemWrapper)wrapper);
                    }
                    if (wrapper instanceof IPedestalRedstoneItemWrapper) {
                        this.redstoneItems.put(i, (IPedestalRedstoneItem)((Object)wrapper));
                    }
                }
            }
            if (!(item.func_77973_b() instanceof IFluidContainerItem)) continue;
            this.fluidContainers.add(item);
        }
        this.actionCooldowns = new int[this.inventory.length];
        Arrays.fill(this.actionCooldowns, 0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.enabledInitialized) {
            this.enabledInitialized = true;
            this.neighborUpdate();
        }
        if (this.tickable && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPedestal.ENABLED)).booleanValue()) {
            this.currentItemIndex = 0;
            while (this.currentItemIndex < this.inventory.length) {
                if (this.actionCooldowns[this.currentItemIndex] > 0) {
                    int n = this.currentItemIndex;
                    this.actionCooldowns[n] = this.actionCooldowns[n] - 1;
                } else {
                    ItemStack item = this.inventory[this.currentItemIndex];
                    if (this.actionItems.containsKey(this.currentItemIndex)) {
                        this.actionItems.get(this.currentItemIndex).update(item, this);
                    } else if (this.itemWrappers.containsKey(this.currentItemIndex)) {
                        this.itemWrappers.get(this.currentItemIndex).update(this.inventory[this.currentItemIndex], this);
                    }
                }
                ++this.currentItemIndex;
            }
        }
    }

    public void neighborUpdate() {
        if (this.powered != this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.powered) {
                this.switchOn(null);
            } else {
                this.switchOff(null);
            }
        }
        this.updateRedstone();
    }

    public void updateRedstone() {
        this.currentItemIndex = 0;
        while (this.currentItemIndex < this.inventory.length) {
            if (this.redstoneItems.containsKey(this.currentItemIndex)) {
                this.redstoneItems.get(this.currentItemIndex).updateRedstone(this.inventory[this.currentItemIndex], this);
            }
            ++this.currentItemIndex;
        }
    }

    @Override
    public World getTheWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public int addToConnectedInventory(ItemStack stack) {
        List<IInventory> adjacentInventories = this.getAdjacentInventories();
        int sizeAdded = 0;
        for (IInventory inventory : adjacentInventories) {
            if ((sizeAdded += InventoryHelper.tryToAddToInventory(stack, inventory, 0, stack.field_77994_a - sizeAdded)) >= stack.field_77994_a) break;
        }
        return sizeAdded;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack, boolean doFill) {
        List<IFluidHandler> adjacentTanks = this.getAdjacentTanks();
        int fluidFilled = 0;
        FluidStack copy = fluidStack.copy();
        for (IFluidHandler tank : adjacentTanks) {
            if (tank.fill(EnumFacing.UP, copy, false) != copy.amount) continue;
            if ((fluidFilled += tank.fill(EnumFacing.UP, copy, doFill)) >= fluidStack.amount) break;
            copy.amount = fluidStack.amount - fluidFilled;
        }
        return fluidFilled;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack) {
        return this.fillConnectedTank(fluidStack, true);
    }

    @Override
    public void setActionCoolDown(int coolDownTicks) {
        if (this.currentItemIndex < this.actionCooldowns.length) {
            this.actionCooldowns[this.currentItemIndex] = coolDownTicks;
        }
    }

    @Override
    public FakePlayer getFakePlayer() {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        WorldServer world = (WorldServer)this.field_145850_b;
        return XRFakePlayerFactory.get(world);
    }

    @Override
    public void destroyCurrentItem() {
        this.func_70299_a(this.currentItemIndex, null);
    }

    @Override
    public void replaceCurrentItem(ItemStack stack) {
        this.func_70299_a(this.currentItemIndex, stack);
    }

    @Override
    public List<BlockPos> getPedestalsInRange(int range) {
        return PedestalRegistry.getPositionsInRange(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, range);
    }

    @Override
    public void switchOn(BlockPos switchedOnFrom) {
        if (switchedOnFrom != null && !this.onSwitches.contains(switchedOnFrom.func_177986_g())) {
            this.onSwitches.add(switchedOnFrom.func_177986_g());
        }
        this.setEnabled(true);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    @Override
    public void switchOff(BlockPos switchedOffFrom) {
        if (switchedOffFrom != null) {
            this.onSwitches.remove(switchedOffFrom.func_177986_g());
        }
        if (!this.switchedOn && !this.powered && this.onSwitches.size() == 0) {
            this.setEnabled(false);
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    private void setEnabled(boolean switchedOn) {
        ModBlocks.pedestal.setEnabled(this.field_145850_b, this.field_174879_c, switchedOn);
    }

    public List<IInventory> getAdjacentInventories() {
        BlockPos south = this.func_174877_v().func_177971_a(EnumFacing.SOUTH.func_176730_m());
        BlockPos north = this.func_174877_v().func_177971_a(EnumFacing.NORTH.func_176730_m());
        BlockPos east = this.func_174877_v().func_177971_a(EnumFacing.EAST.func_176730_m());
        BlockPos west = this.func_174877_v().func_177971_a(EnumFacing.WEST.func_176730_m());
        ArrayList<IInventory> adjacentInventories = new ArrayList<IInventory>();
        IInventory inventory = this.getInventoryAtPos(south);
        if (inventory != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(north)) != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(east)) != null) {
            adjacentInventories.add(inventory);
        }
        if ((inventory = this.getInventoryAtPos(west)) != null) {
            adjacentInventories.add(inventory);
        }
        return adjacentInventories;
    }

    private IInventory getInventoryAtPos(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) instanceof IInventory) {
            return (IInventory)this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    public List<IFluidHandler> getAdjacentTanks() {
        BlockPos south = this.func_174877_v().func_177971_a(EnumFacing.SOUTH.func_176730_m());
        BlockPos north = this.func_174877_v().func_177971_a(EnumFacing.NORTH.func_176730_m());
        BlockPos east = this.func_174877_v().func_177971_a(EnumFacing.EAST.func_176730_m());
        BlockPos west = this.func_174877_v().func_177971_a(EnumFacing.WEST.func_176730_m());
        ArrayList<IFluidHandler> adjacentTanks = new ArrayList<IFluidHandler>();
        IFluidHandler tank = this.getTankAtPos(south);
        if (tank != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(north)) != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(east)) != null) {
            adjacentTanks.add(tank);
        }
        if ((tank = this.getTankAtPos(west)) != null) {
            adjacentTanks.add(tank);
        }
        return adjacentTanks;
    }

    private IFluidHandler getTankAtPos(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) instanceof IFluidHandler) {
            return (IFluidHandler)this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int totalFilled = 0;
        FluidStack resourceCopy = resource.copy();
        for (ItemStack container : this.fluidContainers) {
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            resourceCopy.amount = resource.amount - (totalFilled += fluidContainer.fill(container, resourceCopy, doFill));
            if (totalFilled < resource.amount) continue;
            break;
        }
        return totalFilled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        int totalDrained = 0;
        for (ItemStack container : this.fluidContainers) {
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            FluidStack drainedStack = fluidContainer.drain(container, resource.amount - totalDrained, doDrain);
            if ((totalDrained += drainedStack.amount) < resource.amount) continue;
            break;
        }
        return new FluidStack(resource.getFluid(), totalDrained);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.fluidContainers.size() == 0) {
            return null;
        }
        ItemStack container = this.fluidContainers.get(0);
        Fluid fluid = this.getContainerFluid(container);
        return this.drain(from, new FluidStack(fluid, maxDrain), doDrain);
    }

    private Fluid getContainerFluid(ItemStack container) {
        return ((IFluidContainerItem)container.func_77973_b()).getFluid(container).getFluid();
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.fluidContainers.size() == 0) {
            return false;
        }
        for (ItemStack container : this.fluidContainers) {
            if (((IFluidContainerItem)container.func_77973_b()).fill(container, new FluidStack(fluid, 1), false) != 1) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.fluidContainers.size() == 0) {
            return false;
        }
        for (ItemStack container : this.fluidContainers) {
            if (((IFluidContainerItem)container.func_77973_b()).drain(container, 1, false) != new FluidStack(fluid, 1)) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[this.fluidContainers.size()];
        for (int i = 0; i < this.fluidContainers.size(); ++i) {
            ItemStack container = this.fluidContainers.get(i);
            IFluidContainerItem fluidContainer = (IFluidContainerItem)container.func_77973_b();
            tankInfo[i] = new FluidTankInfo(fluidContainer.getFluid(container), fluidContainer.getCapacity(container));
        }
        return tankInfo;
    }

    public void removeRedstoneItems() {
        for (Map.Entry<Integer, IPedestalRedstoneItem> item : this.redstoneItems.entrySet()) {
            item.getValue().onRemoved(this.inventory[item.getKey()], this);
        }
    }

    @Override
    public int func_70302_i_() {
        int itemHandlerSlots = 0;
        for (IItemHandler itemHandler : this.itemHandlers.values()) {
            itemHandlerSlots += itemHandler.getSlots();
        }
        return this.slots + itemHandlerSlots;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (slot < this.slots) {
            return this.inventory[slot];
        }
        int adjustedSlot = slot - this.slots;
        Tuple<IItemHandler, Integer> handlerSlot = this.getHandlerSlot(adjustedSlot);
        return handlerSlot == null ? null : ((IItemHandler)handlerSlot.func_76341_a()).getStackInSlot(((Integer)handlerSlot.func_76340_b()).intValue());
    }

    private Tuple<IItemHandler, Integer> getHandlerSlot(int origSlot) {
        Tuple handlerSlot = null;
        int adjustedSlot = origSlot;
        for (IItemHandler itemHandler : this.itemHandlers.values()) {
            if (adjustedSlot < itemHandler.getSlots()) {
                handlerSlot = new Tuple((Object)itemHandler, (Object)adjustedSlot);
                break;
            }
            adjustedSlot -= itemHandler.getSlots();
        }
        return handlerSlot;
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        if (slot < this.slots) {
            return this.decrStackInInventory(slot, count);
        }
        int adjustedSlot = slot - this.slots;
        Tuple<IItemHandler, Integer> handlerSlot = this.getHandlerSlot(adjustedSlot);
        return ((IItemHandler)handlerSlot.func_76341_a()).extractItem(((Integer)handlerSlot.func_76340_b()).intValue(), count, false);
    }

    private ItemStack decrStackInInventory(int slot, int count) {
        if (this.inventory[slot] != null) {
            ItemStack stack;
            if (this.inventory[slot].field_77994_a > count) {
                stack = this.inventory[slot].func_77979_a(count);
            } else {
                stack = this.inventory[slot];
                if (this.redstoneItems.containsKey(slot)) {
                    this.redstoneItems.get(slot).onRemoved(this.inventory[slot], this);
                }
                this.inventory[slot] = null;
                this.updateItemsAndBlock();
            }
            return stack;
        }
        return null;
    }

    private void updateItemsAndBlock() {
        this.updateSpecialItems();
        this.updateRedstone();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != ModBlocks.pedestal || newState.func_177230_c() != ModBlocks.pedestal;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (slot < this.slots) {
            ItemStack stack = this.inventory[slot];
            if (this.redstoneItems.containsKey(slot)) {
                this.redstoneItems.get(slot).onRemoved(this.inventory[slot], this);
            }
            this.inventory[slot] = null;
            this.updateItemsAndBlock();
            return stack;
        }
        int adjustedSlot = slot - this.slots;
        Tuple<IItemHandler, Integer> handlerSlot = this.getHandlerSlot(adjustedSlot);
        ItemStack stack = ((IItemHandler)handlerSlot.func_76341_a()).getStackInSlot(((Integer)handlerSlot.func_76340_b()).intValue());
        return ((IItemHandler)handlerSlot.func_76341_a()).extractItem(((Integer)handlerSlot.func_76340_b()).intValue(), stack.field_77994_a, false);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.slots) {
            IPedestalRedstoneItem removedRedstoneItem = null;
            if (stack == null && this.redstoneItems.containsKey(slot)) {
                removedRedstoneItem = this.redstoneItems.get(slot);
            }
            this.inventory[slot] = stack;
            if (stack != null && stack.field_77994_a > 1) {
                stack.field_77994_a = 1;
            }
            this.updateItemsAndBlock();
            if (removedRedstoneItem != null) {
                removedRedstoneItem.onRemoved(this.inventory[slot], this);
            }
            return;
        }
        int adjustedSlot = slot - this.slots;
        Tuple<IItemHandler, Integer> handlerSlot = this.getHandlerSlot(adjustedSlot);
        IItemHandler itemHandler = (IItemHandler)handlerSlot.func_76341_a();
        ItemStack stackInSlot = itemHandler.getStackInSlot(adjustedSlot = ((Integer)handlerSlot.func_76340_b()).intValue());
        if (stackInSlot != null && stack != null && !StackHelper.isItemAndNbtEqual(stack, stackInSlot)) {
            return;
        }
        if (stackInSlot != null && (stack == null || stack.field_77994_a < stackInSlot.field_77994_a)) {
            int amount = stackInSlot.field_77994_a - (stack == null ? 0 : stack.field_77994_a);
            itemHandler.extractItem(adjustedSlot, amount, false);
        } else if (stack != null && (stackInSlot == null || stack.field_77994_a > stackInSlot.field_77994_a)) {
            int amount;
            stack.field_77994_a = amount = stack.field_77994_a - (stackInSlot == null ? 0 : stackInSlot.field_77994_a);
            itemHandler.insertItem(adjustedSlot, stack, false);
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (super.func_94041_b(index, stack)) {
            return true;
        }
        int adjustedSlot = index - this.slots;
        Tuple<IItemHandler, Integer> handlerSlot = this.getHandlerSlot(adjustedSlot);
        IItemHandler itemHandler = (IItemHandler)handlerSlot.func_76341_a();
        ItemStack returnedStack = itemHandler.insertItem(adjustedSlot = ((Integer)handlerSlot.func_76340_b()).intValue(), stack, true);
        return returnedStack == null || returnedStack.field_77994_a != stack.field_77994_a;
    }

    public void toggleSwitch() {
        boolean bl = this.switchedOn = !this.switchedOn;
        if (this.switchedOn) {
            this.switchOn(null);
        } else {
            this.switchOff(null);
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public List<Long> getOnSwitches() {
        return this.onSwitches;
    }

    public boolean isSwitchedOn() {
        return this.switchedOn;
    }
}

