/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.client.init.ItemBlockModels;
import xreliquary.client.init.ItemModels;
import xreliquary.client.init.ModBlockColors;
import xreliquary.client.init.ModItemColors;
import xreliquary.client.render.RenderApothecaryMortar;
import xreliquary.client.render.RenderShot;
import xreliquary.client.render.RenderThrown;
import xreliquary.client.render.RenderThrownKrakenSlime;
import xreliquary.client.render.RenderThrownXRPotion;
import xreliquary.client.render.TileEntityPedestalPassiveRenderer;
import xreliquary.client.render.TileEntityPedestalRenderer;
import xreliquary.common.CommonProxy;
import xreliquary.compat.jei.descriptions.JEIDescriptionRegistry;
import xreliquary.entities.EntityEnderStaffProjectile;
import xreliquary.entities.EntityGlowingWater;
import xreliquary.entities.EntityHolyHandGrenade;
import xreliquary.entities.EntityKrakenSlime;
import xreliquary.entities.EntitySpecialSnowball;
import xreliquary.entities.potion.EntityAttractionPotion;
import xreliquary.entities.potion.EntityFertilePotion;
import xreliquary.entities.potion.EntityThrownXRPotion;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.handler.ClientEventHandler;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.potions.PotionEssence;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerJEI(Block block, String name) {
        this.registerJEI(block, name, false);
    }

    @Override
    public void registerJEI(Block block, String name, boolean oneDescription) {
        if (Loader.isModLoaded((String)"JEI")) {
            if (oneDescription) {
                ArrayList<ItemStack> subBlocks = new ArrayList<ItemStack>();
                block.func_149666_a(Item.func_150898_a((Block)block), null, subBlocks);
                JEIDescriptionRegistry.register(subBlocks, name);
            } else {
                JEIDescriptionRegistry.register(Item.func_150898_a((Block)block), name);
            }
        }
    }

    @Override
    public void initPotionsJEI() {
        if (!Loader.isModLoaded((String)"JEI")) {
            return;
        }
        ArrayList<ItemStack> subItems = new ArrayList<ItemStack>();
        ModItems.potionEssence.func_150895_a(ModItems.potionEssence, ModItems.potionEssence.func_77640_w(), subItems);
        JEIDescriptionRegistry.register(subItems, "potion_essence");
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        ArrayList<ItemStack> splashPotions = new ArrayList<ItemStack>();
        for (PotionEssence essence : Settings.Potions.uniquePotions) {
            ItemStack potion = new ItemStack((Item)ModItems.potion, 1);
            potion.func_77982_d(essence.writeToNBT());
            NBTHelper.setBoolean("hasPotion", potion, true);
            potions.add(potion);
            ItemStack splashPotion = potion.func_77946_l();
            NBTHelper.setBoolean("splash", splashPotion, true);
            splashPotions.add(splashPotion);
        }
        JEIDescriptionRegistry.register(potions, "potion");
        JEIDescriptionRegistry.register(splashPotions, "potion_splash");
    }

    @Override
    public void registerJEI(Item item, String name) {
        if (Loader.isModLoaded((String)"JEI")) {
            JEIDescriptionRegistry.register(item, name);
        }
    }

    @Override
    public void preInit() {
        super.preInit();
        ItemBlockModels.registerItemBlockModels();
        ItemModels.registerItemModels();
    }

    @Override
    public void init() {
        super.init();
        ModItemColors.init();
        ModBlockColors.init();
        FMLCommonHandler.instance().bus().register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModFluids());
        this.registerRenderers();
    }

    public void registerRenderers() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityBusterShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityConcussiveShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityExorcismShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityNeutralShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySeekerShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySandShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityStormShot.class, new RenderShot(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityGlowingWater.class, new RenderThrown(renderManager, ModItems.glowingWater, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityAttractionPotion.class, new RenderThrown(renderManager, ModItems.attractionPotion, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityFertilePotion.class, new RenderThrown(renderManager, ModItems.fertilePotion, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityHolyHandGrenade.class, new RenderThrown(renderManager, ModItems.holyHandGrenade, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityKrakenSlime.class, (Render)new RenderThrownKrakenSlime(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpecialSnowball.class, (Render)new RenderSnowball(renderManager, Items.field_151126_ay, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderStaffProjectile.class, (Render)new RenderSnowball(renderManager, Items.field_151079_bi, renderItem));
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownXRPotion.class, (Render)new RenderThrownXRPotion(renderManager, renderItem));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMortar.class, (TileEntitySpecialRenderer)new RenderApothecaryMortar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPedestal.class, (TileEntitySpecialRenderer)new TileEntityPedestalRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPedestalPassive.class, (TileEntitySpecialRenderer)new TileEntityPedestalPassiveRenderer());
    }

    @Override
    public void initColors() {
        LanguageHelper.globals.put("colors.black", "\u00a70");
        LanguageHelper.globals.put("colors.navy", "\u00a71");
        LanguageHelper.globals.put("colors.green", "\u00a72");
        LanguageHelper.globals.put("colors.blue", "\u00a73");
        LanguageHelper.globals.put("colors.red", "\u00a74");
        LanguageHelper.globals.put("colors.purple", "\u00a75");
        LanguageHelper.globals.put("colors.gold", "\u00a76");
        LanguageHelper.globals.put("colors.light_gray", "\u00a77");
        LanguageHelper.globals.put("colors.gray", "\u00a78");
        LanguageHelper.globals.put("colors.dark_purple", "\u00a79");
        LanguageHelper.globals.put("colors.light_green", "\u00a7a");
        LanguageHelper.globals.put("colors.light_blue", "\u00a7b");
        LanguageHelper.globals.put("colors.rose", "\u00a7c");
        LanguageHelper.globals.put("colors.light_purple", "\u00a7d");
        LanguageHelper.globals.put("colors.yellow", "\u00a7e");
        LanguageHelper.globals.put("colors.white", "\u00a7f");
        LanguageHelper.globals.put("colors.reset", TextFormatting.RESET.toString());
    }
}

