/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jer;

import jeresources.api.IJERAPI;
import jeresources.api.JERPlugin;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.WatchableData;
import jeresources.api.drop.LootDrop;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xreliquary.compat.ICompat;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.reference.Settings;

public class JERCompat
implements ICompat {
    private static boolean JERDataLoaded = false;
    @JERPlugin
    public static IJERAPI api;

    @Override
    public void loadCompatibility(ICompat.InitializationPhase phase, World world) {
        if (Settings.mobDropsEnabled && phase == ICompat.InitializationPhase.WORLD_LOAD && !JERDataLoaded) {
            JERCompat.register(world);
            JERDataLoaded = true;
        }
    }

    @Override
    public String getModId() {
        return "jeresources";
    }

    public static void register(World world) {
        JERCompat.registerMobDrop(EntitySquid.class, XRRecipes.ingredient(1, 12), Settings.MobDrops.getBaseDrop("squid_beak"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityWitch.class, new ItemStack((Item)ModItems.witchHat), Settings.MobDrops.getBaseDrop("witch_hat"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntitySpider.class, XRRecipes.ingredient(1, 2), Settings.MobDrops.getBaseDrop("spider_chelicerae"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityZombie.class, XRRecipes.ingredient(1, 6), Settings.MobDrops.getBaseDrop("necrotic_heart_zombie"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntitySlime.class, XRRecipes.ingredient(1, 4), Settings.MobDrops.getBaseDrop("slime_pearl"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityBlaze.class, XRRecipes.ingredient(1, 7), Settings.MobDrops.getBaseDrop("molten_core_blaze"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityMagmaCube.class, XRRecipes.ingredient(1, 7), Settings.MobDrops.getBaseDrop("molten_core_magma_cube"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityGhast.class, XRRecipes.ingredient(1, 3), Settings.MobDrops.getBaseDrop("catalyzing_gland_ghast"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityCreeper.class, XRRecipes.ingredient(1, 3), Settings.MobDrops.getBaseDrop("catalyzing_gland_creeper"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityEnderman.class, XRRecipes.ingredient(1, 11), Settings.MobDrops.getBaseDrop("nebulous_heart"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntityBat.class, XRRecipes.ingredient(1, 5), Settings.MobDrops.getBaseDrop("bat_wing"), Conditional.playerKill);
        JERCompat.registerMobDrop(EntitySnowman.class, XRRecipes.ingredient(1, 10), Settings.MobDrops.getBaseDrop("frozen_core"), Conditional.playerKill);
    }

    private static void registerMobDrop(Class<? extends EntityLivingBase> entity, WatchableData watchableData, ItemStack drop, float chance, Conditional ... conditionals) {
        LootDrop dropItem = new LootDrop(drop, 1, 1, chance, conditionals);
        api.getMobRegistry().registerDrops(entity, watchableData, new LootDrop[]{dropItem});
    }

    private static void registerMobDrop(Class<? extends EntityLivingBase> entity, ItemStack drop, float chance, Conditional ... conditionals) {
        JERCompat.registerMobDrop(entity, WatchableData.EMPTY, drop, chance, conditionals);
    }
}

