/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.potion;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;
import xreliquary.util.potions.PotionEssence;

public class EntityThrownXRPotion
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private int renderColor;
    public PotionEssence essence = null;

    public EntityThrownXRPotion(World world) {
        super(world);
    }

    public EntityThrownXRPotion(World world, EntityLivingBase elb, ItemStack ist) {
        super(world, elb);
        this.essence = new PotionEssence(ist.func_77978_p());
        this.setRenderColor(this.getColor());
    }

    protected float func_70185_h() {
        return 0.04f;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb;
            List list1;
            List<PotionEffect> list = this.essence.getEffects();
            if (list != null && !list.isEmpty() && (list1 = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))) != null && !list1.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list1) {
                    double d0 = this.func_70068_e((Entity)entitylivingbase);
                    if (!(d0 < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                    if (entitylivingbase == result.field_72308_g) {
                        d1 = 1.0;
                    }
                    for (PotionEffect potioneffect : list) {
                        if (potioneffect.func_188419_a().func_76403_b()) {
                            potioneffect.func_188419_a().func_180793_a((Entity)this, (Entity)this.func_85052_h(), entitylivingbase, potioneffect.func_76458_c(), d1);
                            continue;
                        }
                        int j = (int)(d1 * (double)potioneffect.func_76459_b() + 0.5);
                        if (j <= 20) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(potioneffect.func_188419_a(), j, potioneffect.func_76458_c(), false, false));
                    }
                }
            }
            this.spawnParticles();
            this.func_70106_y();
        }
    }

    public int getColor() {
        return this.essence == null ? this.getRenderColor() : PotionUtils.func_185181_a(this.essence.getEffects());
    }

    protected void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Random var7 = this.field_70146_Z;
        for (int var15 = 0; var15 < 8; ++var15) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)Items.field_151068_bn)});
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.networkWrapper.sendToAllAround((IMessage)new PacketFXThrownPotionImpact(this.getColor(), this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.essence = new PotionEssence(tag);
        this.setRenderColor(tag.func_74762_e("color"));
        if (this.essence.getEffects().size() == 0) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("potion", (NBTBase)(this.essence == null ? new NBTTagCompound() : this.essence.writeToNBT()));
        tag.func_74768_a("color", this.getRenderColor());
    }

    public int getRenderColor() {
        return this.renderColor;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.renderColor);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setRenderColor(additionalData.readInt());
    }

    public void setRenderColor(int renderColor) {
        this.renderColor = renderColor;
    }
}

