/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xreliquary.init.ModItems;
import xreliquary.init.ModPotions;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.XRFakePlayerFactory;

public class CommonEventHandler {
    private Map<UUID, Boolean> playersFlightStatus = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public void handleMercyCrossDamage(AttackEntityEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || !(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        if (event.getEntityPlayer().func_184614_ca() == null || event.getEntityPlayer().func_184614_ca().func_77973_b() != ModItems.mercyCross) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        ModItems.mercyCross.updateAttackDamageModifier(target, event.getEntityPlayer());
    }

    private boolean isUndead(EntityLivingBase e) {
        return e.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
    }

    @SubscribeEvent
    public void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_146103_bH().getName().equals("Drullkus") && !event.player.getEntityData().func_74764_b("gift") && event.player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.witchHat))) {
            event.player.getEntityData().func_74757_a("gift", true);
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent event) {
        this.doTwilightCloakCheck(event);
        this.doHeartZhuCheck(event);
    }

    @SubscribeEvent
    public void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
        this.doHeartZhuCheck(event);
    }

    public void doHeartZhuCheck(LivingSetAttackTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        if (!(event.getTarget() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getTarget();
        this.doZombieZhuCheck(event.getEntity(), player);
        this.doSkeletonZhuCheck(event.getEntity(), player);
        this.doWitherSkeletonZhuCheck(event.getEntity(), player);
        this.doCreeperZhuCheck(event.getEntity(), player);
    }

    public void doHeartZhuCheck(LivingEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)event.getEntity();
            if (entityLiving.func_70638_az() == null) {
                return;
            }
            if (!(entityLiving.func_70638_az() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving.func_70638_az();
            this.doZombieZhuCheck(event.getEntity(), player);
            this.doSkeletonZhuCheck(event.getEntity(), player);
            this.doWitherSkeletonZhuCheck(event.getEntity(), player);
            this.doCreeperZhuCheck(event.getEntity(), player);
        }
    }

    private ItemStack heartZhu(int meta) {
        return XRRecipes.nianZhu(meta);
    }

    public void doZombieZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntityZombie && !(e instanceof EntityPigZombie) && this.playerHasItem(p, this.heartZhu(0), false)) {
            ((EntityZombie)e).func_70624_b(null);
            ((EntityZombie)e).func_70604_c(null);
        }
    }

    public void doSkeletonZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() != 1 && this.playerHasItem(p, this.heartZhu(1), false)) {
            ((EntitySkeleton)e).func_70624_b(null);
            ((EntitySkeleton)e).func_70604_c(null);
        }
    }

    public void doWitherSkeletonZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntitySkeleton && ((EntitySkeleton)e).func_82202_m() == 1 && this.playerHasItem(p, this.heartZhu(2), false)) {
            ((EntitySkeleton)e).func_70624_b(null);
            ((EntitySkeleton)e).func_70604_c(null);
        }
    }

    public void doCreeperZhuCheck(Entity e, EntityPlayer p) {
        if (e instanceof EntityCreeper && this.playerHasItem(p, this.heartZhu(3), false)) {
            ((EntityCreeper)e).func_70624_b(null);
            ((EntityCreeper)e).func_70604_c(null);
        }
    }

    public void doTwilightCloakCheck(LivingEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)event.getEntity();
            if (entityLiving.func_70638_az() == null) {
                return;
            }
            if (!(entityLiving.func_70638_az() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving.func_70638_az();
            if (!this.playerHasItem(player, ModItems.twilightCloak, true)) {
                return;
            }
            if (player.field_70170_p.func_175671_l(player.func_180425_c()) > Settings.TwilightCloak.maxLightLevel) {
                return;
            }
            if (event.getEntity() instanceof EntityLiving) {
                ((EntityLiving)event.getEntity()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.handleInfernalClawsCheck(player, event);
        this.handleInfernalChaliceCheck(player, event);
        this.handleAngelicFeatherCheck(player, event);
        this.handleKrakenEyeCheck(player, event);
        this.handlePhoenixDownCheck(player, event);
        this.handleAngelheartVialCheck(player, event);
        if (event.isCanceled()) {
            event.setResult(null);
        }
    }

    public void handleInfernalClawsCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ModItems.infernalClaws, false)) {
            return;
        }
        if (event.getSource() != DamageSource.field_76372_a && event.getSource() != DamageSource.field_76370_b) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        player.func_71020_j(event.getAmount() * ((float)Settings.InfernalClaws.hungerCostPercent / 100.0f));
        event.setCanceled(true);
    }

    public void handleInfernalChaliceCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ModItems.infernalChalice, false)) {
            return;
        }
        if (event.getSource() != DamageSource.field_76371_c && event.getSource() != DamageSource.field_76370_b && event.getSource() != DamageSource.field_76372_a) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (event.getSource() == DamageSource.field_76371_c || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76372_a) {
            player.func_71020_j(event.getAmount() * ((float)Settings.InfernalChalice.hungerCostPercent / 100.0f));
        }
        event.setCanceled(true);
    }

    public void handleAngelheartVialCheck(EntityPlayer player, LivingAttackEvent event) {
        if (player.func_110143_aJ() > (float)Math.round(event.getAmount())) {
            return;
        }
        if (!this.playerHasItem(player, ModItems.angelheartVial, false)) {
            return;
        }
        this.decreaseItemByOne(player, ModItems.angelheartVial);
        this.spawnAngelheartVialParticles(player);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        float amountHealed = player.func_110138_aP() * (float)Settings.AngelHeartVial.healPercentageOfMaxLife / 100.0f;
        player.func_70606_j(amountHealed);
        if (Settings.AngelHeartVial.removeNegativeStatus) {
            this.removeNegativeStatusEffects(player);
        }
        event.setCanceled(true);
    }

    public void spawnAngelheartVialParticles(EntityPlayer player) {
        double var8 = player.field_70165_t;
        double var10 = player.field_70163_u;
        double var12 = player.field_70161_v;
        Random var7 = player.field_70170_p.field_73012_v;
        for (int var15 = 0; var15 < 8; ++var15) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, var8, var10, var12, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)Items.field_151068_bn)});
        }
        float red = 1.0f;
        float green = 0.0f;
        float blue = 1.0f;
        String var19 = "spell";
        for (int var20 = 0; var20 < 100; ++var20) {
            Particle var31;
            double var39 = var7.nextDouble() * 4.0;
            double var23 = var7.nextDouble() * Math.PI * 2.0;
            double var25 = Math.cos(var23) * var39;
            double var27 = 0.01 + var7.nextDouble() * 0.5;
            double var29 = Math.sin(var23) * var39;
            if (!player.field_70170_p.field_72995_K || (var31 = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), var8 + var25 * 0.1, var10 + 0.3, var12 + var29 * 0.1, var25, var27, var29, new int[0])) == null) continue;
            float var32 = 0.75f + var7.nextFloat() * 0.25f;
            var31.func_70538_b(red * var32, green * var32, blue * var32);
            var31.func_70543_e((float)var39);
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void removeNegativeStatusEffects(EntityPlayer player) {
        player.func_184589_d(MobEffects.field_82731_v);
        player.func_184589_d(MobEffects.field_76438_s);
        player.func_184589_d(MobEffects.field_76436_u);
        player.func_184589_d(MobEffects.field_76431_k);
        player.func_184589_d(MobEffects.field_76419_f);
        player.func_184589_d(MobEffects.field_76421_d);
        player.func_184589_d(MobEffects.field_76440_q);
        player.func_184589_d(MobEffects.field_76437_t);
    }

    public void handlePhoenixDownCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ModItems.phoenixDown, false)) {
            return;
        }
        if (player.func_110143_aJ() > (float)Math.round(event.getAmount())) {
            if (event.getSource() != DamageSource.field_76379_h) {
                return;
            }
            if (player.func_71024_bL().func_75116_a() <= 0) {
                return;
            }
            float hungerDamage = event.getAmount() * ((float)Settings.PhoenixDown.hungerCostPercent / 100.0f);
            player.func_71020_j(hungerDamage);
            player.func_71024_bL().func_75118_a(player);
            event.setCanceled(true);
            return;
        }
        this.revertPhoenixDownToAngelicFeather(player);
        float amountHealed = player.func_110138_aP() * (float)Settings.PhoenixDown.healPercentageOfMaxLife / 100.0f;
        player.func_70606_j(amountHealed);
        if (Settings.PhoenixDown.removeNegativeStatus) {
            this.removeNegativeStatusEffects(player);
        }
        if (event.getSource() == DamageSource.field_76371_c && Settings.PhoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, 0));
        }
        if (event.getSource() == DamageSource.field_76369_e && Settings.PhoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou) {
            player.func_70050_g(10);
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 200, 0));
        }
        if (Settings.PhoenixDown.giveTemporaryDamageResistance) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
        }
        if (Settings.PhoenixDown.giveTemporaryRegeneration) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 1));
        }
        this.spawnPhoenixResurrectionParticles(player);
        event.setCanceled(true);
    }

    public void spawnPhoenixResurrectionParticles(EntityPlayer player) {
        for (int particles = 0; particles <= 400; ++particles) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, new int[0]);
        }
    }

    public void handleAngelicFeatherCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ModItems.angelicFeather, false)) {
            return;
        }
        if (event.getSource() != DamageSource.field_76379_h) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (player.field_70143_R > 0.0f) {
            float hungerDamage = event.getAmount() * ((float)Settings.AngelicFeather.hungerCostPercent / 100.0f);
            player.func_71020_j(hungerDamage);
            player.func_71024_bL().func_75118_a(player);
        }
        event.setCanceled(true);
    }

    public void handleKrakenEyeCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ModItems.krakenShell, false)) {
            return;
        }
        if (player.func_71024_bL().func_75116_a() <= 0) {
            return;
        }
        if (event.getSource() == DamageSource.field_76369_e) {
            float hungerDamage = event.getAmount() * ((float)Settings.KrakenShell.hungerCostPercent / 100.0f);
            player.func_71020_j(hungerDamage);
            event.setCanceled(true);
        }
    }

    private void revertPhoenixDownToAngelicFeather(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ModItems.phoenixDown) continue;
            player.field_71071_by.field_70462_a[slot] = new ItemStack((Item)ModItems.angelicFeather);
            return;
        }
    }

    private boolean playerHasItem(EntityPlayer player, Item item, boolean checkEnabled) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            if (checkEnabled && player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemToggleable) {
                return ((ItemToggleable)player.field_71071_by.field_70462_a[slot].func_77973_b()).isEnabled(player.field_71071_by.field_70462_a[slot]);
            }
            return true;
        }
        return false;
    }

    private boolean playerHasItem(EntityPlayer player, ItemStack ist, boolean checkEnabled) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || !player.field_71071_by.field_70462_a[slot].func_77969_a(ist)) continue;
            if (checkEnabled && player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemToggleable) {
                return ((ItemToggleable)player.field_71071_by.field_70462_a[slot].func_77973_b()).isEnabled(player.field_71071_by.field_70462_a[slot]);
            }
            return true;
        }
        return false;
    }

    private void decreaseItemByOne(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            XRFakePlayerFactory.unloadWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving().func_70644_a(ModPotions.potionFlight)) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                this.playersFlightStatus.put(player.func_146103_bH().getId(), true);
                player.field_71075_bZ.field_75101_c = true;
                player.field_70143_R = 0.0f;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!this.playersFlightStatus.containsKey(player.func_146103_bH().getId())) {
                this.playersFlightStatus.put(player.func_146103_bH().getId(), false);
            }
            if (this.playersFlightStatus.get(player.func_146103_bH().getId()).booleanValue()) {
                this.playersFlightStatus.put(player.func_146103_bH().getId(), false);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                }
            }
        }
    }
}

