/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler.config;

import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import xreliquary.handler.ConfigurationHandler;
import xreliquary.reference.Settings;
import xreliquary.util.StackHelper;
import xreliquary.util.alkahestry.AlkahestChargeRecipe;
import xreliquary.util.alkahestry.AlkahestCraftRecipe;

public class AlkahestConfiguration {
    private static final int TOME_COST_LOW_TIER = 4;
    private static final int TOME_COST_MIDDLE_TIER = 8;
    private static final int TOME_COST_HIGH_TIER = 32;
    private static final int TOME_COST_UBER_TIER = 64;

    public static void loadAlkahestBaseItem() {
        ItemStack stack;
        String registryName = ConfigurationHandler.getString("base_item", "item_and_block_settings.alkahestry_tome", Items.field_151137_ax.getRegistryName().toString());
        int meta = ConfigurationHandler.getInt("base_item_meta", "item_and_block_settings.alkahestry_tome", 0, 0, 16);
        String[] splitName = registryName.split(":");
        Settings.AlkahestryTome.baseItem = stack = StackHelper.getItemStackFromNameMeta(splitName[0], splitName[1], meta);
        Settings.AlkahestryTome.baseItemWorth = ConfigurationHandler.getInt("base_item_worth", "item_and_block_settings.alkahestry_tome", 1, 1, 1000);
    }

    public static void loadAlkahestChargingRecipes() {
        ConfigCategory category = ConfigurationHandler.configuration.getCategory("item_and_block_settings.alkahestry_tome.charging_recipes");
        if (category.isEmpty()) {
            AlkahestConfiguration.addDefaultAlkahestChargingRecipes(category);
        }
        AlkahestConfiguration.loadAlkahestChargingRecipesIntoSettings(category);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.alkahestry_tome.charging_recipes", true);
    }

    private static void loadAlkahestChargingRecipesIntoSettings(ConfigCategory category) {
        Settings.AlkahestryTome.chargingRecipes.clear();
        for (Map.Entry entry : category.getValues().entrySet()) {
            String[] nameParts = ((String)entry.getKey()).split(":");
            int[] values = ((Property)entry.getValue()).getIntList();
            String modId = nameParts[0];
            String name = nameParts[1];
            int meta = values[0];
            int charge = values[1];
            ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name, meta);
            if (stack == null) continue;
            Settings.AlkahestryTome.chargingRecipes.put((String)entry.getKey(), new AlkahestChargeRecipe(stack, charge));
        }
    }

    private static void addDefaultAlkahestChargingRecipes(ConfigCategory category) {
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Blocks.field_150451_bX.getRegistryName().toString(), 9);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Items.field_151137_ax.getRegistryName().toString(), 1);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Blocks.field_150426_aN.getRegistryName().toString(), 4);
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, Items.field_151114_aO.getRegistryName().toString(), 1);
    }

    private static void addConfigAlkahestChargingRecipe(ConfigCategory category, String item, Integer charge) {
        AlkahestConfiguration.addConfigAlkahestChargingRecipe(category, item, 0, charge);
    }

    private static void addConfigAlkahestChargingRecipe(ConfigCategory category, String item, Integer meta, Integer charge) {
        Property prop = new Property(item, new String[]{meta.toString(), charge.toString()}, Property.Type.INTEGER);
        category.put(item, prop);
    }

    public static void loadAlkahestCraftingRecipes() {
        ConfigCategory category = ConfigurationHandler.configuration.getCategory("item_and_block_settings.alkahestry_tome.crafting_recipes");
        if (category.isEmpty()) {
            AlkahestConfiguration.addDefaultAlkahestCraftingRecipes(category);
        }
        AlkahestConfiguration.loadAlkahestCraftingRecipesIntoSettings(category);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.alkahestry_tome.crafting_recipes", true);
    }

    private static void loadAlkahestCraftingRecipesIntoSettings(ConfigCategory category) {
        Settings.AlkahestryTome.craftingRecipes.clear();
        for (Map.Entry entry : category.getValues().entrySet()) {
            String[] nameParts = ((String)entry.getKey()).split(":");
            int[] values = ((Property)entry.getValue()).getIntList();
            String modId = nameParts[0];
            String name = nameParts[1];
            int meta = values[0];
            int yield = values[1];
            int cost = values[2];
            if (modId.toLowerCase().equals("oredictionary")) {
                Settings.AlkahestryTome.craftingRecipes.put((String)entry.getKey(), new AlkahestCraftRecipe(name, yield, cost));
                continue;
            }
            ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name, meta);
            String key = (String)entry.getKey() + (stack.func_77973_b().func_77614_k() ? "|" + meta : "");
            if (stack == null) continue;
            Settings.AlkahestryTome.craftingRecipes.put(key, new AlkahestCraftRecipe(stack, yield, cost));
        }
    }

    private static void addDefaultAlkahestCraftingRecipes(ConfigCategory category) {
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150346_d.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150347_e.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150354_m.getRegistryName().toString(), 32, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150351_n.getRegistryName().toString(), 16, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150322_A.getRegistryName().toString(), 8, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150435_aG.getRegistryName().toString(), 2, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150424_aL.getRegistryName().toString(), 8, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151044_h.getRegistryName().toString(), 1, 4, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151100_aR.getRegistryName().toString(), 4, 1, 4);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150343_Z.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150425_aM.getRegistryName().toString(), 8, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150385_bj.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Blocks.field_150377_bs.getRegistryName().toString(), 16, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151044_h.getRegistryName().toString(), 4, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151016_H.getRegistryName().toString(), 2, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151145_ak.getRegistryName().toString(), 8, 8);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151043_k.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151042_j.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151166_bC.getRegistryName().toString(), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("tin_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("silver_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("copper_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("steel_ingot"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotTin"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotSilver"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotCopper"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, AlkahestConfiguration.oreDictionary("ingotSteel"), 1, 32);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151045_i.getRegistryName().toString(), 1, 64);
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, Items.field_151156_bN.getRegistryName().toString(), 1, 256);
    }

    private static String oreDictionary(String name) {
        return "OreDictionary:" + name;
    }

    private static void addConfigAlkahestCraftingRecipe(ConfigCategory category, String item, Integer yield, Integer cost) {
        AlkahestConfiguration.addConfigAlkahestCraftingRecipe(category, item, 0, yield, cost);
    }

    private static void addConfigAlkahestCraftingRecipe(ConfigCategory category, String item, Integer meta, Integer yield, Integer cost) {
        Property prop = new Property(item, new String[]{meta.toString(), yield.toString(), cost.toString()}, Property.Type.INTEGER);
        category.put(item, prop);
    }
}

