/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IProjectile;
import net.minecraftforge.common.config.ConfigCategory;
import xreliquary.handler.ConfigurationHandler;
import xreliquary.items.ItemDestructionCatalyst;
import xreliquary.reference.Settings;

public class BlockItemConfiguration {
    public static void loadEntitiesSettings() {
        ArrayList<String> entityNames = new ArrayList<String>();
        for (Object o : EntityList.field_75625_b.values()) {
            Class c = (Class)o;
            if (!EntityLiving.class.isAssignableFrom(c)) continue;
            entityNames.add((String)EntityList.field_75626_c.get(o));
        }
        ArrayList<String> projectileNames = new ArrayList<String>();
        for (Object o : EntityList.field_75625_b.values()) {
            Class c = (Class)o;
            if (!IProjectile.class.isAssignableFrom(c)) continue;
            projectileNames.add((String)EntityList.field_75626_c.get(o));
        }
        Settings.InterdictionTorch.entitiesThatCanBePushed = ConfigurationHandler.getStringList("entities_that_can_be_pushed", "item_and_block_settings.interdiction_torch", entityNames);
        Settings.InterdictionTorch.projectilesThatCanBePushed = ConfigurationHandler.getStringList("projectiles_that_can_be_pushed", "item_and_block_settings.interdiction_torch", projectileNames);
        Settings.RendingGale.entitiesThatCanBePushed = ConfigurationHandler.getStringList("entities_that_can_be_pushed", "item_and_block_settings.rending_gale", entityNames);
        Settings.RendingGale.projectilesThatCanBePushed = ConfigurationHandler.getStringList("projectiles_that_can_be_pushed", "item_and_block_settings.rending_gale", projectileNames);
        Settings.SeekerShot.entitiesThatCanBeHunted = ConfigurationHandler.getStringList("entities_that_can_be_hunted", "item_and_block_settings.seeker_shot", entityNames);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.seeker_shot", true);
    }

    public static void loadBlockAndItemSettings() {
        int itemCap = 9999;
        int cleanShortMax = 30000;
        int cleanIntMax = 2000000000;
        Settings.AlkahestryTome.chargeLimit = ConfigurationHandler.getInt("charge_limit", "item_and_block_settings.alkahestry_tome", 1000, 0, itemCap);
        ConfigurationHandler.configuration.getCategory("item_and_block_settings.alkahestry_tome").get("charge_limit").setRequiresMcRestart(true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.alkahestry_tome", true);
        Settings.Altar.redstoneCost = ConfigurationHandler.getInt("redstone_cost", "item_and_block_settings.altar", 3, 0, 10);
        Settings.Altar.timeInMinutes = ConfigurationHandler.getInt("time_in_minutes", "item_and_block_settings.altar", 20, 0, 60);
        Settings.Altar.maximumTimeVarianceInMinutes = ConfigurationHandler.getInt("maximum_time_variance_in_minutes", "item_and_block_settings.altar", 5, 0, 15);
        Settings.Altar.outputLightLevelWhileActive = ConfigurationHandler.getInt("output_light_level_while_active", "item_and_block_settings.altar", 16, 16, 0);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.altar", true);
        Settings.AngelicFeather.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.angelic_feather", 50, 0, 100);
        Settings.AngelicFeather.leapingPotency = ConfigurationHandler.getInt("leaping_potency", "item_and_block_settings.angelic_feather", 1, 0, 5);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.angelic_feather", true);
        Settings.AngelHeartVial.healPercentageOfMaxLife = ConfigurationHandler.getInt("heal_percentage_of_max_life", "item_and_block_settings.angelheart_vial", 25, 0, 100);
        Settings.AngelHeartVial.removeNegativeStatus = ConfigurationHandler.getBoolean("remove_negative_status", "item_and_block_settings.angelheart_vial", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.angelheart_vial", true);
        ImmutableList heatSources = ImmutableList.of();
        Settings.ApothecaryCauldron.redstoneLimit = ConfigurationHandler.getInt("redstone_limit", "item_and_block_settings.apothecary_cauldron", 5, 0, 5);
        Settings.ApothecaryCauldron.glowstoneLimit = ConfigurationHandler.getInt("glowstone_limit", "item_and_block_settings.apothecary_cauldron", 4, 0, 4);
        Settings.ApothecaryCauldron.cookTime = ConfigurationHandler.getInt("cook_time", "item_and_block_settings.apothecary_cauldron", 160, 20, 32000);
        Settings.ApothecaryCauldron.heatSources = ConfigurationHandler.getStringList("heat_sources", "item_and_block_settings.apothecary_cauldron", (List<String>)heatSources);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.apothecary_cauldron", true);
        Settings.DestructionCatalyst.mundaneBlocks = ConfigurationHandler.getStringList("mundane_blocks", "item_and_block_settings.destruction_catalyst", new ArrayList<String>(ItemDestructionCatalyst.ids));
        Settings.DestructionCatalyst.gunpowderCost = ConfigurationHandler.getInt("gunpowder_cost", "item_and_block_settings.destruction_catalyst", 3, 0, 10);
        Settings.DestructionCatalyst.gunpowderWorth = ConfigurationHandler.getInt("gunpowder_worth", "item_and_block_settings.destruction_catalyst", 1, 0, 3);
        Settings.DestructionCatalyst.gunpowderLimit = ConfigurationHandler.getInt("gunpowder_limit", "item_and_block_settings.destruction_catalyst", 250, 0, itemCap);
        Settings.DestructionCatalyst.explosionRadius = ConfigurationHandler.getInt("explosion_radius", "item_and_block_settings.destruction_catalyst", 1, 1, 5);
        Settings.DestructionCatalyst.centeredExplosion = ConfigurationHandler.getBoolean("centered_explosion", "item_and_block_settings.destruction_catalyst", false);
        Settings.DestructionCatalyst.perfectCube = ConfigurationHandler.getBoolean("perfect_cube", "item_and_block_settings.destruction_catalyst", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.destruction_catalyst", true);
        Settings.EmperorChalice.hungerSatiationMultiplier = ConfigurationHandler.getInt("hunger_satiation_multiplier", "item_and_block_settings.emperor_chalice", 4, 0, 10);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.emperor_chalice", true);
        Settings.EnderStaff.enderPearlCastCost = ConfigurationHandler.getInt("ender_pearl_cast_cost", "item_and_block_settings.ender_staff", 1, 0, 3);
        Settings.EnderStaff.enderPearlNodeWarpCost = ConfigurationHandler.getInt("ender_pearl_node_warp_cost", "item_and_block_settings.ender_staff", 1, 0, 3);
        Settings.EnderStaff.enderPearlWorth = ConfigurationHandler.getInt("ender_pearl_worth", "item_and_block_settings.ender_staff", 1, 0, 10);
        Settings.EnderStaff.enderPearlLimit = ConfigurationHandler.getInt("ender_pearl_limit", "item_and_block_settings.ender_staff", 250, 0, itemCap);
        Settings.EnderStaff.nodeWarpCastTime = ConfigurationHandler.getInt("node_warp_cast_time", "item_and_block_settings.ender_staff", 60, 10, 120);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.ender_staff", true);
        Settings.FortuneCoin.disableAudio = ConfigurationHandler.getBoolean("disable_audio", "item_and_block_settings.fortune_coin", false);
        Settings.FortuneCoin.standardPullDistance = ConfigurationHandler.getInt("standard_pull_distance", "item_and_block_settings.fortune_coin", 5, 3, 10);
        Settings.FortuneCoin.longRangePullDistance = ConfigurationHandler.getInt("long_range_pull_distance", "item_and_block_settings.fortune_coin", 15, 9, 30);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.fortune_coin", true);
        Settings.GlacialStaff.snowballLimit = ConfigurationHandler.getInt("snowball_limit", "item_and_block_settings.glacial_staff", 250, 0, itemCap);
        Settings.GlacialStaff.snowballCost = ConfigurationHandler.getInt("snowball_cost", "item_and_block_settings.glacial_staff", 1, 0, 3);
        Settings.GlacialStaff.snowballWorth = ConfigurationHandler.getInt("snowball_worth", "item_and_block_settings.glacial_staff", 1, 0, 3);
        Settings.GlacialStaff.snowballDamage = ConfigurationHandler.getInt("snowball_damage", "item_and_block_settings.glacial_staff", 3, 0, 6);
        Settings.GlacialStaff.snowballDamageBonusFireImmune = ConfigurationHandler.getInt("snowball_damage_bonus_fire_immune", "item_and_block_settings.glacial_staff", 3, 0, 6);
        Settings.GlacialStaff.snowballDamageBonusBlaze = ConfigurationHandler.getInt("snowball_damage_bonus_blaze", "item_and_block_settings.glacial_staff", 6, 0, 12);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.glacial_staff", true);
        Settings.HarvestRod.boneMealLimit = ConfigurationHandler.getInt("bonemeal_limit", "item_and_block_settings.harvest_rod", 250, 0, itemCap);
        Settings.HarvestRod.boneMealCost = ConfigurationHandler.getInt("bonemeal_cost", "item_and_block_settings.harvest_rod", 1, 0, 3);
        Settings.HarvestRod.boneMealWorth = ConfigurationHandler.getInt("bonemeal_worth", "item_and_block_settings.harvest_rod", 1, 0, 3);
        Settings.HarvestRod.boneMealLuckPercentChance = ConfigurationHandler.getInt("bonemeal_luck_percent_chance", "item_and_block_settings.harvest_rod", 33, 1, 100);
        Settings.HarvestRod.boneMealLuckRolls = ConfigurationHandler.getInt("bonemeal_luck_rolls", "item_and_block_settings.harvest_rod", 2, 0, 7);
        Settings.HarvestRod.AOERadius = ConfigurationHandler.getInt("aoe_radius", "item_and_block_settings.harvest_rod", 2, 0, 5);
        Settings.HarvestRod.AOECooldown = ConfigurationHandler.getInt("aoe_cooldown", "item_and_block_settings.harvest_rod", 3, 1, 20);
        Settings.HarvestRod.maxCapacityPerPlantable = ConfigurationHandler.getInt("max_capacity_per_plantable", "item_and_block_settings.harvest_rod", 250, 0, itemCap);
        Settings.HarvestRod.pedestalRange = ConfigurationHandler.getInt("pedestal_range", "item_and_block_settings.harvest_rod", 4, 1, 20);
        Settings.HarvestRod.pedestalCooldown = (byte)ConfigurationHandler.getInt("pedestal_cooldown", "item_and_block_settings.harvest_rod", 5, 1, 20);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.harvest_rod", true);
        Settings.HeroMedallion.experienceLevelMaximum = ConfigurationHandler.getInt("experience_level_maximum", "item_and_block_settings.hero_medallion", 200, 0, 1000);
        Settings.HeroMedallion.experienceLevelMinimum = ConfigurationHandler.getInt("experience_level_minimum", "item_and_block_settings.hero_medallion", 0, 0, 30);
        Settings.HeroMedallion.experienceLimit = ConfigurationHandler.getInt("experience_limit", "item_and_block_settings.hero_medallion", cleanIntMax, 0, cleanIntMax);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.hero_medallion", true);
        Settings.IceMagusRod.snowballLimit = ConfigurationHandler.getInt("snowball_limit", "item_and_block_settings.ice_magus_rod", 250, 0, itemCap);
        Settings.IceMagusRod.snowballCost = ConfigurationHandler.getInt("snowball_cost", "item_and_block_settings.ice_magus_rod", 1, 0, 3);
        Settings.IceMagusRod.snowballWorth = ConfigurationHandler.getInt("snowball_worth", "item_and_block_settings.ice_magus_rod", 1, 0, 3);
        Settings.IceMagusRod.snowballDamage = ConfigurationHandler.getInt("snowball_damage", "item_and_block_settings.ice_magus_rod", 2, 0, 4);
        Settings.IceMagusRod.snowballDamageBonusFireImmune = ConfigurationHandler.getInt("snowball_damage_bonus_fire_immune", "item_and_block_settings.ice_magus_rod", 2, 0, 4);
        Settings.IceMagusRod.snowballDamageBonusBlaze = ConfigurationHandler.getInt("snowball_damage_bonus_blaze", "item_and_block_settings.ice_magus_rod", 4, 0, 8);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.ice_magus_rod", true);
        Settings.InfernalClaws.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.infernal_claws", 10, 0, 30);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.infernal_claws", true);
        Settings.InfernalChalice.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.infernal_chalice", 5, 0, 10);
        Settings.InfernalChalice.fluidLimit = ConfigurationHandler.getInt("fluid_limit", "item_and_block_settings.infernal_chalice", 500000, 0, cleanIntMax);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.infernal_chalice", true);
        Settings.InfernalTear.absorbWhenCreated = ConfigurationHandler.getBoolean("absorb_when_created", "item_and_block_settings.infernal_tear", false);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.infernal_tear", true);
        Settings.InterdictionTorch.pushRadius = ConfigurationHandler.getInt("push_radius", "item_and_block_settings.interdiction_torch", 5, 1, 15);
        Settings.InterdictionTorch.canPushProjectiles = ConfigurationHandler.getBoolean("can_push_projectiles", "item_and_block_settings.interdiction_torch", false);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.interdiction_torch", true);
        Settings.KrakenShell.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.kraken_shell", 25, 0, 50);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.kraken_shell", true);
        Settings.LanternOfParanoia.minLightLevel = ConfigurationHandler.getInt("min_light_level", "item_and_block_settings.lantern_of_paranoia", 8, 0, 15);
        Settings.LanternOfParanoia.placementScanRadius = ConfigurationHandler.getInt("placement_scan_radius", "item_and_block_settings.lantern_of_paranoia", 6, 1, 15);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.lantern_of_paranoia", true);
        Settings.FertileLilypad.secondsBetweenGrowthTicks = ConfigurationHandler.getInt("seconds_between_growth_ticks", "item_and_block_settings.fertile_lilypad", 47, 1, 150);
        Settings.FertileLilypad.tileRange = ConfigurationHandler.getInt("tile_range", "item_and_block_settings.fertile_lilypad", 4, 1, 15);
        Settings.FertileLilypad.fullPotencyRange = ConfigurationHandler.getInt("full_potency_range", "item_and_block_settings.fertile_lilypad", 1, 1, 15);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.fertile_lilypad", true);
        ImmutableList goldItems = ImmutableList.of();
        Settings.MidasTouchstone.goldItems = ConfigurationHandler.getStringList("gold_items", "item_and_block_settings.midas_touchstone", (List<String>)goldItems);
        Settings.MidasTouchstone.ticksBetweenRepairTicks = ConfigurationHandler.getInt("ticks_between_repair_ticks", "item_and_block_settings.midas_touchstone", 4, 1, cleanShortMax);
        Settings.MidasTouchstone.glowstoneCost = ConfigurationHandler.getInt("glowstone_cost", "item_and_block_settings.midas_touchstone", 1, 0, 3);
        Settings.MidasTouchstone.glowstoneWorth = ConfigurationHandler.getInt("glowstone_worth", "item_and_block_settings.midas_touchstone", 4, 0, 12);
        Settings.MidasTouchstone.glowstoneLimit = ConfigurationHandler.getInt("glowstone_limit", "item_and_block_settings.midas_touchstone", 250, 0, itemCap);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.midas_touchstone", true);
        Settings.PhoenixDown.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.phoenix_down", 25, 0, 50);
        Settings.PhoenixDown.leapingPotency = ConfigurationHandler.getInt("leaping_potency", "item_and_block_settings.phoenix_down", 1, 0, 5);
        Settings.PhoenixDown.healPercentageOfMaxLife = ConfigurationHandler.getInt("heal_percentage_of_max_life", "item_and_block_settings.phoenix_down", 100, 0, 100);
        Settings.PhoenixDown.removeNegativeStatus = ConfigurationHandler.getBoolean("remove_negative_status", "item_and_block_settings.phoenix_down", true);
        Settings.PhoenixDown.giveTemporaryDamageResistance = ConfigurationHandler.getBoolean("give_temporary_damage_resistance", "item_and_block_settings.phoenix_down", true);
        Settings.PhoenixDown.giveTemporaryRegeneration = ConfigurationHandler.getBoolean("give_temporary_regeneration", "item_and_block_settings.phoenix_down", true);
        Settings.PhoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou = ConfigurationHandler.getBoolean("give_temporary_fire_resistance_if_fire_damage_killed_you", "item_and_block_settings.phoenix_down", true);
        Settings.PhoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou = ConfigurationHandler.getBoolean("give_temporary_water_breathing_if_drowning_killed_you", "item_and_block_settings.phoenix_down", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.phoenix_down", true);
        Settings.PyromancerStaff.hungerCostPercent = ConfigurationHandler.getInt("hunger_cost_percent", "item_and_block_settings.pyromancer_staff", 5, 0, 10);
        Settings.PyromancerStaff.fireChargeLimit = ConfigurationHandler.getInt("fire_charge_limit", "item_and_block_settings.pyromancer_staff", 250, 0, itemCap);
        Settings.PyromancerStaff.fireChargeCost = ConfigurationHandler.getInt("fire_charge_cost", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        Settings.PyromancerStaff.fireChargeWorth = ConfigurationHandler.getInt("fire_charge_worth", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        Settings.PyromancerStaff.ghastAbsorbWorth = ConfigurationHandler.getInt("ghast_absorb_worth", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        Settings.PyromancerStaff.blazePowderLimit = ConfigurationHandler.getInt("blaze_powder_limit", "item_and_block_settings.pyromancer_staff", 250, 0, itemCap);
        Settings.PyromancerStaff.blazePowderCost = ConfigurationHandler.getInt("blaze_powder_cost", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        Settings.PyromancerStaff.blazePowderWorth = ConfigurationHandler.getInt("blaze_powder_worth", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        Settings.PyromancerStaff.blazeAbsorbWorth = ConfigurationHandler.getInt("blaze_absorb_worth", "item_and_block_settings.pyromancer_staff", 1, 0, 3);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.pyromancer_staff", true);
        Settings.RendingGale.chargeLimit = ConfigurationHandler.getInt("charge_limit", "item_and_block_settings.rending_gale", cleanShortMax, 0, cleanIntMax);
        Settings.RendingGale.castChargeCost = ConfigurationHandler.getInt("cast_charge_cost", "item_and_block_settings.rending_gale", 1, 0, 3);
        Settings.RendingGale.boltChargeCost = ConfigurationHandler.getInt("bolt_charge_cost", "item_and_block_settings.rending_gale", 100, 0, 250);
        Settings.RendingGale.chargeFeatherWorth = ConfigurationHandler.getInt("charge_feather_worth", "item_and_block_settings.rending_gale", 100, 1, 250);
        Settings.RendingGale.blockTargetRange = ConfigurationHandler.getInt("block_target_range", "item_and_block_settings.rending_gale", 12, 5, 15);
        Settings.RendingGale.pushPullRadius = ConfigurationHandler.getInt("push_pull_radius", "item_and_block_settings.rending_gale", 10, 1, 20);
        Settings.RendingGale.canPushProjectiles = ConfigurationHandler.getBoolean("can_push_projectiles", "item_and_block_settings.rending_gale", false);
        Settings.RendingGale.pedestalFlightRange = ConfigurationHandler.getInt("pedestal_flight_range", "item_and_block_settings.rending_gale", 30, 10, 100);
        Settings.RendingGale.pedestalCostPerSecond = ConfigurationHandler.getInt("pedestal_cost_per_second", "item_and_block_settings.rending_gale", 5, 1, 20);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.rending_gale", true);
        Settings.RodOfLyssa.useLeveledFailureRate = ConfigurationHandler.getBoolean("use_leveled_failure_rate", "item_and_block_settings.rod_of_lyssa", true);
        Settings.RodOfLyssa.levelCapForLeveledFormula = ConfigurationHandler.getInt("level_cap_for_leveled_formula", "item_and_block_settings.rod_of_lyssa", 100, 1, 900);
        Settings.RodOfLyssa.flatStealFailurePercentRate = ConfigurationHandler.getInt("flat_steal_failure_percent_rate", "item_and_block_settings.rod_of_lyssa", 10, 0, 100);
        Settings.RodOfLyssa.stealFromVacantSlots = ConfigurationHandler.getBoolean("steal_from_vacant_slots", "item_and_block_settings.rod_of_lyssa", true);
        Settings.RodOfLyssa.failStealFromVacantSlots = ConfigurationHandler.getBoolean("fail_steal_from_vacant_slots", "item_and_block_settings.rod_of_lyssa", false);
        Settings.RodOfLyssa.angerOnStealFailure = ConfigurationHandler.getBoolean("anger_on_steal_failure", "item_and_block_settings.rod_of_lyssa", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.rod_of_lyssa", true);
        ImmutableList torches = ImmutableList.of();
        Settings.SojournerStaff.torches = ConfigurationHandler.getStringList("torches", "item_and_block_settings.sojourner_staff", (List<String>)torches);
        Settings.SojournerStaff.maxCapacityPerItemType = ConfigurationHandler.getInt("max_capacity_per_item_type", "item_and_block_settings.sojourner_staff", 1500, 1, itemCap);
        Settings.SojournerStaff.maxRange = ConfigurationHandler.getInt("max_range", "item_and_block_settings.sojourner_staff", 30, 1, 30);
        Settings.SojournerStaff.tilePerCostMultiplier = ConfigurationHandler.getInt("tile_per_cost_multiplier", "item_and_block_settings.sojourner_staff", 6, 6, 30);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.sojourner_staff", true);
        Settings.TwilightCloak.maxLightLevel = ConfigurationHandler.getInt("max_light_level", "item_and_block_settings.twilight_cloak", 4, 0, 15);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.twilight_cloak", true);
        Settings.VoidTear.itemLimit = ConfigurationHandler.getInt("item_limit", "item_and_block_settings.void_tear", 2000000000, 0, cleanIntMax);
        Settings.VoidTear.absorbWhenCreated = ConfigurationHandler.getBoolean("absorb_when_created", "item_and_block_settings.void_tear", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.void_tear", true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings", true);
        Settings.Potions.maxEffectCount = ConfigurationHandler.getInt("max_effect_count", "item_and_block_settings.potions", 1, 1, 6);
        Settings.Potions.threeIngredients = ConfigurationHandler.getBoolean("three_ingredients", "item_and_block_settings.potions", false);
        Settings.Potions.differentDurations = ConfigurationHandler.getBoolean("different_durations", "item_and_block_settings.potions", false);
        Settings.Potions.redstoneAndGlowstone = ConfigurationHandler.getBoolean("redstone_and_glowstone", "item_and_block_settings.potions", false);
        ConfigCategory potionCategory = ConfigurationHandler.configuration.getCategory("item_and_block_settings.potions");
        potionCategory.setRequiresMcRestart(true);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.potions", true);
        Settings.Pedestal.meleeWrapperRange = ConfigurationHandler.getInt("melee_wrapper_range", "item_and_block_settings.pedestal", 5, 1, 10);
        Settings.Pedestal.meleeWrapperCooldown = (byte)ConfigurationHandler.getInt("melee_wrapper_cooldown", "item_and_block_settings.pedestal", 5, 1, 200);
        Settings.Pedestal.bucketWrapperRange = ConfigurationHandler.getInt("bucket_wrapper_range", "item_and_block_settings.pedestal", 4, 1, 10);
        Settings.Pedestal.bucketWrapperCooldown = (byte)ConfigurationHandler.getInt("bucket_wrapper_cooldown", "item_and_block_settings.pedestal", 40, 1, 200);
        Settings.Pedestal.shearsWrapperRange = ConfigurationHandler.getInt("shears_wrapper_range", "item_and_block_settings.pedestal", 4, 1, 10);
        Settings.Pedestal.shearsWrapperCooldown = (byte)ConfigurationHandler.getInt("shears_wrapper_cooldown", "item_and_block_settings.pedestal", 10, 1, 200);
        Settings.Pedestal.redstoneWrapperRange = ConfigurationHandler.getInt("redstone_wrapper_range", "item_and_block_settings.pedestal", 10, 1, 200);
        ConfigurationHandler.setCategoryTranslations("item_and_block_settings.pedestal", true);
    }
}

