/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockAlkahestryAltar;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.BlockApothecaryMortar;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.blocks.BlockInterdictionTorch;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.BlockPedestalPassive;
import xreliquary.blocks.BlockWraithNode;
import xreliquary.blocks.tile.TileEntityAltar;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.items.block.ItemBlockBase;
import xreliquary.items.block.ItemBlockPedestal;
import xreliquary.items.block.ItemFertileLilyPad;
import xreliquary.reference.Settings;

public class ModBlocks {
    public static final BlockApothecaryCauldron apothecaryCauldron = new BlockApothecaryCauldron();
    public static final BlockAlkahestryAltar alkahestryAltar = new BlockAlkahestryAltar(false);
    public static final BlockAlkahestryAltar alkahestryAltarActive = new BlockAlkahestryAltar(true);
    public static final BlockBase apothecaryMortar = new BlockApothecaryMortar();
    public static final BlockFertileLilypad fertileLilypad = new BlockFertileLilypad();
    public static final BlockInterdictionTorch interdictionTorch = new BlockInterdictionTorch();
    public static final BlockWraithNode wraithNode = new BlockWraithNode();
    public static final BlockPedestal pedestal = new BlockPedestal();
    public static final BlockPedestalPassive pedestalPassive = new BlockPedestalPassive();

    public static void init() {
        ModBlocks.registerBlock(apothecaryCauldron, new ItemBlockBase(apothecaryCauldron), "apothecary_cauldron");
        ModBlocks.registerBlock(alkahestryAltar, new ItemBlockBase(alkahestryAltar), "altar_idle");
        ModBlocks.registerBlock(alkahestryAltarActive, new ItemBlockBase(alkahestryAltarActive), "altar");
        ModBlocks.registerBlock(apothecaryMortar, new ItemBlockBase(apothecaryMortar), "apothecary_mortar");
        ModBlocks.registerBlock((Block)fertileLilypad, new ItemFertileLilyPad((Block)fertileLilypad), "fertile_lilypad");
        ModBlocks.registerBlock((Block)interdictionTorch, new ItemBlockBase((Block)interdictionTorch), "interdiction_torch");
        ModBlocks.registerBlock(wraithNode, new ItemBlockBase(wraithNode), "wraith_node");
        ModBlocks.registerBlock(pedestal, new ItemBlockPedestal(pedestal), "pedestal", true);
        ModBlocks.registerBlock(pedestalPassive, new ItemBlockPedestal(pedestalPassive), "pedestal_passive", true);
    }

    public static void initTileEntities() {
        ModBlocks.registerTileEntity(TileEntityAltar.class, "reliquaryAltar");
        ModBlocks.registerTileEntity(TileEntityMortar.class, "apothecaryMortar");
        ModBlocks.registerTileEntity(TileEntityCauldron.class, "reliquaryCauldron");
        ModBlocks.registerTileEntity(TileEntityPedestal.class, "reliquaryPedestal");
        ModBlocks.registerTileEntity(TileEntityPedestalPassive.class, "reliquaryPedestalPassive");
    }

    private static void registerTileEntity(Class clazz, String name) {
        if (Settings.disabledItemsBlocks.contains(name)) {
            return;
        }
        GameRegistry.registerTileEntity((Class)clazz, (String)("xreliquary." + name));
    }

    private static void registerBlock(Block block, ItemBlock itemBlock, String name) {
        ModBlocks.registerBlock(block, itemBlock, name, false);
    }

    private static void registerBlock(Block block, ItemBlock itemBlock, String name, boolean jeiOneDescription) {
        if (Settings.disabledItemsBlocks.contains(name)) {
            return;
        }
        block.setRegistryName(new ResourceLocation("xreliquary", name));
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock.setRegistryName(block.getRegistryName()));
        Reliquary.PROXY.registerJEI(block, name, jeiOneDescription);
    }
}

