/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModItems;
import xreliquary.util.LogHelper;

public class ModFluids {
    private static final String XP_JUICE_FLUID_NAME = "xpjuice";
    private static final String MILK_FLUID_NAME = "milk";
    public static Fluid fluidXpJuice;
    public static Fluid milk;

    public static void init() {
        FluidContainerRegistry.registerFluidContainer((Fluid)FluidRegistry.WATER, (ItemStack)new ItemStack((Item)ModItems.emperorChalice), (ItemStack)new ItemStack((Item)ModItems.emperorChalice));
        if (!Loader.isModLoaded((String)"OpenBlocks") && !Loader.isModLoaded((String)"EnderIO")) {
            LogHelper.info("XP Juice registered by Reliquary.");
            fluidXpJuice = new Fluid(XP_JUICE_FLUID_NAME, new ResourceLocation("xreliquary", "fluids/xpjuice_still"), new ResourceLocation("xreliquary", "fluids/xpjuice_flowing")).setLuminosity(10).setDensity(800).setViscosity(1500).setUnlocalizedName("xreliquary.xpjuice");
            FluidRegistry.registerFluid((Fluid)fluidXpJuice);
        } else {
            LogHelper.info("XP Juice registration left to Open Blocks / Ender IO.");
        }
        if (!Loader.isModLoaded((String)"tconstruct") && !FluidRegistry.isFluidRegistered((String)MILK_FLUID_NAME)) {
            milk = new Fluid(MILK_FLUID_NAME, new ResourceLocation("xreliquary", "fluids/milk"), new ResourceLocation("xreliquary", "fluids/milk_flowing")).setTemperature(320);
            FluidRegistry.registerFluid((Fluid)milk);
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(milk, 1000), (ItemStack)new ItemStack(Items.field_151117_aB), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        }
    }

    public static void postInit() {
        if (fluidXpJuice == null && (fluidXpJuice = FluidRegistry.getFluid((String)XP_JUICE_FLUID_NAME)) == null) {
            LogHelper.error("Liquid XP Juice registration left to open blocks / Ender IO but could not be found.");
        }
        if (milk == null) {
            milk = FluidRegistry.getFluid((String)MILK_FLUID_NAME);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onIconLoad(TextureStitchEvent.Pre event) {
        if (fluidXpJuice != null) {
            event.getMap().func_174942_a(fluidXpJuice.getStill());
            event.getMap().func_174942_a(fluidXpJuice.getFlowing());
        }
    }
}

