/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xreliquary.loot.EntityPowered;
import xreliquary.reference.Settings;

public class ModLoot {
    private static final List<String> CHEST_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"desert_pyramid", (Object)"end_city_treasure", (Object)"igloo_chest", (Object)"jungle_temple", (Object)"nether_bridge", (Object)"simple_dungeon", (Object)"stronghold_corridor", (Object)"stronghold_crossing", (Object)"stronghold_library", (Object)"village_blacksmith");
    private static final List<String> ENTITY_TABLES = ImmutableList.of((Object)"bat", (Object)"blaze", (Object)"cave_spider", (Object)"creeper", (Object)"enderman", (Object)"ghast", (Object)"magma_cube", (Object)"skeleton", (Object)"slime", (Object)"snowman", (Object)"spider", (Object)"squid", (Object[])new String[]{"witch", "wither_skeleton", "zombie", "zombie_pigman"});

    public static void init() {
        if (Settings.chestLootEnabled) {
            for (String s : CHEST_TABLES) {
                LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("xreliquary", "inject/chests/" + s));
            }
        }
        if (Settings.mobDropsEnabled) {
            for (String s : ENTITY_TABLES) {
                LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("xreliquary", "inject/entities/" + s));
            }
            EntityPropertyManager.func_186644_a((EntityProperty.Serializer)new EntityPowered.Serializer());
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        String chests_prefix = "minecraft:chests/";
        String entities_prefix = "minecraft:entities/";
        String name = evt.getName().toString();
        if (Settings.chestLootEnabled && name.startsWith(chests_prefix) && CHEST_TABLES.contains(name.substring(chests_prefix.length())) || Settings.mobDropsEnabled && name.startsWith(entities_prefix) && ENTITY_TABLES.contains(name.substring(entities_prefix.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(this.getInjectPool(file));
        }
    }

    private LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "xreliquary_inject_pool");
    }

    private LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("xreliquary", "inject/" + name), weight, 0, new LootCondition[0], "xreliquary_inject_entry");
    }
}

