/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.init.ModCapabilities;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.HarvestRodItemStackHandler;
import xreliquary.items.util.IHarvestRodCache;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketItemHandlerSync;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemHarvestRod
extends ItemToggleable {
    public static final String BONE_MEAL_MODE = "bone_meal";
    public static final String PLANTABLE_MODE = "plantable";
    public static final String HOE_MODE = "hoe";
    public static final String MODE_NBT_TAG = "mode";
    public static final String PLANTABLE_INDEX_NBT_TAG = "plantable_index";
    public static final String PLANTABLE_QUANTITIES_NBT_TAG = "plantable_quantities";
    private static final int AOE_START_COOLDOWN = 10;

    public ItemHarvestRod() {
        super("harvest_rod");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(this.getBoneMealCount(ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.WHITE + Items.field_151100_aR.func_77653_i(new ItemStack(Items.field_151100_aR, 1, 15)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public int getBonemealLimit() {
        return Settings.HarvestRod.boneMealLimit;
    }

    public int getBonemealWorth() {
        return Settings.HarvestRod.boneMealWorth;
    }

    public int getBonemealCost() {
        return Settings.HarvestRod.boneMealCost;
    }

    public int getLuckRolls() {
        return Settings.HarvestRod.boneMealLuckRolls;
    }

    public int getLuckPercent() {
        return Settings.HarvestRod.boneMealLuckPercentChance;
    }

    public int getBreakRadius() {
        return Settings.HarvestRod.AOERadius;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            HarvestRodItemStackHandler itemHandler = new HarvestRodItemStackHandler();

            public NBTTagCompound serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound tagCompound) {
                this.itemHandler.deserializeNBT(tagCompound);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)this.itemHandler;
                }
                return null;
            }
        };
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int slotNumber, boolean isSelected) {
        this.handleBackwardsCompatibility(ist);
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist)) {
            if (this.getBoneMealCount(ist) + this.getBonemealWorth() <= this.getBonemealLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151100_aR, 1, 15), player)) {
                this.setBoneMealCount(ist, this.getBoneMealCount(ist) + this.getBonemealWorth(), slotNumber, player);
            }
            this.consumePlantables(ist, player, slotNumber);
        }
        if (player.field_71071_by.func_70301_a(slotNumber) != null && player.field_71071_by.func_70301_a(slotNumber).func_77973_b() == ModItems.harvestRod && isSelected) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
        } else if (player.field_71071_by.field_184439_c[0] != null && player.field_71071_by.field_184439_c[0].func_77973_b() == ModItems.harvestRod) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(EnumHand.OFF_HAND, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
        }
    }

    private NBTTagCompound getItemHandlerNBT(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.serializeNBT();
    }

    @Deprecated
    private void handleBackwardsCompatibility(ItemStack ist) {
        if (ist.func_77978_p() != null && ist.func_77978_p().func_74764_b("bonemeal")) {
            IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (itemHandler instanceof FilteredItemStackHandler) {
                FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
                if (ist.func_77978_p().func_74764_b("bonemeal")) {
                    filteredHandler.setTotalAmount(0, NBTHelper.getInteger("bonemeal", ist));
                    ist.func_77978_p().func_82580_o("bonemeal");
                }
                if (ist.func_77978_p().func_74764_b("Items")) {
                    NBTTagList itemsList = ist.func_77978_p().func_150295_c("Items", 10);
                    NBTTagList quantities = ist.func_77978_p().func_150295_c(PLANTABLE_QUANTITIES_NBT_TAG, 3);
                    for (int i = 0; i < itemsList.func_74745_c(); ++i) {
                        NBTTagCompound item = itemsList.func_150305_b(i);
                        byte slotIndex = item.func_74771_c("Slot");
                        if (slotIndex < 0) continue;
                        int slot = itemHandler.getSlots() - 1;
                        filteredHandler.insertItem(slot, ItemStack.func_77949_a((NBTTagCompound)item), false);
                        filteredHandler.setTotalAmount(filteredHandler.getParentSlot(slot), ((NBTTagInt)quantities.func_179238_g(i)).func_150287_d());
                    }
                    ist.func_77978_p().func_82580_o("Items");
                    ist.func_77978_p().func_82580_o(PLANTABLE_QUANTITIES_NBT_TAG);
                }
            }
            this.setMode(ist, BONE_MEAL_MODE);
        }
    }

    private void consumePlantables(ItemStack harvestRod, EntityPlayer player, int slotNumber) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            ItemStack currentStack = player.field_71071_by.field_70462_a[slot];
            if (currentStack == null || !(currentStack.func_77973_b() instanceof IPlantable) || !this.incrementPlantable(harvestRod, currentStack, slotNumber, player)) continue;
            InventoryHelper.consumeItem(currentStack, player, 0, 1);
            break;
        }
    }

    public boolean onBlockStartBreak(ItemStack ist, BlockPos pos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        boolean brokenBlock = false;
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IPlantable || block instanceof BlockCrops || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        this.doHarvestBlockBreak(block, ist, pos, player, xOff, yOff, zOff);
                        brokenBlock = true;
                    }
                }
            }
        }
        return brokenBlock;
    }

    public boolean doHarvestBlockBreak(Block initialBlock, ItemStack ist, BlockPos pos, EntityPlayer player, int xOff, int yOff, int zOff) {
        pos = pos.func_177982_a(xOff, yOff, zOff);
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if ((initialBlock == Blocks.field_150440_ba || initialBlock == Blocks.field_150423_aK) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (!(block instanceof IPlantable) && !(block instanceof BlockCrops) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (block instanceof BlockFertileLilypad) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            for (int particles = 0; particles <= 8; ++particles) {
                player.field_70170_p.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
            }
        } else {
            List drops = blockState.func_177230_c().getDrops((IBlockAccess)player.field_70170_p, pos, blockState, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ist));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            player.func_71029_a(StatList.func_188055_a((Block)blockState.func_177230_c()));
            player.func_71020_j(0.01f);
        }
        return true;
    }

    private void boneMealBlock(ItemStack ist, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing side) {
        ItemStack fakeItemStack = new ItemStack(Items.field_151100_aR, 1, 15);
        ItemDye fakeItemDye = (ItemDye)fakeItemStack.func_77973_b();
        boolean usedRod = false;
        for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > this.getLuckPercent() || fakeItemDye.func_180614_a(fakeItemStack, player, world, pos, EnumHand.MAIN_HAND, side, 0.0f, 0.0f, 0.0f) != EnumActionResult.SUCCESS) continue;
            if (!usedRod) {
                usedRod = true;
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.NEUTRAL, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        }
        if (usedRod && !player.field_71075_bZ.field_75098_d) {
            this.setBoneMealCount(ist, this.getBoneMealCount(ist) - this.getBonemealCost(), hand, player);
        }
    }

    public int getBoneMealCount(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(HarvestRodItemStackHandler.BONEMEAL_SLOT);
    }

    public void setBoneMealCount(ItemStack ist, int boneMealCount) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, boneMealCount);
    }

    private boolean incrementPlantable(ItemStack harvestRod, ItemStack plantable, int slotNumber, EntityPlayer player) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return false;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        ItemStack plantableCopy = plantable.func_77946_l();
        plantableCopy.field_77994_a = 1;
        for (int slot = 2; slot < filteredHandler.getSlots(); ++slot) {
            ItemStack remainingStack = filteredHandler.insertItem(slot, plantableCopy, false);
            if (remainingStack != null && remainingStack.field_77994_a != 0) continue;
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(harvestRod)), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    private void setBoneMealCount(ItemStack ist, int boneMealCount, int slotNumber, EntityPlayer player) {
        this.setBoneMealCount(ist, boneMealCount);
        PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
    }

    private void setBoneMealCount(ItemStack ist, int boneMealCount, EnumHand hand, EntityPlayer player) {
        this.setBoneMealCount(ist, boneMealCount);
        PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(hand, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
    }

    private void decrementPlantable(ItemStack harvestRod, int parentSlot, EnumHand hand, EntityPlayer player) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(parentSlot, filteredHandler.getTotalAmount(parentSlot) - 1);
        PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(hand, this.getItemHandlerNBT(harvestRod)), (EntityPlayerMP)player);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(stack, world, player, hand);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 300;
    }

    public void func_77615_a(ItemStack harvestRod, World world, EntityLivingBase entity, int timeLeft) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        RayTraceResult result = this.func_77621_a(player.field_70170_p, player, true);
        if (result != null) {
            IHarvestRodCache cache = (IHarvestRodCache)harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null);
            if (cache != null) {
                cache.reset();
            }
            BlockPos pos = result.func_178782_a();
            if (this.getMode(harvestRod) == BONE_MEAL_MODE) {
                if (this.getBoneMealCount(harvestRod) >= this.getBonemealCost() || player.field_71075_bZ.field_75098_d) {
                    this.boneMealBlock(harvestRod, player, player.func_184600_cs(), world, pos, EnumFacing.UP);
                }
            } else if (this.getMode(harvestRod) == PLANTABLE_MODE && (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) > 0 || player.field_71075_bZ.field_75098_d)) {
                this.plantItem(harvestRod, player, pos, player.func_184600_cs());
            }
        } else {
            this.removeStackFromCurrent(harvestRod, player, player.func_184600_cs());
        }
    }

    private void removeStackFromCurrent(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (this.getMode(stack).equals(BONE_MEAL_MODE)) {
            ItemStack boneMealStack = new ItemStack(Items.field_151100_aR, 1, 15);
            int numberToAdd = Math.min(boneMealStack.func_77976_d(), this.getBoneMealCount(stack));
            int numberAdded = InventoryHelper.tryToAddToInventory(boneMealStack, (IInventory)player.field_71071_by, 0, numberToAdd);
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - numberAdded, hand, player);
        } else if (this.getMode(stack).equals(PLANTABLE_MODE)) {
            byte plantableSlot = this.getCurrentPlantableSlot(stack);
            ItemStack plantableStack = this.getCurrentPlantable(stack);
            int plantableQuantity = this.getPlantableQuantity(stack, plantableSlot);
            int numberToAdd = Math.min(plantableStack.func_77976_d(), plantableQuantity);
            int numberAdded = InventoryHelper.tryToAddToInventory(plantableStack, (IInventory)player.field_71071_by, 0, numberToAdd);
            int updatedPlantableQuantity = this.getPlantableQuantity(stack, plantableSlot) - numberAdded;
            this.setPlantableQuantity(stack, plantableSlot, updatedPlantableQuantity, hand, player);
            if (updatedPlantableQuantity == 0) {
                this.shiftModeOnEmptyPlantable(stack, plantableSlot);
            }
        }
    }

    public void shiftModeOnEmptyPlantable(ItemStack harvestRod, byte plantableSlot) {
        if (plantableSlot > 0) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(plantableSlot - 1));
        }
        this.cycleMode(harvestRod);
    }

    private void plantItem(ItemStack harvestRod, EntityPlayer player, BlockPos pos, EnumHand hand) {
        byte plantableSlot = this.getCurrentPlantableSlot(harvestRod);
        ItemStack fakePlantableStack = this.getCurrentPlantable(harvestRod).func_77946_l();
        fakePlantableStack.field_77994_a = 1;
        if (fakePlantableStack.func_179546_a(player, player.field_70170_p, pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            if (!player.field_71075_bZ.field_75098_d) {
                int plantableQuantity = this.getPlantableQuantity(harvestRod, plantableSlot);
                this.decrementPlantable(harvestRod, plantableSlot, hand, player);
                if (plantableQuantity <= 1) {
                    this.shiftModeOnEmptyPlantable(harvestRod, plantableSlot);
                }
            }
        }
    }

    public ItemStack getCurrentPlantable(ItemStack harvestRod) {
        byte currentSlot = this.getCurrentPlantableSlot(harvestRod);
        return this.getPlantableInSlot(harvestRod, currentSlot);
    }

    public ItemStack getPlantableInSlot(ItemStack harvestRod, int currentSlot) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getStackInParentSlot(currentSlot);
    }

    public void onUsingTick(ItemStack harvestRod, EntityLivingBase entity, int count) {
        RayTraceResult result;
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.isCoolDownOver(harvestRod, count) && (result = this.func_77621_a(player.field_70170_p, player, true)) != null) {
            World world = player.field_70170_p;
            IHarvestRodCache cache = (IHarvestRodCache)harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null);
            if (cache != null) {
                switch (this.getMode(harvestRod)) {
                    case "bone_meal": {
                        BlockPos blockToBoneMeal;
                        if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.field_71075_bZ.field_75098_d || (blockToBoneMeal = this.getNextBlockToBoneMeal(world, cache, result.func_178782_a(), Settings.HarvestRod.AOERadius)) == null) break;
                        this.boneMealBlock(harvestRod, player, player.func_184600_cs(), world, blockToBoneMeal, EnumFacing.UP);
                        return;
                    }
                    case "plantable": {
                        BlockPos blockToPlantOn;
                        if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) < 1 && !player.field_71075_bZ.field_75098_d || (blockToPlantOn = this.getNextBlockToPlantOn(world, cache, result.func_178782_a(), Settings.HarvestRod.AOERadius, (IPlantable)this.getCurrentPlantable(harvestRod).func_77973_b())) == null) break;
                        this.plantItem(harvestRod, player, blockToPlantOn, player.func_184600_cs());
                        return;
                    }
                    case "hoe": {
                        ItemStack fakeHoe = new ItemStack(Items.field_151017_I);
                        BlockPos blockToHoe = this.getNextBlockToHoe(world, cache, result.func_178782_a(), Settings.HarvestRod.AOERadius);
                        if (blockToHoe == null) break;
                        if (Items.field_151017_I.func_180614_a(fakeHoe, player, world, blockToHoe, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(SoundEvents.field_187693_cj, SoundCategory.BLOCKS, (double)blockToHoe.func_177958_n(), (double)blockToHoe.func_177956_o(), (double)blockToHoe.func_177952_p(), 1.0f, 1.0f));
                        }
                        return;
                    }
                }
            }
        }
    }

    private BlockPos getNextBlockToHoe(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToHoe(world, cache, pos, range);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToHoe(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    Block block = blockState.func_177230_c();
                    if (!world.func_175623_d(currentPos.func_177984_a()) || block != Blocks.field_150349_c && (block != Blocks.field_150346_d || blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT && blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.COARSE_DIRT)) continue;
                    cache.addBlockToQueue(currentPos);
                }
            }
        }
    }

    private BlockPos getNextBlockToPlantOn(World world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToPlant(world, cache, pos, range, plantable);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToPlant(World world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Items.field_151080_bb || plantable == Items.field_151081_bc) {
            checkerboard = true;
            boolean xEven = pos.func_177958_n() % 2 == 0;
            boolean zEven = pos.func_177952_p() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (checkerboard && bothOddOrEven != (currentPos.func_177958_n() % 2 == 0 == (currentPos.func_177952_p() % 2 == 0)) || !blockState.func_177230_c().canSustainPlant(blockState, (IBlockAccess)world, pos, EnumFacing.UP, plantable) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                    cache.addBlockToQueue(currentPos);
                }
            }
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (entityLiving.func_70093_af()) {
            this.cycleMode(stack);
            return true;
        }
        return false;
    }

    private boolean isCoolDownOver(ItemStack stack, int count) {
        return this.func_77626_a(stack) - count >= 10 && (this.func_77626_a(stack) - count) % Settings.HarvestRod.AOECooldown == 0;
    }

    private BlockPos getNextBlockToBoneMeal(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToBoneMeal(world, cache, pos, range);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToBoneMeal(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (!(blockState.func_177230_c() instanceof IGrowable) || !((IGrowable)blockState.func_177230_c()).func_176473_a(world, currentPos, blockState, world.field_72995_K)) continue;
                    cache.addBlockToQueue(currentPos);
                }
            }
        }
    }

    private void cycleMode(ItemStack harvestRod) {
        String currentMode = this.getMode(harvestRod);
        int plantableCount = this.getCountPlantable(harvestRod);
        switch (currentMode) {
            case "bone_meal": {
                if (plantableCount > 0) {
                    this.setMode(harvestRod, PLANTABLE_MODE);
                    this.setCurrentPlantableSlot(harvestRod, (byte)1);
                    break;
                }
                this.setMode(harvestRod, HOE_MODE);
                break;
            }
            case "plantable": {
                if (plantableCount > this.getCurrentPlantableSlot(harvestRod)) {
                    this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) + 1));
                    break;
                }
                this.setMode(harvestRod, HOE_MODE);
                break;
            }
            case "hoe": {
                this.setMode(harvestRod, BONE_MEAL_MODE);
                break;
            }
        }
    }

    public int getCountPlantable(ItemStack harvestRod) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getSlots() / 2 - 2;
    }

    public byte getCurrentPlantableSlot(ItemStack stack) {
        return stack.func_77978_p().func_74771_c(PLANTABLE_INDEX_NBT_TAG);
    }

    private void setCurrentPlantableSlot(ItemStack stack, byte index) {
        stack.func_77978_p().func_74774_a(PLANTABLE_INDEX_NBT_TAG, index);
    }

    private void setMode(ItemStack stack, String mode) {
        NBTHelper.setString(MODE_NBT_TAG, stack, mode);
    }

    public String getMode(ItemStack stack) {
        String mode = NBTHelper.getString(MODE_NBT_TAG, stack);
        return mode.equals("") ? BONE_MEAL_MODE : mode;
    }

    public int getPlantableQuantity(ItemStack harvestRod, int parentSlot) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(parentSlot);
    }

    public void setPlantableQuantity(ItemStack harvestRod, byte plantableSlot, int quantity) {
        this.setPlantableQuantity(harvestRod, plantableSlot, quantity, null, null);
    }

    public void setPlantableQuantity(ItemStack harvestRod, byte plantableSlot, int quantity, EnumHand hand, EntityPlayer player) {
        IItemHandler itemHandler = (IItemHandler)harvestRod.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(plantableSlot, quantity);
        if (quantity != 0 && player != null) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(hand, this.getItemHandlerNBT(harvestRod)), (EntityPlayerMP)player);
        }
    }
}

