/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.init.ModFluids;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.XpHelper;

public class ItemHeroMedallion
extends ItemToggleable
implements IFluidContainerItem {
    public ItemHeroMedallion() {
        super("hero_medallion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"experience", (Object)String.valueOf(NBTHelper.getInteger("experience", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + "XP")), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    private int getExperienceMinimum() {
        return Settings.HeroMedallion.experienceLevelMinimum;
    }

    private int getExperienceMaximum() {
        return Settings.HeroMedallion.experienceLevelMaximum;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(ist)) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            int levelLoop = 0;
            while (true) {
                double d = levelLoop;
                double d2 = !player.field_71075_bZ.field_75098_d ? (double)player.field_71068_ca : 30.0;
                if (!(d <= Math.sqrt(d2))) break;
                if ((player.field_71068_ca > this.getExperienceMinimum() || player.field_71106_cc > 0.0f || player.field_71075_bZ.field_75098_d) && this.getExperience(ist) < Integer.MAX_VALUE) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.decreasePlayerExperience(player);
                    }
                    this.increaseMedallionExperience(ist);
                }
                ++levelLoop;
            }
        }
    }

    public void decreasePlayerExperience(EntityPlayer player) {
        if (player.field_71106_cc - 1.0f / (float)player.func_71050_bK() <= 0.0f && player.field_71068_ca > this.getExperienceMinimum()) {
            this.decreasePlayerLevel(player);
            return;
        }
        player.field_71106_cc -= Math.min(1.0f / (float)player.func_71050_bK(), player.field_71106_cc);
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
    }

    public void decreaseMedallionExperience(ItemStack ist) {
        this.setExperience(ist, this.getExperience(ist) - 1);
    }

    public void decreasePlayerLevel(EntityPlayer player) {
        player.field_71106_cc = 1.0f - 1.0f / (float)player.func_71050_bK();
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
        --player.field_71068_ca;
    }

    public void increasePlayerExperience(EntityPlayer player) {
        player.func_71023_q(1);
    }

    public void increaseMedallionExperience(ItemStack ist) {
        this.setExperience(ist, this.getExperience(ist) + 1);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInteger("experience", stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.setInteger("experience", stack, i);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
        }
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player, hand);
        }
        int playerLevel = player.field_71068_ca;
        while (player.field_71068_ca < this.getExperienceMaximum() && playerLevel == player.field_71068_ca && (this.getExperience(ist) > 0 || player.field_71075_bZ.field_75098_d)) {
            this.increasePlayerExperience(player);
            if (player.field_71075_bZ.field_75098_d) continue;
            this.decreaseMedallionExperience(ist);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.isEnabled(container)) {
            return null;
        }
        return new FluidStack(ModFluids.fluidXpJuice, XpHelper.experienceToLiquid(this.getExperience(container)));
    }

    public int getCapacity(ItemStack container) {
        return Integer.MAX_VALUE;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource.getFluid() != ModFluids.fluidXpJuice) {
            return 0;
        }
        if (doFill) {
            this.setExperience(container, this.getExperience(container) + XpHelper.liquidToExperience(resource.amount));
        }
        return resource.amount;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int experienceToRemove = Math.min(XpHelper.liquidToExperience(maxDrain), this.getExperience(container));
        if (doDrain) {
            this.setExperience(container, this.getExperience(container) - experienceToRemove);
        }
        return new FluidStack(ModFluids.fluidXpJuice, XpHelper.experienceToLiquid(experienceToRemove));
    }
}

