/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;
import xreliquary.util.alkahestry.AlkahestCraftRecipe;

public class ItemInfernalTear
extends ItemToggleable {
    public ItemInfernalTear() {
        super("infernal_tear");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean flag) {
        if (world.field_72995_K || !this.isEnabled(ist)) {
            return;
        }
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        String ident = ist.func_77978_p().func_74779_i("itemID");
        if (ident.isEmpty()) {
            NBTTagCompound tag = ist.func_77978_p();
            tag.func_82580_o("itemID");
            tag.func_82580_o("enabled");
            return;
        }
        if (Settings.AlkahestryTome.craftingRecipes.containsKey(ident)) {
            AlkahestCraftRecipe recipe = Settings.AlkahestryTome.craftingRecipes.get(ident);
            if ((recipe.yield != 32 || recipe.cost != 4) && InventoryHelper.consumeItem(this.getStackFromTear(ist), player)) {
                player.func_71023_q((int)Math.ceil((double)recipe.cost / (double)recipe.yield / 256.0 * 500.0));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(null, stack, list);
        if (this.getStackFromTear(stack) == null) {
            LanguageHelper.formatTooltip("tooltip.infernal_tear.tear_empty", null, null, list);
        } else {
            String itemName;
            ItemStack contents = this.getStackFromTear(stack);
            String holds = itemName = contents.func_82833_r();
            LanguageHelper.formatTooltip("tooltip.tear", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)itemName), stack, list);
            if (this.isEnabled(stack)) {
                LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + holds)), stack, list);
            }
            list.add(LanguageHelper.getLocalization("tooltip.absorb"));
            list.add(LanguageHelper.getLocalization("tooltip.infernal_tear.absorb_unset"));
        }
    }

    public ItemStack getStackFromTear(ItemStack tear) {
        if (NBTHelper.getString("itemID", tear).equals("")) {
            return null;
        }
        String[] nameParts = NBTHelper.getString("itemID", tear).split("\\|");
        ItemStack stack = nameParts.length > 1 ? new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(nameParts[0])), 1, Integer.parseInt(nameParts[1])) : new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(nameParts[0])));
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack returnStack;
        ActionResult<ItemStack> actionResult = super.func_77659_a(stack, world, player, hand);
        if (player.func_70093_af() && !this.isEnabled(stack)) {
            return actionResult;
        }
        ItemStack itemStack = (ItemStack)actionResult.func_188398_b();
        NBTTagCompound tag = itemStack.func_77978_p();
        if (!player.func_70093_af() && this.getStackFromTear(itemStack) != null) {
            tag.func_82580_o("itemID");
            tag.func_82580_o("enabled");
            return actionResult;
        }
        if (this.getStackFromTear(itemStack) != null) {
            return actionResult;
        }
        if ((player.func_70093_af() || !this.isEnabled(itemStack)) && (returnStack = this.buildTear(itemStack, player, (IInventory)player.field_71071_by)) != null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)returnStack);
        }
        if (this.isEnabled(itemStack)) {
            this.toggleEnabled(itemStack);
        }
        return actionResult;
    }

    private ItemStack buildTear(ItemStack stack, EntityPlayer player, IInventory inventory) {
        ItemStack tear = new ItemStack((Item)this, 1);
        ItemStack target = ItemInfernalTear.getTargetAlkahestItem(stack, inventory);
        if (target == null) {
            return null;
        }
        String itemID = RegistryHelper.getItemRegistryName(target.func_77973_b()) + (target.func_77973_b().func_77614_k() ? "|" + target.func_77960_j() : "");
        NBTHelper.setString("itemID", tear, itemID);
        if (Settings.InfernalTear.absorbWhenCreated) {
            NBTHelper.setBoolean("enabled", stack, true);
        }
        return tear;
    }

    protected void addTearToInventory(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            EntityItem entity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    public static ItemStack getTargetAlkahestItem(ItemStack self, IInventory inventory) {
        ItemStack targetItem = null;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || self.func_77969_a(stack) || stack.func_77976_d() == 1 || stack.func_77978_p() != null) continue;
            String key = RegistryHelper.getItemRegistryName(stack.func_77973_b()) + (stack.func_77973_b().func_77614_k() ? "|" + stack.func_77960_j() : "");
            if (!Settings.AlkahestryTome.craftingRecipes.containsKey(key) || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        inventory.func_70296_d();
        return targetItem;
    }
}

