/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemSojournerStaff;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.RegistryHelper;

public class ItemLanternOfParanoia
extends ItemToggleable {
    public ItemLanternOfParanoia() {
        super("lantern_of_paranoia");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    protected ItemLanternOfParanoia(String name) {
        super(name);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public int getRange() {
        return Settings.LanternOfParanoia.placementScanRadius;
    }

    public void func_77663_a(ItemStack stack, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(stack)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            if (e instanceof EntityPlayer) {
                player = (EntityPlayer)e;
            }
            if (player == null) {
                return;
            }
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            block0: for (int xDiff = -this.getRange(); xDiff <= this.getRange(); ++xDiff) {
                for (int zDiff = -this.getRange(); zDiff <= this.getRange(); ++zDiff) {
                    for (int yDiff = this.getRange() / 2; yDiff >= -this.getRange() / 2; --yDiff) {
                        int lightLevel;
                        int x = playerX + xDiff;
                        int y = playerY + yDiff;
                        int z = playerZ + zDiff;
                        if (player.field_70170_p.func_175623_d(new BlockPos(x, y, z)) && (lightLevel = player.field_70170_p.func_175671_l(new BlockPos(x, y, z))) <= Settings.LanternOfParanoia.minLightLevel && this.tryToPlaceTorchAround(stack, x, y, z, player, world)) break block0;
                    }
                }
            }
        }
    }

    private boolean findAndDrainSojournersStaff(EntityPlayer player) {
        ItemSojournerStaff staffItem = ModItems.sojournerStaff;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            if (player.field_71071_by.func_70301_a(slot) == null || staffItem != player.field_71071_by.func_70301_a(slot).func_77973_b()) continue;
            Item torch = ItemBlock.func_150898_a((Block)Blocks.field_150478_aa);
            if (!staffItem.removeItemFromInternalStorage(player.field_71071_by.func_70301_a(slot), torch, 1, player)) continue;
            return true;
        }
        return false;
    }

    public boolean tryToPlaceTorchAround(ItemStack stack, int xO, int yO, int zO, EntityPlayer player, World world) {
        float xOff;
        int x = xO;
        int y = yO;
        int z = zO;
        double playerEyeHeight = player.field_70163_u + (double)player.func_70047_e();
        for (xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    IBlockState blockState;
                    Vec3d playerVec = new Vec3d(player.field_70165_t + (double)xOff, playerEyeHeight + (double)yOff, player.field_70161_v + (double)zOff);
                    Vec3d rayTraceVector = new Vec3d((double)x + 0.5 + (double)xOff, (double)y + 0.5 + (double)yOff, (double)z + 0.5 + (double)zOff);
                    RayTraceResult rayTraceResult = world.func_147447_a(playerVec, rayTraceVector, false, false, true);
                    if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK || (blockState = world.func_180495_p(rayTraceResult.func_178782_a())).func_177230_c().func_185496_a(blockState, (IBlockAccess)world, rayTraceResult.func_178782_a()) == null || !blockState.func_177230_c().func_176209_a(blockState, false)) continue;
                    return false;
                }
            }
        }
        xOff = (float)player.field_70165_t;
        float zOff = (float)player.field_70161_v;
        float yOff = (float)player.field_70163_u;
        if (Blocks.field_150478_aa.func_176196_c(world, new BlockPos(x, y, z))) {
            int rotation = ((MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
            EnumFacing trySide = EnumFacing.DOWN;
            switch (rotation) {
                case 0: {
                    trySide = EnumFacing.EAST;
                    break;
                }
                case 1: {
                    trySide = EnumFacing.SOUTH;
                    break;
                }
                case 2: {
                    trySide = EnumFacing.WEST;
                    break;
                }
                case 3: {
                    trySide = EnumFacing.NORTH;
                }
            }
            ArrayList<EnumFacing> trySides = new ArrayList<EnumFacing>();
            trySides.add(trySide);
            trySides.add(EnumFacing.DOWN);
            EnumFacing[] tryOtherSides = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
            for (EnumFacing tryOtherSide : tryOtherSides) {
                if (trySides.contains(tryOtherSide)) continue;
                trySides.add(tryOtherSide);
            }
            for (EnumFacing side : trySides) {
                IBlockState torchBlockState;
                if (!world.func_175716_a(Blocks.field_150478_aa, new BlockPos(x, y, z), false, side, (Entity)player, stack) || !InventoryHelper.consumeItem(Blocks.field_150478_aa, player, 0, 1) && !this.findAndDrainSojournersStaff(player) || !this.placeBlockAt(stack, player, world, new BlockPos(x, y, z), torchBlockState = this.getTorchSideAttempt(world, new BlockPos(x, y, z), side, player))) continue;
                Blocks.field_150478_aa.func_176213_c(world, new BlockPos(x, y, z), torchBlockState);
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, gauss, gauss, 0.0, new int[0]);
                SoundType torchSoundType = Blocks.field_150478_aa.func_185467_w();
                world.func_184133_a(null, new BlockPos(x, y, z), torchSoundType.func_185844_d(), SoundCategory.BLOCKS, (torchSoundType.func_185843_a() + 1.0f) / 2.0f, torchSoundType.func_185847_b() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private IBlockState getTorchSideAttempt(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        return Blocks.field_150478_aa.func_180642_a(world, pos, side, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), 0, (EntityLivingBase)player);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState torchBlockState) {
        if (!world.func_180501_a(pos, torchBlockState, 3)) {
            return false;
        }
        if (RegistryHelper.blocksEqual(torchBlockState.func_177230_c(), Blocks.field_150478_aa)) {
            Blocks.field_150478_aa.func_189540_a(torchBlockState, world, pos, torchBlockState.func_177230_c());
            Blocks.field_150478_aa.func_180633_a(world, pos, torchBlockState, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

