/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemPyromancerStaff
extends ItemToggleable {
    public ItemPyromancerStaff() {
        super("pyromancer_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        this.doFireballAbsorbEffect(ist, player);
        if (!this.isEnabled(ist)) {
            this.doExtinguishEffect(player);
        } else {
            this.scanForFireChargeAndBlazePowder(ist, player);
        }
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        String charges = "0";
        String blaze = "0";
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = RegistryHelper.getItemFromName(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                if (containedItem == Items.field_151065_br) {
                    blaze = Integer.toString(quantity);
                    continue;
                }
                if (containedItem != Items.field_151059_bz) continue;
                charges = Integer.toString(quantity);
            }
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charges", (Object)charges, (Object)"blaze", (Object)blaze), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + Items.field_151065_br.func_77653_i(new ItemStack(Items.field_151065_br)) + TextFormatting.WHITE + " & " + TextFormatting.RED + Items.field_151059_bz.func_77653_i(new ItemStack(Items.field_151059_bz)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 11;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString("mode", ist).equals("")) {
            this.setMode(ist, "blaze");
        }
        return NBTHelper.getString("mode", ist);
    }

    public void setMode(ItemStack ist, String s) {
        NBTHelper.setString("mode", ist, s);
    }

    public void cycleMode(ItemStack ist) {
        if (this.getMode(ist).equals("blaze")) {
            this.setMode(ist, "charge");
        } else if (this.getMode(ist).equals("charge")) {
            this.setMode(ist, "eruption");
        } else if (this.getMode(ist).equals("eruption")) {
            this.setMode(ist, "flint_and_steel");
        } else {
            this.setMode(ist, "blaze");
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return true;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist);
        }
        return false;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            super.func_77659_a(ist, world, player, hand);
        } else if (this.getMode(ist).equals("blaze")) {
            if (player.field_82175_bq) {
                return new ActionResult(EnumActionResult.PASS, (Object)ist);
            }
            player.func_184609_a(hand);
            Vec3d lookVec = player.func_70040_Z();
            if (this.removeItemFromInternalStorage(ist, Items.field_151065_br, this.getBlazePowderCost(), player.field_70170_p.field_72995_K, player)) {
                player.field_70170_p.func_180498_a(player, 1018, new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), 0);
                EntitySmallFireball fireball = new EntitySmallFireball(player.field_70170_p, (EntityLivingBase)player, lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
                fireball.field_70232_b = lookVec.field_72450_a;
                fireball.field_70233_c = lookVec.field_72448_b;
                fireball.field_70230_d = lookVec.field_72449_c;
                fireball.field_70165_t += lookVec.field_72450_a;
                fireball.field_70163_u += lookVec.field_72448_b;
                fireball.field_70161_v += lookVec.field_72449_c;
                fireball.field_70163_u = player.field_70163_u + (double)player.func_70047_e();
                player.field_70170_p.func_72838_d((Entity)fireball);
            }
        } else if (this.getMode(ist).equals("charge")) {
            if (player.field_82175_bq) {
                return new ActionResult(EnumActionResult.PASS, (Object)ist);
            }
            player.func_184609_a(hand);
            Vec3d lookVec = player.func_70040_Z();
            if (this.removeItemFromInternalStorage(ist, Items.field_151059_bz, this.getFireChargeCost(), player.field_70170_p.field_72995_K, player)) {
                player.field_70170_p.func_180498_a(player, 1016, new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), 0);
                EntityLargeFireball fireball = new EntityLargeFireball(player.field_70170_p, (EntityLivingBase)player, lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
                fireball.field_70232_b = lookVec.field_72450_a;
                fireball.field_70233_c = lookVec.field_72448_b;
                fireball.field_70230_d = lookVec.field_72449_c;
                fireball.field_70165_t += lookVec.field_72450_a;
                fireball.field_70163_u += lookVec.field_72448_b;
                fireball.field_70161_v += lookVec.field_72449_c;
                fireball.field_70163_u = player.field_70163_u + (double)player.func_70047_e();
                player.field_70170_p.func_72838_d((Entity)fireball);
            }
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    public RayTraceResult getEruptionBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 12.0;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    public void onUsingTick(ItemStack ist, EntityLivingBase entity, int count) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        RayTraceResult rayTraceResult = this.getEruptionBlockTarget(player.field_70170_p, player);
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.getMode(ist).equals("eruption")) {
            --count;
            count = this.func_77626_a(ist) - count;
            this.doEruptionAuxEffects(player, rayTraceResult.func_178782_a().func_177958_n(), rayTraceResult.func_178782_a().func_177956_o(), rayTraceResult.func_178782_a().func_177952_p(), 5.0);
            if (count % 10 == 0 && this.removeItemFromInternalStorage(ist, Items.field_151065_br, this.getBlazePowderCost(), player.field_70170_p.field_72995_K, player)) {
                this.doEruptionEffect(player, rayTraceResult.func_178782_a().func_177958_n(), rayTraceResult.func_178782_a().func_177956_o(), rayTraceResult.func_178782_a().func_177952_p(), 5.0);
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing sideHit, float hitX, float hitY, float hitZ) {
        if (this.getMode(stack).equals("flint_and_steel")) {
            BlockPos placeFireAt = pos.func_177972_a(sideHit);
            if (!player.func_175151_a(placeFireAt, sideHit, stack)) {
                return EnumActionResult.PASS;
            }
            if (world.func_175623_d(placeFireAt)) {
                world.func_184134_a((double)placeFireAt.func_177958_n() + 0.5, (double)placeFireAt.func_177956_o() + 0.5, (double)placeFireAt.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f, false);
                world.func_175656_a(placeFireAt, Blocks.field_150480_ab.func_176223_P());
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void doEruptionAuxEffects(EntityPlayer player, int x, int y, int z, double areaCoefficient) {
        double randZ;
        double randX;
        int particleCount;
        double soundX = x;
        double soundY = y;
        double soundZ = z;
        player.field_70170_p.func_184134_a(soundX + 0.5, soundY + 0.5, soundZ + 0.5, SoundEvents.field_187557_bK, SoundCategory.NEUTRAL, 0.2f, 0.03f + 0.07f * field_77697_d.nextFloat(), false);
        for (particleCount = 0; particleCount < 2; ++particleCount) {
            randX = (double)x + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient;
            randZ = (double)z + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient;
            if (Math.abs(randX - ((double)x + 0.5)) >= 4.0 && Math.abs(randZ - ((double)z + 0.5)) >= 4.0) continue;
            player.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, randX, (double)y + 1.0, randZ, 0.0, 0.0, 0.0, new int[0]);
        }
        for (particleCount = 0; particleCount < 4; ++particleCount) {
            randX = (double)x + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient / 2.0;
            randZ = (double)z + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient / 2.0;
            if (Math.abs(randX - ((double)x + 0.5)) >= 4.0 && Math.abs(randZ - ((double)z + 0.5)) >= 4.0) continue;
            player.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, randX, (double)y + 1.0, randZ, 0.0, 0.0, 0.0, new int[0]);
        }
        for (particleCount = 0; particleCount < 6; ++particleCount) {
            randX = (double)x + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient;
            randZ = (double)z + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient;
            if (Math.abs(randX - ((double)x + 0.5)) >= 4.0 && Math.abs(randZ - ((double)z + 0.5)) >= 4.0) continue;
            player.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, randX, (double)y + 1.0, randZ, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, new int[0]);
        }
        for (particleCount = 0; particleCount < 8; ++particleCount) {
            randX = (double)x + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient / 2.0;
            randZ = (double)z + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * areaCoefficient / 2.0;
            if (Math.abs(randX - ((double)x + 0.5)) >= 4.0 && Math.abs(randZ - ((double)z + 0.5)) >= 4.0) continue;
            player.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, randX, (double)y + 1.0, randZ, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, new int[0]);
        }
    }

    public void doEruptionEffect(EntityPlayer player, int x, int y, int z, double areaCoefficient) {
        double lowerX = (double)x - areaCoefficient + 0.5;
        double lowerZ = (double)z - areaCoefficient + 0.5;
        double upperX = (double)x + areaCoefficient + 0.5;
        double upperY = (double)y + areaCoefficient;
        double upperZ = (double)z + areaCoefficient + 0.5;
        List eList = player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(lowerX, (double)y, lowerZ, upperX, upperY, upperZ));
        for (Entity e : eList) {
            if (!(e instanceof EntityLivingBase) || e.func_70028_i((Entity)player)) continue;
            e.func_70015_d(40);
            if (e.func_70045_F()) continue;
            e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 4.0f);
        }
    }

    private void scanForFireChargeAndBlazePowder(ItemStack ist, EntityPlayer player) {
        ArrayList<Item> absorbItems = new ArrayList<Item>();
        absorbItems.add(Items.field_151059_bz);
        absorbItems.add(Items.field_151065_br);
        for (Item absorbItem : absorbItems) {
            if (this.isInternalStorageFullOfItem(ist, absorbItem) || !InventoryHelper.consumeItem(absorbItem, player)) continue;
            this.addItemToInternalStorage(ist, absorbItem, false);
        }
    }

    private void addItemToInternalStorage(ItemStack ist, Item item, boolean isAbsorb) {
        int quantityIncrease = item == Items.field_151059_bz ? (isAbsorb ? this.getGhastAbsorbWorth() : this.getFireChargeWorth()) : (isAbsorb ? this.getBlazeAbsorbWorth() : this.getBlazePowderWorth());
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound.func_74781_a("Items") == null) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        boolean added = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            tagItemData.func_74768_a("Quantity", quantity + quantityIncrease);
            added = true;
        }
        if (!added) {
            NBTTagCompound newTagData = new NBTTagCompound();
            newTagData.func_74778_a("Name", RegistryHelper.getItemRegistryName(item));
            newTagData.func_74768_a("Quantity", quantityIncrease);
            tagList.func_74742_a((NBTBase)newTagData);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        NBTHelper.setTag(ist, tagCompound);
    }

    public boolean removeItemFromInternalStorage(ItemStack ist, Item item, int cost, boolean simulate, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.hasItemInInternalStorage(ist, item, cost)) {
            NBTTagCompound tagCompound = NBTHelper.getTag(ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            NBTTagList replacementTagList = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (itemName.equals(RegistryHelper.getItemRegistryName(item))) {
                    int quantity = tagItemData.func_74762_e("Quantity");
                    if (!simulate) {
                        tagItemData.func_74768_a("Quantity", quantity - cost);
                    }
                }
                replacementTagList.func_74742_a((NBTBase)tagItemData);
            }
            tagCompound.func_74782_a("Items", (NBTBase)replacementTagList);
            NBTHelper.setTag(ist, tagCompound);
            return true;
        }
        return false;
    }

    private boolean hasItemInInternalStorage(ItemStack ist, Item item, int cost) {
        NBTTagCompound tagCompound = NBTHelper.getTag(ist);
        if (tagCompound.func_82582_d()) {
            tagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            return false;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e("Quantity");
            return quantity >= cost;
        }
        return false;
    }

    private boolean isInternalStorageFullOfItem(ItemStack ist, Item item) {
        int quantityLimit;
        int n = quantityLimit = item == Items.field_151059_bz ? this.getFireChargeLimit() : this.getBlazePowderLimit();
        if (this.hasItemInInternalStorage(ist, item, 1)) {
            NBTTagCompound tagCompound = NBTHelper.getTag(ist);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
                int quantity = tagItemData.func_74762_e("Quantity");
                return quantity >= quantityLimit;
            }
        }
        return false;
    }

    private int getFireChargeWorth() {
        return Settings.PyromancerStaff.fireChargeWorth;
    }

    private int getFireChargeCost() {
        return Settings.PyromancerStaff.fireChargeCost;
    }

    private int getFireChargeLimit() {
        return Settings.PyromancerStaff.fireChargeLimit;
    }

    private int getBlazePowderWorth() {
        return Settings.PyromancerStaff.blazePowderWorth;
    }

    private int getBlazePowderCost() {
        return Settings.PyromancerStaff.blazePowderCost;
    }

    private int getBlazePowderLimit() {
        return Settings.PyromancerStaff.blazePowderLimit;
    }

    private int getBlazeAbsorbWorth() {
        return Settings.PyromancerStaff.blazeAbsorbWorth;
    }

    private int getGhastAbsorbWorth() {
        return Settings.PyromancerStaff.ghastAbsorbWorth;
    }

    private void doExtinguishEffect(EntityPlayer player) {
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)Math.floor(player.field_70163_u);
        int z = (int)Math.floor(player.field_70161_v);
        for (int xOff = -3; xOff <= 3; ++xOff) {
            for (int yOff = -3; yOff <= 3; ++yOff) {
                for (int zOff = -3; zOff <= 3; ++zOff) {
                    if (!RegistryHelper.getBlockRegistryName(player.field_70170_p.func_180495_p(new BlockPos(x + xOff, y + yOff, z + zOff)).func_177230_c()).equals(RegistryHelper.getBlockRegistryName((Block)Blocks.field_150480_ab))) continue;
                    player.field_70170_p.func_175656_a(new BlockPos(x + xOff, y + yOff, z + zOff), Blocks.field_150350_a.func_176223_P());
                    player.field_70170_p.func_184134_a((double)(x + xOff) + 0.5, (double)(y + yOff) + 0.5, (double)(z + zOff) + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.8f, false);
                }
            }
        }
    }

    private void doFireballAbsorbEffect(ItemStack ist, EntityPlayer player) {
        List ghastFireballs = player.field_70170_p.func_72872_a(EntityLargeFireball.class, new AxisAlignedBB(player.field_70165_t - 5.0, player.field_70163_u - 5.0, player.field_70161_v - 5.0, player.field_70165_t + 5.0, player.field_70163_u + 5.0, player.field_70161_v + 5.0));
        for (EntityLargeFireball fireball : ghastFireballs) {
            if (fireball.field_70235_a == player || !(player.func_70032_d((Entity)fireball) < 4.0f)) continue;
            if (!this.isInternalStorageFullOfItem(ist, Items.field_151059_bz) && InventoryHelper.consumeItem(Items.field_151059_bz, player)) {
                this.addItemToInternalStorage(ist, Items.field_151059_bz, true);
                player.field_70170_p.func_184134_a(fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.8f, false);
            }
            fireball.func_70106_y();
        }
        List blazeFireballs = player.field_70170_p.func_72872_a(EntitySmallFireball.class, new AxisAlignedBB(player.field_70165_t - 3.0, player.field_70163_u - 3.0, player.field_70161_v - 3.0, player.field_70165_t + 3.0, player.field_70163_u + 3.0, player.field_70161_v + 3.0));
        for (EntitySmallFireball fireball : blazeFireballs) {
            if (fireball.field_70235_a == player) continue;
            for (int particles = 0; particles < 4; ++particles) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, 0.0, 1.0, 1.0, new int[0]);
            }
            player.field_70170_p.func_184134_a(fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.8f, false);
            if (!this.isInternalStorageFullOfItem(ist, Items.field_151065_br) && InventoryHelper.consumeItem(Items.field_151065_br, player)) {
                this.addItemToInternalStorage(ist, Items.field_151065_br, true);
            }
            fireball.func_70106_y();
        }
    }
}

