/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemHandlerProvider;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketItemHandlerSync;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemRendingGale
extends ItemToggleable {
    public ItemRendingGale() {
        super("rending_gale");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(this.getFeatherCount(ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.WHITE + Items.field_151008_G.func_77653_i(new ItemStack(Items.field_151008_G)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    private static int getChargeLimit() {
        return Settings.RendingGale.chargeLimit;
    }

    public static int getChargeCost() {
        return Settings.RendingGale.castChargeCost;
    }

    private static int getFeathersWorth() {
        return Settings.RendingGale.chargeFeatherWorth;
    }

    public static int getBoltChargeCost() {
        return Settings.RendingGale.boltChargeCost;
    }

    private static int getBoltTargetRange() {
        return Settings.RendingGale.blockTargetRange;
    }

    private static int getRadialPushRadius() {
        return Settings.RendingGale.pushPullRadius;
    }

    private static boolean canPushProjectiles() {
        return Settings.RendingGale.canPushProjectiles;
    }

    public void attemptFlight(EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        Vec3d lookVec = player.func_70676_i(0.66f);
        double x = lookVec.field_72450_a;
        double y = lookVec.field_72448_b;
        double z = lookVec.field_72449_c;
        if (this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, y, z))) {
            if (Math.abs(x) > Math.abs(y) && Math.abs(x) > Math.abs(z)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                    if (Math.abs(z) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                            z = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                        y = 0.0;
                    }
                } else {
                    x = 0.0;
                    if (Math.abs(z) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                            z = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                        y = 0.0;
                    }
                }
            } else if (Math.abs(z) > Math.abs(x) && Math.abs(z) > Math.abs(y)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                    if (Math.abs(x) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                        y = 0.0;
                    }
                } else {
                    z = 0.0;
                    if (Math.abs(x) > Math.abs(y)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                            y = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                        y = 0.0;
                    }
                }
            } else if (Math.abs(y) > Math.abs(x) && Math.abs(y) > Math.abs(z)) {
                if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, y, 0.0))) {
                    if (Math.abs(x) > Math.abs(z)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                            z = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                        z = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                        x = 0.0;
                    }
                } else {
                    y = 0.0;
                    if (Math.abs(x) > Math.abs(z)) {
                        if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                            z = 0.0;
                        } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                            x = 0.0;
                        }
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(0.0, 0.0, z))) {
                        x = 0.0;
                    } else if (!this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, 0.0, 0.0))) {
                        z = 0.0;
                    }
                }
            }
            if (this.isAABBInAnythingButAir(player.field_70170_p, player.func_174813_aQ().func_72317_d(x, y, z))) {
                return;
            }
        }
        player.field_70159_w = x;
        player.field_70181_x = y;
        player.field_70179_y = z;
        player.func_70107_b(player.field_70165_t + x, player.field_70163_u + y, player.field_70161_v + z);
        player.field_70143_R = 0.0f;
    }

    public boolean isAABBInAnythingButAir(World worldObj, AxisAlignedBB aabb) {
        int minX = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int xOff = minX; xOff < maxX; ++xOff) {
            for (int yOff = minY; yOff < maxY; ++yOff) {
                for (int zOff = minZ; zOff < maxZ; ++zOff) {
                    IBlockState blockState = worldObj.func_180495_p(new BlockPos(xOff, yOff, zOff));
                    Block block = blockState.func_177230_c();
                    if (block.func_149688_o(blockState) == Material.field_151579_a || block.func_149688_o(blockState) == Material.field_151586_h || block.func_149688_o(blockState) == Material.field_151587_i || block.func_149688_o(blockState) == Material.field_151581_o || block.func_149688_o(blockState) == Material.field_151582_l || block.func_149688_o(blockState) == Material.field_151585_k || block.func_149688_o(blockState) == Material.field_151594_q || block == Blocks.field_150431_aC) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int slotNumber, boolean isSelected) {
        if (world.field_72995_K || !(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        if (this.isEnabled(ist) && this.getFeatherCount(ist) + ItemRendingGale.getFeathersWorth() <= ItemRendingGale.getChargeLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151008_G), player)) {
            this.setFeatherCount(ist, player, slotNumber, this.getFeatherCount(ist) + ItemRendingGale.getFeathersWorth());
        }
        if (player.func_184614_ca() == ist) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(EnumHand.MAIN_HAND, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
        } else if (player.func_184592_cb() == ist) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(EnumHand.OFF_HAND, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
        } else if (player.field_71071_by.func_70301_a(slotNumber) != null && player.field_71071_by.func_70301_a(slotNumber).func_77973_b() == ModItems.rendingGale) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(ist)), (EntityPlayerMP)player);
        }
    }

    private NBTTagCompound getItemHandlerNBT(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.serializeNBT();
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString("mode", ist).equals("")) {
            this.setMode(ist, "flight");
        }
        return NBTHelper.getString("mode", ist);
    }

    public void setMode(ItemStack ist, String s) {
        NBTHelper.setString("mode", ist, s);
    }

    public void cycleMode(ItemStack ist, boolean isRaining) {
        if (this.isFlightMode(ist)) {
            this.setMode(ist, "push");
        } else if (this.isPushMode(ist)) {
            this.setMode(ist, "pull");
        } else if (this.isPullMode(ist) && isRaining) {
            this.setMode(ist, "bolt");
        } else {
            this.setMode(ist, "flight");
        }
    }

    private boolean isPullMode(ItemStack ist) {
        return this.getMode(ist).equals("pull");
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist, player.field_70170_p.func_72896_J());
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FilteredItemHandlerProvider(new int[]{Settings.RendingGale.chargeLimit}, new Item[]{Items.field_151008_G}, new int[]{Settings.RendingGale.chargeFeatherWorth});
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 6000;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            super.func_77659_a(ist, world, player, hand);
        } else {
            player.func_184598_c(hand);
            player.field_71075_bZ.field_75101_c = true;
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    public void onUsingTick(ItemStack ist, EntityLivingBase entity, int count) {
        RayTraceResult mop;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int totalCost = -1;
        int ticksInUse = this.func_77626_a(ist) - count;
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isFlightMode(ist)) {
                totalCost = ticksInUse * ItemRendingGale.getChargeCost();
            } else if (this.isBoltMode(ist)) {
                totalCost = ticksInUse / 8 * ItemRendingGale.getBoltChargeCost();
            }
        }
        if (this.getFeatherCount(ist) <= totalCost) {
            player.func_184597_cx();
            return;
        }
        if (this.isFlightMode(ist)) {
            this.attemptFlight((EntityLivingBase)player);
            this.spawnFlightParticles(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.func_70040_Z());
        } else if (this.isPushMode(ist)) {
            this.doRadialPush(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player, false);
        } else if (this.isPullMode(ist)) {
            this.doRadialPush(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player, true);
        } else if (this.isBoltMode(ist) && (mop = this.getCycloneBlockTarget(player.field_70170_p, player)) != null && ticksInUse % 8 == 0) {
            int attemptedY = mop.func_178782_a().func_177956_o();
            if (!player.field_70170_p.func_175727_C(mop.func_178782_a())) {
                ++attemptedY;
            }
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_175727_C(new BlockPos(mop.func_178782_a().func_177958_n(), attemptedY, mop.func_178782_a().func_177952_p()))) {
                player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o(), (double)mop.func_178782_a().func_177952_p(), false));
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        }
        if (worldIn.field_72995_K) {
            return;
        }
        int ticksInUse = this.func_77626_a(stack) - timeLeft;
        if (this.isFlightMode(stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.setFeatherCount(stack, player, player.func_184600_cs(), this.getFeatherCount(stack) - ItemRendingGale.getChargeCost() * ticksInUse);
            }
        } else if (this.isBoltMode(stack) && !player.field_71075_bZ.field_75098_d) {
            this.setFeatherCount(stack, player, player.func_184600_cs(), this.getFeatherCount(stack) - ItemRendingGale.getBoltChargeCost() * (ticksInUse / 8));
        }
    }

    private boolean isPushMode(ItemStack ist) {
        return this.getMode(ist).equals("push");
    }

    public boolean isFlightMode(ItemStack ist) {
        return this.getMode(ist).equals("flight");
    }

    public boolean isBoltMode(ItemStack stack) {
        return this.getMode(stack).equals("bolt");
    }

    public RayTraceResult getCycloneBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = ItemRendingGale.getBoltTargetRange();
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    public int getFeatherCount(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }

    private void setFeatherCount(ItemStack ist, EntityPlayer player, int slotNumber, int featherCount) {
        this.setFeatherCount(ist, featherCount);
    }

    private void setFeatherCount(ItemStack ist, EntityPlayer player, EnumHand hand, int featherCount) {
        this.setFeatherCount(ist, featherCount);
    }

    public void setFeatherCount(ItemStack ist, int featherCount) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, featherCount);
    }

    public void doRadialPush(World worldObj, double posX, double posY, double posZ, EntityPlayer player, boolean pull) {
        this.spawnRadialHurricaneParticles(worldObj, posX, posY, posZ, player, pull);
        if (worldObj.field_72995_K) {
            return;
        }
        double lowerX = posX - (double)ItemRendingGale.getRadialPushRadius();
        double lowerY = posY - (double)ItemRendingGale.getRadialPushRadius() / 5.0;
        double lowerZ = posZ - (double)ItemRendingGale.getRadialPushRadius();
        double upperX = posX + (double)ItemRendingGale.getRadialPushRadius();
        double upperY = posY + (double)ItemRendingGale.getRadialPushRadius() / 2.0;
        double upperZ = posZ + (double)ItemRendingGale.getRadialPushRadius();
        List<String> entitiesThatCanBePushed = Settings.RendingGale.entitiesThatCanBePushed;
        List<String> projectilesThatCanBePushed = Settings.RendingGale.projectilesThatCanBePushed;
        List eList = worldObj.func_72872_a(Entity.class, new AxisAlignedBB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ));
        for (Entity e : eList) {
            double distance;
            Class<?> entityClass = e.getClass();
            String entityName = (String)EntityList.field_75626_c.get(entityClass);
            if (!entitiesThatCanBePushed.contains(entityName) && (pull || !ItemRendingGale.canPushProjectiles() || !projectilesThatCanBePushed.contains(entityName)) || (distance = (double)this.getDistanceToEntity(posX, posY, posZ, e)) >= (double)ItemRendingGale.getRadialPushRadius() || e.equals((Object)player)) continue;
            Vec3d pushVector = pull ? new Vec3d(posX - e.field_70165_t, posY - e.field_70163_u, posZ - e.field_70161_v) : new Vec3d(e.field_70165_t - posX, e.field_70163_u - posY, e.field_70161_v - posZ);
            pushVector = pushVector.func_72432_b();
            e.func_70091_d(0.0, 0.2, 0.0);
            e.func_70091_d(pushVector.field_72450_a, Math.min(pushVector.field_72448_b, 0.1) * 1.5, pushVector.field_72449_c);
        }
    }

    private float getDistanceToEntity(double posX, double posY, double posZ, Entity entityIn) {
        float f = (float)(posX - entityIn.field_70165_t);
        float f1 = (float)(posY - entityIn.field_70163_u);
        float f2 = (float)(posZ - entityIn.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void spawnFlightParticles(World world, double x, double y, double z, Vec3d lookVector) {
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randY = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randZ = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            world.func_175688_a(EnumParticleTypes.BLOCK_DUST, x + (double)randX, y + (double)randY, z + (double)randZ, lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150431_aC.func_176203_a(0))});
        }
    }

    public void spawnRadialHurricaneParticles(World worldObj, double posX, double posY, double posZ, EntityPlayer player, boolean pull) {
        for (int i = 0; i < 3; ++i) {
            float randX = worldObj.field_73012_v.nextFloat() - 0.5f;
            float randZ = worldObj.field_73012_v.nextFloat() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            double posYAdjusted = player == null ? posY : posY + (double)player.func_70047_e() - (double)(player.field_70131_O / 2.0f);
            worldObj.func_175688_a(EnumParticleTypes.BLOCK_DUST, posX + (double)randX, posYAdjusted, posZ + (double)randZ, (double)motX, 0.0, (double)motZ, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150431_aC.func_176203_a(0))});
        }
    }
}

