/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.blocks.tile.TileEntityCauldron;
import xreliquary.entities.potion.EntityThrownXRPotion;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.XRPotionHelper;

public class ItemXRPotion
extends ItemBase {
    public ItemXRPotion() {
        super("potion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public boolean hasContainerItem(ItemStack ist) {
        PotionEssence essence = new PotionEssence(ist.func_77978_p());
        return essence.getEffects().size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean flag) {
        PotionEssence essence = new PotionEssence(ist.func_77978_p());
        XRPotionHelper.addPotionInfo(essence, list);
    }

    public ItemStack func_77654_b(ItemStack ist, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return ist;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.field_71075_bZ.field_75098_d) {
            --ist.field_77994_a;
        }
        if (!world.field_72995_K) {
            for (PotionEffect effect : new PotionEssence(ist.func_77978_p()).getEffects()) {
                if (effect == null) continue;
                player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), false, false));
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (ist.field_77994_a <= 0) {
                return new ItemStack((Item)this, 1, 0);
            }
            player.field_71071_by.func_70441_a(new ItemStack((Item)this, 1, 0));
        }
        return ist;
    }

    public boolean getSplash(ItemStack ist) {
        return NBTHelper.getBoolean("splash", ist);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack((Item)ModItems.potion));
        ArrayList<ItemStack> splashPotions = new ArrayList<ItemStack>();
        for (PotionEssence essence : Settings.Potions.uniquePotions) {
            ItemStack potion = new ItemStack((Item)ModItems.potion, 1);
            potion.func_77982_d(essence.writeToNBT());
            NBTHelper.setBoolean("hasPotion", potion, true);
            ItemStack splashPotion = potion.func_77946_l();
            NBTHelper.setBoolean("splash", splashPotion, true);
            subItems.add(potion);
            splashPotions.add(splashPotion);
        }
        subItems.addAll(splashPotions);
    }

    public EnumAction func_77661_b(ItemStack ist) {
        if (!this.getSplash(ist) && new PotionEssence(ist.func_77978_p()).getEffects().size() > 0) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        PotionEssence essence = new PotionEssence(ist.func_77978_p());
        if (!this.getSplash(ist)) {
            if (essence.getEffects().size() > 0) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
            }
            RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
            if (rayTraceResult == null) {
                return new ActionResult(EnumActionResult.PASS, (Object)ist);
            }
            if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(rayTraceResult.func_178782_a()).func_177230_c() instanceof BlockApothecaryCauldron) {
                TileEntityCauldron cauldronTile = (TileEntityCauldron)world.func_175625_s(rayTraceResult.func_178782_a());
                NBTTagCompound potionTag = cauldronTile.removeContainedPotion(world);
                ItemStack newPotion = new ItemStack((Item)this, 1, 0);
                newPotion.func_77982_d(potionTag);
                if (--ist.field_77994_a <= 0) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)newPotion);
                }
                if (!player.field_71071_by.func_70441_a(newPotion)) {
                    player.func_70099_a(newPotion, 0.1f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
                }
            }
        } else {
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.PASS, (Object)ist);
            }
            EntityThrownXRPotion e = new EntityThrownXRPotion(world, (EntityLivingBase)player, ist);
            e.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                --ist.field_77994_a;
            }
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            world.func_72838_d((Entity)e);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)ist);
    }
}

