/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteredItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    public static final int SLOTS_PER_TYPE = 2;
    protected ItemStack[] filterStacks;
    private int[] totalAmounts;
    private int[] totalLimits;
    private int[] unitWorth;
    private boolean dynamicSize = false;
    protected ItemStack[] stacks;

    protected FilteredItemStackHandler(int initialSlots) {
        this.stacks = new ItemStack[initialSlots * 2];
        this.totalAmounts = new int[initialSlots];
        this.filterStacks = new ItemStack[initialSlots];
    }

    public FilteredItemStackHandler(int[] totalLimits, Item[] items, int[] unitWorth) {
        this(totalLimits, FilteredItemStackHandler.getItemStacks(items), unitWorth);
    }

    public FilteredItemStackHandler(int[] totalLimits, ItemStack[] filterStacks, int[] unitWorth) {
        this(filterStacks.length);
        this.totalLimits = totalLimits;
        this.filterStacks = filterStacks;
        this.unitWorth = unitWorth;
    }

    private static ItemStack[] getItemStacks(Item[] items) {
        ItemStack[] itemStacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            itemStacks[i] = new ItemStack(items[i]);
        }
        return itemStacks;
    }

    public int getParentSlot(int slot) {
        return slot / 2;
    }

    private boolean isInputSlot(int slot) {
        return (slot + 1) % 2 != 0;
    }

    public int getTotalAmount(int parentSlot) {
        return parentSlot < this.totalAmounts.length ? this.totalAmounts[parentSlot] : 0;
    }

    public void setTotalAmount(int parentSlot, int amount) {
        if (this.dynamicSize && amount == 0 && this.getParentSlotRemovable(parentSlot)) {
            this.removeValidItemStackFromSlot(parentSlot);
        } else {
            this.totalAmounts[parentSlot] = amount;
            this.updateInputOutputSlots(parentSlot);
        }
    }

    private void addValidItemStack(ItemStack stack) {
        this.expandStacks();
        ItemStack[] expandedStacks = new ItemStack[this.filterStacks.length + 1];
        System.arraycopy(this.filterStacks, 0, expandedStacks, 0, this.filterStacks.length);
        expandedStacks[this.filterStacks.length] = stack;
        this.filterStacks = expandedStacks;
        this.totalAmounts = this.expandIntArray(this.totalAmounts, 0);
    }

    private int[] expandIntArray(int[] values, int newSize, int def) {
        int[] expandedArray = new int[newSize];
        System.arraycopy(values, 0, expandedArray, 0, values.length);
        return expandedArray;
    }

    private int[] expandIntArray(int[] values, int def) {
        int[] expandedArray = this.expandIntArray(values, values.length + 1, def);
        expandedArray[values.length] = def;
        return expandedArray;
    }

    private int[] removeFromIntArray(int[] values, int index) {
        int[] shrunkArray = new int[values.length - 1];
        if (index > 0) {
            System.arraycopy(values, 0, shrunkArray, 0, index);
        }
        if (index < values.length - 1) {
            System.arraycopy(values, index + 1, shrunkArray, index, values.length - (index + 1));
        }
        return shrunkArray;
    }

    private void expandStacks() {
        if (this.dynamicSize) {
            ItemStack[] expandedStacks = new ItemStack[this.stacks.length + 2];
            System.arraycopy(this.stacks, 0, expandedStacks, 0, this.stacks.length);
            this.stacks = expandedStacks;
        }
    }

    private void removeStack(int parentSlot) {
        if (this.dynamicSize) {
            ItemStack[] shrunkStacks = new ItemStack[this.stacks.length - 2];
            if (parentSlot > 0) {
                System.arraycopy(this.stacks, 0, shrunkStacks, 0, parentSlot * 2);
            }
            if (parentSlot * 2 < this.stacks.length - 2) {
                System.arraycopy(this.stacks, (parentSlot + 1) * 2, shrunkStacks, parentSlot * 2, this.stacks.length - (parentSlot + 1) * 2);
            }
            this.stacks = shrunkStacks;
        }
    }

    private void removeValidItemStackFromSlot(int parentSlot) {
        ItemStack[] shrunkStacks = new ItemStack[this.filterStacks.length - 1];
        if (parentSlot > 0) {
            System.arraycopy(this.filterStacks, 0, shrunkStacks, 0, parentSlot);
        }
        if (parentSlot < this.filterStacks.length - 1) {
            System.arraycopy(this.filterStacks, parentSlot + 1, shrunkStacks, parentSlot, this.filterStacks.length - (parentSlot + 1));
        }
        this.filterStacks = shrunkStacks;
        this.totalAmounts = this.removeFromIntArray(this.totalAmounts, parentSlot);
        this.removeStack(parentSlot);
    }

    public void markDirty() {
        for (int i = 0; i < this.totalAmounts.length; ++i) {
            int totalAmount = this.worthToUnits(this.totalAmounts[i], i);
            int inputSlot = this.getInputSlot(i);
            int outputSlot = this.getOutputSlot(i);
            int inputCount = this.stacks[inputSlot] == null ? 0 : this.stacks[inputSlot].field_77994_a;
            int remaining = this.worthToUnits(this.getParentSlotLimit(i) - this.totalAmounts[i], i);
            int outputCount = this.stacks[outputSlot] == null ? 0 : this.stacks[outputSlot].field_77994_a;
            ItemStack parentSlotStack = this.getParentSlotStack(i);
            if (inputCount != Math.max(parentSlotStack.func_77976_d() - remaining, 0)) {
                int n = i;
                this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(inputCount - Math.max(parentSlotStack.func_77976_d() - remaining, 0), i);
            }
            if (outputCount != Math.min(totalAmount, parentSlotStack.func_77976_d())) {
                int n = i;
                this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(outputCount - Math.min(totalAmount, parentSlotStack.func_77976_d()), i);
            }
            this.updateInputOutputSlots(i);
            if (!this.getParentSlotRemovable(i) || this.totalAmounts[i] != 0) continue;
            this.removeValidItemStackFromSlot(i);
        }
    }

    protected int getParentSlotLimit(int parentSlot) {
        return this.totalLimits[parentSlot];
    }

    private int worthToUnits(int worth, int parentSlot) {
        return worth / this.getParentSlotUnitWorth(parentSlot);
    }

    protected int getParentSlotUnitWorth(int parentSlot) {
        return this.unitWorth[parentSlot];
    }

    protected boolean getParentSlotRemovable(int parentSlot) {
        return false;
    }

    private int unitsToWorth(int units, int parentSlot) {
        return units * this.getParentSlotUnitWorth(parentSlot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)this.stacks[slot], (ItemStack)stack) || stack != null && (!this.isItemStackValidForParentSlot(stack, this.getParentSlot(slot)) || this.alreadyExistsInAnotherSlot(stack, this.getParentSlot(slot)))) {
            return;
        }
        int parentSlot = this.getParentSlot(slot);
        if (stack != null && parentSlot == this.filterStacks.length) {
            this.addValidItemStack(stack);
        }
        int n = parentSlot;
        this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth((stack == null ? 0 : stack.field_77994_a) - (this.stacks[slot] == null ? 0 : this.stacks[slot].field_77994_a), parentSlot);
        if (this.totalAmounts[parentSlot] == 0) {
            this.removeValidItemStackFromSlot(parentSlot);
        } else {
            if (!this.isInputSlot(slot)) {
                this.stacks[slot] = stack;
            }
            this.updateInputOutputSlots(parentSlot);
        }
    }

    private boolean alreadyExistsInAnotherSlot(ItemStack stack, int parentSlot) {
        for (int i = 0; i < this.filterStacks.length; ++i) {
            if (i == parentSlot || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stacks[this.getOutputSlot(i)], (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.stacks.length;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks[slot];
    }

    private void updateInputOutputSlots(int parentSlot) {
        int inputAmount;
        ItemStack parentSlotStack = this.getParentSlotStack(parentSlot);
        if (parentSlotStack == null) {
            return;
        }
        int outputSlot = this.getOutputSlot(parentSlot);
        int inputSlot = this.getInputSlot(parentSlot);
        if (this.stacks[outputSlot] == null) {
            this.stacks[outputSlot] = parentSlotStack.func_77946_l();
        }
        ItemStack outputStack = this.stacks[outputSlot];
        if (outputStack.field_77994_a < parentSlotStack.func_77976_d() && outputStack.field_77994_a < this.worthToUnits(this.totalAmounts[parentSlot], parentSlot) || outputStack.field_77994_a > this.worthToUnits(this.totalAmounts[parentSlot], parentSlot)) {
            outputStack.field_77994_a = Math.min(parentSlotStack.func_77976_d(), this.worthToUnits(this.totalAmounts[parentSlot], parentSlot));
        }
        int remainingCapacity = this.worthToUnits(this.getParentSlotLimit(parentSlot) - this.totalAmounts[parentSlot], parentSlot);
        int n = inputAmount = this.stacks[inputSlot] == null ? 0 : this.stacks[inputSlot].field_77994_a;
        if (inputAmount != Math.max(parentSlotStack.func_77976_d() - remainingCapacity, 0)) {
            this.stacks[inputSlot] = parentSlotStack.func_77946_l();
            this.stacks[inputSlot].field_77994_a = Math.max(parentSlotStack.func_77976_d() - remainingCapacity, 0);
        }
        if (this.stacks[inputSlot] != null && this.stacks[inputSlot].field_77994_a == 0) {
            this.stacks[inputSlot] = null;
        }
    }

    private ItemStack getParentSlotStack(int parentSlot) {
        return this.filterStacks[parentSlot];
    }

    public void setParentSlotStack(int parentSlot, ItemStack filterStack) {
        if (this.filterStacks[parentSlot] == null) {
            this.filterStacks[parentSlot] = filterStack.func_77946_l();
        }
    }

    protected boolean isItemStackValidForParentSlot(ItemStack stack, int parentSlot) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.filterStacks[parentSlot]);
    }

    private int getInputSlot(int parentSlot) {
        return parentSlot * 2;
    }

    private int getOutputSlot(int parentSlot) {
        return parentSlot * 2 + 1;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        int remainingTotal;
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        int parentSlot = this.getParentSlot(slot);
        if (!this.isItemStackValidForParentSlot(stack, parentSlot) || this.alreadyExistsInAnotherSlot(stack, parentSlot)) {
            return stack;
        }
        ItemStack existing = this.stacks[slot];
        int limit = this.getStackLimit(slot, parentSlot >= this.filterStacks.length ? stack : this.filterStacks[parentSlot]);
        if (existing != null) {
            limit -= existing.field_77994_a;
        }
        if ((limit = Math.min(limit, remainingTotal = this.worthToUnits(this.getParentSlotLimit(parentSlot) - (parentSlot >= this.totalAmounts.length ? 0 : this.totalAmounts[parentSlot]), parentSlot))) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (parentSlot == this.filterStacks.length) {
                this.addValidItemStack(stack);
            }
            int n = parentSlot;
            this.totalAmounts[n] = this.totalAmounts[n] + this.unitsToWorth(reachedLimit ? limit : stack.field_77994_a, parentSlot);
            if (!this.isInputSlot(slot)) {
                if (existing == null) {
                    this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
                } else {
                    existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
                }
            }
            this.updateInputOutputSlots(parentSlot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
    }

    public ItemStack getStackInParentSlot(int parentSlot) {
        if (parentSlot >= this.filterStacks.length) {
            return null;
        }
        return this.filterStacks[parentSlot];
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        if (this.stacks[slot] == null) {
            return null;
        }
        ItemStack existing = this.stacks[slot];
        if (existing == null) {
            return null;
        }
        int numberRemoved = Math.min(existing.field_77994_a, amount);
        if (!simulate) {
            int n = this.getParentSlot(slot);
            this.totalAmounts[n] = this.totalAmounts[n] - numberRemoved;
            this.stacks[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.field_77994_a - numberRemoved));
            if (this.totalAmounts[this.getParentSlot(slot)] == 0 && this.dynamicSize) {
                this.removeValidItemStackFromSlot(this.getParentSlot(slot));
            } else {
                this.updateInputOutputSlots(this.getParentSlot(slot));
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)numberRemoved);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            this.stacks[i].func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.length);
        NBTTagList nbtAmountsList = new NBTTagList();
        for (int totalAmount : this.totalAmounts) {
            NBTTagInt amountTag = new NBTTagInt(totalAmount);
            nbtAmountsList.func_74742_a((NBTBase)amountTag);
        }
        nbt.func_74782_a("TotalAmounts", (NBTBase)nbtAmountsList);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int stacksSize = nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.length;
        this.setSize(stacksSize);
        NBTTagList amounts = nbt.func_150295_c("TotalAmounts", 3);
        this.setFilterStacksSize(amounts.func_74745_c());
        for (int i = 0; i < amounts.func_74745_c(); ++i) {
            this.totalAmounts[i] = ((NBTTagInt)amounts.func_179238_g(i)).func_150287_d();
        }
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.length) continue;
            this.stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTags);
            if (this.filterStacks.length <= this.getParentSlot(slot)) continue;
            ItemStack filterStack = this.stacks[slot].func_77946_l();
            filterStack.field_77994_a = 1;
            this.filterStacks[this.getParentSlot((int)slot)] = filterStack;
        }
    }

    protected void setDynamicSize(boolean dynamicSize) {
        if (this.dynamicSize != dynamicSize) {
            this.dynamicSize = dynamicSize;
            if (this.dynamicSize) {
                this.expandStacks();
            } else {
                this.removeStack(this.filterStacks.length);
            }
        }
    }

    protected ItemStack[] getFilterStacks() {
        return this.filterStacks;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.length) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.length + ")");
        }
    }

    private int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    private void setSize(int size) {
        this.stacks = new ItemStack[size];
    }

    private void setFilterStacksSize(int size) {
        if (this.filterStacks.length != size) {
            this.filterStacks = new ItemStack[size];
            this.totalAmounts = new int[size];
        }
    }
}

