/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModCapabilities;
import xreliquary.items.util.handgun.IHandgunData;

public class PacketHandgunDataSync
implements IMessage,
IMessageHandler<PacketHandgunDataSync, IMessage> {
    private int playerSlotNumber;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private short bulletCount;
    private short bulletType;
    private boolean isInCooldown;
    private long cooldownTime;
    private static final int INVALID_SLOT = -1;

    public PacketHandgunDataSync() {
    }

    public PacketHandgunDataSync(int playerSlotNumber, short bulletCount, short bulletType, boolean isInCooldown, long cooldownTime) {
        this.playerSlotNumber = playerSlotNumber;
        this.bulletCount = bulletCount;
        this.bulletType = bulletType;
        this.isInCooldown = isInCooldown;
        this.cooldownTime = cooldownTime;
    }

    public PacketHandgunDataSync(EnumHand hand, short bulletCount, short bulletType, boolean isInCooldown, long cooldownTime) {
        this.hand = hand;
        this.isInCooldown = isInCooldown;
        this.cooldownTime = cooldownTime;
        this.playerSlotNumber = -1;
        this.bulletCount = bulletCount;
        this.bulletType = bulletType;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerSlotNumber = buf.readInt();
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.bulletCount = buf.readShort();
        this.bulletType = buf.readShort();
        this.isInCooldown = buf.readBoolean();
        this.cooldownTime = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerSlotNumber);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        buf.writeShort((int)this.bulletCount);
        buf.writeShort((int)this.bulletType);
        buf.writeBoolean(this.isInCooldown);
        buf.writeLong(this.cooldownTime);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketHandgunDataSync message, MessageContext ctx) {
        IHandgunData data;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = message.playerSlotNumber > -1 ? player.field_71071_by.func_70301_a(message.playerSlotNumber) : player.func_184586_b(message.hand);
        if (stack != null && (data = (IHandgunData)stack.getCapability(ModCapabilities.HANDGUN_DATA_CAPABILITY, null)) != null) {
            data.setBulletCount(message.bulletCount);
            data.setBulletType(message.bulletType);
            data.setInCoolDown(message.isInCooldown);
            data.setCoolDownTime(message.cooldownTime);
        }
        return null;
    }
}

