/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import xreliquary.items.ItemPotionEssence;
import xreliquary.reference.Settings;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionIngredient;

public class XRPotionHelper {
    private static Potion[] nonAugmentableEffects = new Potion[]{MobEffects.field_76440_q, MobEffects.field_76431_k, MobEffects.field_76441_p, MobEffects.field_76439_r, MobEffects.field_76427_o};

    public static boolean isItemEssence(ItemStack ist) {
        return ist.func_77973_b() instanceof ItemPotionEssence;
    }

    public static boolean isItemIngredient(ItemStack ist) {
        for (PotionIngredient ingredient : Settings.Potions.potionMap) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals((Object)ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static int getPotionIdByName(String name) {
        return Potion.func_188409_a((Potion)Potion.func_180142_b((String)name));
    }

    public static PotionIngredient getIngredient(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            return new PotionEssence(ist.func_77978_p());
        }
        for (PotionIngredient ingredient : Settings.Potions.potionMap) {
            if (!ingredient.item.func_77973_b().getRegistryName().equals((Object)ist.func_77973_b().getRegistryName()) || ingredient.item.func_77960_j() != ist.func_77960_j()) continue;
            return ingredient;
        }
        return null;
    }

    public static boolean isAugmentablePotionEffect(PotionEffect effect) {
        for (int i = 0; i < nonAugmentableEffects.length; ++i) {
            if (nonAugmentableEffects[i] != effect.func_188419_a()) continue;
            return false;
        }
        return true;
    }

    public static void addPotionInfo(PotionEssence essence, List list) {
        XRPotionHelper.addPotionInfo(essence, list, true);
    }

    public static void addPotionInfo(PotionEssence essence, List list, boolean addEffectDescription) {
        if (essence.getEffects().size() > 0) {
            ArrayList list1 = Lists.newArrayList();
            for (PotionEffect potioneffect : essence.getEffects()) {
                String s1 = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f) + ")";
                }
                if (potion.func_76398_f()) {
                    list.add(TextFormatting.RED + s1);
                    continue;
                }
                list.add(TextFormatting.BLUE + s1);
            }
            if (!list1.isEmpty()) {
                list.add("");
                list.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"potion.whenDrank"));
                for (Tuple tuple : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        list.add(TextFormatting.BLUE + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(TextFormatting.RED + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)tuple.func_76341_a()))}));
                }
            }
        }
    }
}

