/*
 * Decompiled with CFR 0.152.
 */
package xreliquary;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import lib.enderwizards.sandstone.Sandstone;
import lib.enderwizards.sandstone.mod.ModIntegration;
import lib.enderwizards.sandstone.mod.SandstoneMod;
import lib.enderwizards.sandstone.mod.config.Config;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.modstats.ModstatInfo;
import org.modstats.Modstats;
import xreliquary.CreativeTabXR;
import xreliquary.common.CommonProxy;
import xreliquary.integration.NEIModIntegration;
import xreliquary.items.ItemDestructionCatalyst;
import xreliquary.util.alkahestry.AlkahestRecipe;
import xreliquary.util.alkahestry.Alkahestry;

@ModstatInfo(prefix="reliquary")
@Mod(modid="xreliquary", name="Reliquary", version="1.2.DEV", dependencies="required-after:libsandstone", guiFactory="xreliquary.client.gui.XRGuiFactory")
@SandstoneMod(basePackage="xreliquary")
public class Reliquary {
    @Mod.Instance(value="xreliquary")
    public static Reliquary INSTANCE;
    @SidedProxy(clientSide="xreliquary.client.ClientProxy", serverSide="xreliquary.common.CommonProxy")
    public static CommonProxy PROXY;
    public static Config CONFIG;
    public static CreativeTabs CREATIVE_TAB;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CONFIG = Config.toml((File)new File(event.getModConfigurationDirectory(), "xreliquary.toml"));
        PROXY.initOptions();
        Sandstone.preInit();
        PROXY.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Modstats.instance().getReporter().registerMod((Object)this);
        Sandstone.addModIntegration((ModIntegration)new NEIModIntegration());
        PROXY.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.log(Level.INFO, "Loaded successfully!");
        Sandstone.postInit();
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equals("DestructionCatalyst")) {
                LOGGER.log(Level.INFO, "[IMC] Added block " + message.getStringValue() + " from " + message.getSender() + " was added to the Destruction Catalyst's registry.");
                ItemDestructionCatalyst.ids.add(message.getStringValue());
                continue;
            }
            if (!message.key.equals("Alkahest")) continue;
            NBTTagCompound tag = message.getNBTValue();
            if (tag != null && ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")) != null && tag.func_74764_b("yield") && tag.func_74764_b("cost")) {
                if (tag.func_74764_b("dictionaryName")) {
                    Alkahestry.addKey(new AlkahestRecipe(tag.func_74779_i("dictionaryName"), tag.func_74762_e("yield"), tag.func_74762_e("cost")));
                } else {
                    Alkahestry.addKey(new AlkahestRecipe(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")), tag.func_74762_e("yield"), tag.func_74762_e("cost")));
                }
                LOGGER.log(Level.INFO, "[IMC] Added AlkahestRecipe ID: " + Item.field_150901_e.func_148750_c((Object)ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item"))) + " from " + message.getSender() + " to registry.");
                continue;
            }
            LOGGER.log(Level.WARN, "[IMC] Invalid AlkahestRecipe from " + message.getSender() + "! Please contact the mod author if you see this error occurring.");
        }
    }

    static {
        CREATIVE_TAB = new CreativeTabXR(CreativeTabs.getNextID(), "xreliquary");
        LOGGER = LogManager.getLogger((String)"xreliquary");
    }
}

