/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lib.enderwizards.sandstone.init.ContentHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import xreliquary.Reliquary;
import xreliquary.client.model.ModelWitchHat;
import xreliquary.items.ItemHandgun;

public class ClientEventHandler {
    private static int time;

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        this.handleTickIncrement(event);
        this.handleHandgunHUDCheck();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayer(RenderPlayerEvent.SetArmorModel event) {
        if (event.entityPlayer != null && event.stack != null && event.stack.func_77973_b() == ContentHandler.getItem((String)"witch_hat")) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft:textures/entity/witch.png"));
            ModelBiped model = event.renderer.field_77111_i;
            model.field_78116_c.field_78806_j = false;
            model.field_78114_d.field_78806_j = false;
            model.field_78115_e.field_78806_j = false;
            model.field_78112_f.field_78806_j = false;
            model.field_78113_g.field_78806_j = false;
            model.field_78123_h.field_78806_j = false;
            model.field_78124_i.field_78806_j = false;
            model = ModelWitchHat.self;
            event.renderer.func_77042_a((ModelBase)model);
            model.field_78095_p = event.renderer.field_77109_a.field_78095_p;
            model.field_78093_q = event.entityPlayer.func_70115_ae();
            model.field_78091_s = event.renderer.field_77109_a.field_78091_s;
            event.result = 1;
            return;
        }
        if (event.stack != null && event.stack.func_77973_b() == ContentHandler.getItem((String)"witch_hat")) {
            event.result = 0;
            return;
        }
    }

    public void handleTickIncrement(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        time = ClientEventHandler.getTime() > 4096 ? 0 : ++time;
    }

    public void handleHandgunHUDCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemHandgun)) {
            return;
        }
        ItemStack handgunStack = player.func_71045_bC();
        ItemHandgun handgunItem = (ItemHandgun)handgunStack.func_77973_b();
        ItemStack bulletStack = new ItemStack(ContentHandler.getItem((String)"bullet"), handgunItem.getBulletCount(handgunStack), handgunItem.getBulletType(handgunStack));
        ClientEventHandler.renderHandgunHUD(mc, (EntityPlayer)player, handgunStack, bulletStack);
    }

    private static void renderHandgunHUD(Minecraft minecraft, EntityPlayer player, ItemStack handgunStack, ItemStack bulletStack) {
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        switch (Reliquary.CONFIG.getInt("handgun", "hudPosition")) {
            case 0: {
                hudOverlayX = 0;
                hudOverlayY = 0;
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = 0;
                break;
            }
            case 2: {
                hudOverlayX = 0;
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, handgunStack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        if (bulletStack.field_77994_a == 0) {
            if (ClientEventHandler.getTime() % 32 > 16) {
                ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, new ItemStack(ContentHandler.getItem((String)"magazine"), 1, 0), hudOverlayX - 8, hudOverlayY + 12, overlayOpacity, overlayScale / 2.0f);
            }
        } else {
            for (int xOffset = 0; xOffset < bulletStack.field_77994_a; ++xOffset) {
                ClientEventHandler.renderItemIntoGUI(minecraft.field_71466_p, bulletStack, hudOverlayX - 8 - xOffset * 12, hudOverlayY + 12, 1.0f, overlayScale / 2.0f);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderItemIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y, float opacity, float scale) {
        GL11.glDisable((int)2896);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        for (int passes = 0; passes < itemStack.func_77973_b().getRenderPasses(itemStack.func_77960_j()); ++passes) {
            int overlayColour = itemStack.func_77973_b().func_82790_a(itemStack, passes);
            IIcon icon = itemStack.func_77973_b().getIcon(itemStack, passes);
            float red = (float)(overlayColour >> 16 & 0xFF) / 255.0f;
            float green = (float)(overlayColour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(overlayColour & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)opacity);
            ClientEventHandler.drawTexturedQuad(x, y, icon, 16.0f * scale, 16.0f * scale, -90.0);
            GL11.glEnable((int)2896);
        }
    }

    public static void drawTexturedQuad(int x, int y, IIcon icon, float width, float height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)((float)y + height), zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)((float)x + width), (double)((float)y + height), zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)((float)x + width), (double)y, zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public static int getTime() {
        return time;
    }
}

