/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.event;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Random;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import xreliquary.Reliquary;
import xreliquary.util.alkahestry.AlkahestRecipe;
import xreliquary.util.alkahestry.Alkahestry;

public class CommonEventHandler {
    @SubscribeEvent
    public void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_146103_bH().getName() == "Drullkus" && !event.player.getEntityData().func_74764_b("gift") && event.player.field_71071_by.func_70441_a(new ItemStack(ContentHandler.getItem((String)"witch_hat")))) {
            event.player.getEntityData().func_74757_a("gift", true);
        }
    }

    @SubscribeEvent
    public void onCraftingPotion(PlayerEvent.ItemCraftedEvent event) {
        for (int slot = 0; slot < event.craftMatrix.func_70302_i_(); ++slot) {
            if (event.craftMatrix.func_70301_a(slot) == null || event.craftMatrix.func_70301_a(slot).func_77973_b() != ContentHandler.getItem((String)"glowing_water") || event.player.field_71071_by.func_70441_a(new ItemStack(ContentHandler.getItem((String)"condensed_potion"), 1, 11))) continue;
            event.player.func_70099_a(new ItemStack(ContentHandler.getItem((String)"condensed_potion"), 1, 11), 0.1f);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("xreliquary")) {
            Reliquary.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Entity e = event.entity;
        this.handleSquidCheck(e, event);
        this.handleWitchCheck(e, event);
    }

    public void handleSquidCheck(Entity e, LivingDropsEvent event) {
        if (!(e instanceof EntitySquid)) {
            return;
        }
        float squidBeakProbability = 0.04f + 0.07f * (float)(event.lootingLevel + 1);
        if (e.field_70170_p.field_73012_v.nextFloat() <= squidBeakProbability && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && event.source.field_76373_n.equals("player")) {
            ItemStack dropStack = new ItemStack(ContentHandler.getItem((String)"squid_beak"), 1, 0);
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_145804_b = 10;
            event.drops.add(entityitem);
        }
    }

    public void handleWitchCheck(Entity e, LivingDropsEvent event) {
        if (!(e instanceof EntityWitch)) {
            return;
        }
        if (e.field_70170_p.field_73012_v.nextBoolean() && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer && event.source.field_76373_n.equals("player")) {
            ItemStack dropStack = new ItemStack(ContentHandler.getItem((String)"witch_hat"), 1, 0);
            EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_145804_b = 10;
            event.drops.add(entityitem);
        }
    }

    @SubscribeEvent
    public void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.entity;
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.handleDragonClawsCheck(player, event);
        this.handleFiredrinkerCheck(player, event);
        this.handleAngelicFeatherCheck(player, event);
        this.handleKrakenEyeCheck(player, event);
        this.handlePhoenixDownCheck(player, event);
        this.handleAngelheartVialCheck(player, event);
        if (event.isCanceled()) {
            event.setResult(null);
        }
    }

    public void handleDragonClawsCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"dragon_claws"))) {
            return;
        }
        if (event.source != DamageSource.field_76372_a && event.source != DamageSource.field_76370_b) {
            return;
        }
        if (player.func_71024_bL().func_75115_e() < event.ammount * 0.5f) {
            return;
        }
        player.func_71020_j(event.ammount * 0.5f);
        event.setCanceled(true);
    }

    public void handleFiredrinkerCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"claws_of_the_firedrinker"))) {
            return;
        }
        if (event.source == DamageSource.field_76372_a || event.source == DamageSource.field_76370_b) {
            FoodStats food = player.func_71024_bL();
            if (food.func_75115_e() + event.ammount * 0.5f >= (float)food.func_75116_a()) {
                food.func_75122_a(1, food.func_75115_e() + event.ammount * 0.5f - (float)food.func_75116_a());
            } else {
                food.func_75122_a(0, event.ammount * 0.5f);
            }
            player.func_71020_j(event.ammount * 0.5f);
        }
        if (event.source != DamageSource.field_76371_c) {
            return;
        }
        if (player.func_71024_bL().func_75115_e() < event.ammount * 1.5f) {
            return;
        }
        player.func_71020_j(event.ammount * 1.5f);
        event.setCanceled(true);
    }

    public void handleAngelheartVialCheck(EntityPlayer player, LivingAttackEvent event) {
        if (player.func_110143_aJ() > (float)Math.round(event.ammount)) {
            return;
        }
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"angelheart_vial"))) {
            return;
        }
        this.decreaseItemByOne(player, ContentHandler.getItem((String)"angelheart_vial"));
        this.spawnAngelheartVialParticles(player);
        player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "dig.glass", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        player.func_70606_j(4.0f);
        this.removeNegativeStatusEffects(player);
        event.setCanceled(true);
    }

    public void spawnAngelheartVialParticles(EntityPlayer player) {
        double var8 = player.field_70165_t;
        double var10 = player.field_70163_u;
        double var12 = player.field_70161_v;
        String var14 = "iconcrack_" + Item.func_150891_b((Item)Items.field_151068_bn);
        Random var7 = player.field_70170_p.field_73012_v;
        for (int var15 = 0; var15 < 8; ++var15) {
            player.field_70170_p.func_72869_a(var14, var8, var10, var12, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15);
        }
        float red = 1.0f;
        float green = 0.0f;
        float blue = 1.0f;
        String var19 = "spell";
        for (int var20 = 0; var20 < 100; ++var20) {
            EntityFX var31;
            double var39 = var7.nextDouble() * 4.0;
            double var23 = var7.nextDouble() * Math.PI * 2.0;
            double var25 = Math.cos(var23) * var39;
            double var27 = 0.01 + var7.nextDouble() * 0.5;
            double var29 = Math.sin(var23) * var39;
            if (!player.field_70170_p.field_72995_K || (var31 = Minecraft.func_71410_x().field_71438_f.func_72726_b(var19, var8 + var25 * 0.1, var10 + 0.3, var12 + var29 * 0.1, var25, var27, var29)) == null) continue;
            float var32 = 0.75f + var7.nextFloat() * 0.25f;
            var31.func_70538_b(red * var32, green * var32, blue * var32);
            var31.func_70543_e((float)var39);
        }
        player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "random.glass", 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void removeNegativeStatusEffects(EntityPlayer player) {
        player.func_82170_o(Potion.field_82731_v.field_76415_H);
        player.func_82170_o(Potion.field_76438_s.field_76415_H);
        player.func_82170_o(Potion.field_76436_u.field_76415_H);
        player.func_82170_o(Potion.field_76431_k.field_76415_H);
        player.func_82170_o(Potion.field_76419_f.field_76415_H);
        player.func_82170_o(Potion.field_76421_d.field_76415_H);
        player.func_82170_o(Potion.field_76440_q.field_76415_H);
        player.func_82170_o(Potion.field_76437_t.field_76415_H);
    }

    public void handlePhoenixDownCheck(EntityPlayer player, LivingAttackEvent event) {
        if (player.func_110143_aJ() > (float)Math.round(event.ammount)) {
            return;
        }
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"phoenix_down"))) {
            return;
        }
        this.revertPhoenixDownToAngelicFeather(player);
        event.setCanceled(true);
        player.func_70606_j(player.func_110138_aP());
        if (event.source == DamageSource.field_76371_c) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 200, 0));
        }
        if (event.source == DamageSource.field_76369_e) {
            player.func_70050_g(10);
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 200, 0));
        }
        player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 1));
        player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 1));
        this.removeNegativeStatusEffects(player);
        this.spawnPhoenixResurrectionParticles(player);
    }

    public void spawnPhoenixResurrectionParticles(EntityPlayer player) {
        for (int particles = 0; particles <= 400; ++particles) {
            player.field_70170_p.func_72869_a("flame", player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0);
        }
    }

    public void handleAngelicFeatherCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"phoenix_down")) && !this.playerHasItem(player, ContentHandler.getItem((String)"angelic_feather"))) {
            return;
        }
        if (event.source != DamageSource.field_76379_h) {
            return;
        }
        if (player.field_70143_R > 0.0f) {
            if (player.func_71024_bL().func_75115_e() < player.field_70143_R * 2.0f) {
                return;
            }
            player.func_71020_j(player.field_70143_R * 2.0f);
            player.field_70143_R = 0.0f;
        }
        event.setCanceled(true);
    }

    public void handleKrakenEyeCheck(EntityPlayer player, LivingAttackEvent event) {
        if (!this.playerHasItem(player, ContentHandler.getItem((String)"kraken_shell"))) {
            return;
        }
        if (event.source == DamageSource.field_76369_e) {
            if (player.func_71024_bL().func_75115_e() < event.ammount * 0.5f) {
                return;
            }
            float hungerDamage = 0.5f * event.ammount;
            player.func_71020_j(hungerDamage);
            event.setCanceled(true);
        }
    }

    private void revertPhoenixDownToAngelicFeather(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ContentHandler.getItem((String)"phoenix_down")) continue;
            player.field_71071_by.field_70462_a[slot] = new ItemStack(ContentHandler.getItem((String)"angelic_feather"));
            return;
        }
    }

    private boolean playerHasItem(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    private void decreaseItemByOne(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return;
        }
    }

    @SubscribeEvent
    public void onCraftingAlkahest(PlayerEvent.ItemCraftedEvent event) {
        boolean isCharging = false;
        int tome = 9;
        AlkahestRecipe recipe = null;
        for (int count = 0; count < event.craftMatrix.func_70302_i_(); ++count) {
            ItemStack stack = event.craftMatrix.func_70301_a(count);
            if (stack == null) continue;
            if (ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Item)ContentHandler.getItem((String)"alkahest_tome")))) {
                tome = count;
                continue;
            }
            if (ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Item)Items.field_151137_ax)) || ContentHelper.getIdent((Item)stack.func_77973_b()).equals(ContentHelper.getIdent((Block)Blocks.field_150451_bX))) {
                isCharging = true;
                continue;
            }
            recipe = Alkahestry.getDictionaryKey(stack) == null ? Alkahestry.getRegistry().get(ContentHelper.getIdent((Item)stack.func_77973_b())) : Alkahestry.getDictionaryKey(stack);
        }
        if (tome != 9 && isCharging) {
            event.craftMatrix.func_70299_a(tome, null);
        } else if (tome != 9 && !isCharging && recipe != null) {
            ItemStack temp = event.craftMatrix.func_70301_a(tome);
            temp.func_77964_b(temp.func_77960_j() + recipe.cost);
            event.craftMatrix.func_70299_a(tome, temp);
        }
    }
}

