/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemBase;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xreliquary.Reliquary;

@ContentInit
public class ItemDestructionCatalyst
extends ItemBase {
    public static List<String> ids = ImmutableList.of((Object)"minecraft:dirt", (Object)"minecraft:grass", (Object)"minecraft:gravel", (Object)"minecraft:cobblestone", (Object)"minecraft:stone", (Object)"minecraft:sand", (Object)"minecraft:sandstone", (Object)"minecraft:snow", (Object)"minecraft:soul_sand", (Object)"minecraft:netherrack", (Object)"minecraft:end_stone");

    public ItemDestructionCatalyst() {
        super("destruction_catalyst");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (this.hasGunpowder(player) || player.field_71075_bZ.field_75098_d) {
            this.doExplosion(world, x, y, z, side, player);
        }
        return true;
    }

    public void doExplosion(World world, int x, int y, int z, int side, EntityPlayer player) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        y += side == 0 ? 1 : (side == 1 ? -1 : 0);
        z += side == 2 ? 1 : (side == 3 ? -1 : 0);
        x += side == 4 ? 1 : (side == 5 ? -1 : 0);
        for (int xD = -1; xD <= 1; ++xD) {
            for (int yD = -1; yD <= 1; ++yD) {
                for (int zD = -1; zD <= 1; ++zD) {
                    if (!this.isBreakable(ContentHelper.getIdent((Block)world.func_147439_a(x + xD, y + yD, z + zD)))) continue;
                    world.func_147449_b(x + xD, y + yD, z + zD, Blocks.field_150350_a);
                    if (world.field_73012_v.nextInt(2) == 0) {
                        world.func_72869_a("largeexplode", (double)(x + xD), (double)(y + yD), (double)(z + zD), 1.0, 0.0, 0.0);
                    }
                    destroyedSomething = true;
                    if (!playOnce) continue;
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    playOnce = false;
                }
            }
        }
        if (destroyedSomething) {
            this.consumeGunpowder(player);
        }
    }

    public boolean isBreakable(String id) {
        return ids.contains(id);
    }

    public boolean consumeGunpowder(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int gunPowderCost = 3;
        InventoryPlayer inventory = player.field_71071_by;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null || inventory.func_70301_a(slot).func_77973_b() != Items.field_151016_H) continue;
            while (gunPowderCost > 0 && player.field_71071_by.func_70301_a(slot) != null) {
                player.field_71071_by.func_70298_a(slot, 1);
                --gunPowderCost;
            }
            if (gunPowderCost != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasGunpowder(EntityPlayer player) {
        int gunPowderCount = 0;
        InventoryPlayer inventory = player.field_71071_by;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null || inventory.func_70301_a(slot).func_77973_b() != Items.field_151016_H || (gunPowderCount += inventory.func_70301_a((int)slot).field_77994_a) < 3) continue;
            return true;
        }
        return false;
    }
}

