/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.entities.EntityBlazeShot;
import xreliquary.entities.EntityBusterShot;
import xreliquary.entities.EntityConcussiveShot;
import xreliquary.entities.EntityEnderShot;
import xreliquary.entities.EntityExorcismShot;
import xreliquary.entities.EntityNeutralShot;
import xreliquary.entities.EntitySandShot;
import xreliquary.entities.EntitySeekerShot;
import xreliquary.entities.EntityStormShot;
import xreliquary.util.NBTHelper;

@ContentInit
public class ItemHandgun
extends ItemBase {
    public ItemHandgun() {
        super("handgun");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        return Integer.parseInt("FFFFFF", 16);
    }

    public int getBulletCount(ItemStack ist) {
        return NBTHelper.getShort("bulletCount", ist);
    }

    public void setBulletCount(ItemStack ist, int i) {
        NBTHelper.setShort("bulletCount", ist, i);
    }

    public int getBulletType(ItemStack ist) {
        return NBTHelper.getShort("bulletType", ist);
    }

    public void setBulletType(ItemStack ist, int i) {
        NBTHelper.setShort("bulletType", ist, i);
    }

    public int getCooldown(ItemStack ist) {
        return NBTHelper.getShort("cooldownTime", ist);
    }

    public void setCooldown(ItemStack ist, int i) {
        NBTHelper.setShort("cooldownTime", ist, i);
    }

    public void func_77663_a(ItemStack ist, World worldObj, Entity e, int i, boolean flag) {
        if (this.getCooldown(ist) > 0) {
            this.setCooldown(ist, this.getCooldown(ist) - 1);
        }
    }

    public ItemStack func_77659_a(ItemStack ist, World worldObj, EntityPlayer player) {
        if (this.getCooldown(ist) <= 0) {
            if (this.getBulletCount(ist) <= 0 && this.getBulletType(ist) <= 0) {
                player.func_71008_a(ist, this.func_77626_a(ist));
            } else {
                this.fireBullet(ist, worldObj, player);
            }
        }
        return ist;
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int count) {
        if (!this.hasFilledMagazine(player)) {
            this.setCooldown(ist, 12);
            this.resetReloadDuration(ist);
            player.func_71034_by();
            return;
        }
        if (this.reloadTicks(count) >= this.calculatePlayerSkillTimer(player) - 1) {
            this.setCooldown(ist, 24);
            this.setBulletType(ist, this.getMagazineTypeAndRemoveOne(player));
            if (this.getBulletType(ist) != 0) {
                player.func_71038_i();
                this.spawnEmptyMagazine(player);
                this.setBulletCount(ist, 8);
                player.field_70170_p.func_72956_a((Entity)player, "xreliquary:xload", 0.25f, 1.0f);
            }
            if (this.getBulletCount(ist) == 0) {
                this.setBulletType(ist, 0);
            }
            player.func_71034_by();
        }
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getItemUseDuration();
    }

    private int reloadTicks(int i) {
        return this.getItemUseDuration() - i;
    }

    private int getItemUseDuration() {
        return 256;
    }

    private void fireBullet(ItemStack ist, World worldObj, EntityPlayer player) {
        if (!worldObj.field_72995_K) {
            this.setCooldown(ist, 12);
            switch (this.getBulletType(ist)) {
                case 0: {
                    return;
                }
                case 1: {
                    EntityNeutralShot ns = new EntityNeutralShot(worldObj, player);
                    worldObj.func_72838_d((Entity)ns);
                    break;
                }
                case 2: {
                    EntityExorcismShot exs = new EntityExorcismShot(worldObj, player);
                    worldObj.func_72838_d((Entity)exs);
                    break;
                }
                case 3: {
                    EntityBlazeShot bls = new EntityBlazeShot(worldObj, player);
                    worldObj.func_72838_d((Entity)bls);
                    break;
                }
                case 4: {
                    EntityEnderShot es = new EntityEnderShot(worldObj, player);
                    worldObj.func_72838_d((Entity)es);
                    break;
                }
                case 5: {
                    EntityConcussiveShot cs = new EntityConcussiveShot(worldObj, player);
                    worldObj.func_72838_d((Entity)cs);
                    break;
                }
                case 6: {
                    EntityBusterShot bs = new EntityBusterShot(worldObj, player);
                    worldObj.func_72838_d((Entity)bs);
                    break;
                }
                case 7: {
                    EntitySeekerShot ss = new EntitySeekerShot(worldObj, player);
                    worldObj.func_72838_d((Entity)ss);
                    break;
                }
                case 8: {
                    EntitySandShot sas = new EntitySandShot(worldObj, player);
                    worldObj.func_72838_d((Entity)sas);
                    break;
                }
                case 9: {
                    EntityStormShot sts = new EntityStormShot(worldObj, player);
                    worldObj.func_72838_d((Entity)sts);
                }
            }
            this.resetReloadDuration(ist);
            worldObj.func_72956_a((Entity)player, "xreliquary:xshot", 0.2f, 1.2f);
            this.setBulletCount(ist, this.getBulletCount(ist) - 1);
            if (this.getBulletCount(ist) == 0) {
                this.setBulletType(ist, 0);
            }
            this.spawnCasing(player);
        }
    }

    private void resetReloadDuration(ItemStack ist) {
        NBTHelper.setShort("reloadDuration", ist, 0);
    }

    private void spawnEmptyMagazine(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack(ContentHandler.getItem((String)"magazine"), 1, 0))) {
            player.func_70099_a(new ItemStack(ContentHandler.getItem((String)"magazine"), 1, 0), 0.1f);
        }
    }

    private void spawnCasing(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack(ContentHandler.getItem((String)"bullet"), 1, 0))) {
            player.func_70099_a(new ItemStack(ContentHandler.getItem((String)"bullet"), 1, 0), 0.1f);
        }
    }

    private boolean hasFilledMagazine(EntityPlayer player) {
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != ContentHandler.getItem((String)"magazine") || ist.func_77960_j() == 0) continue;
            return true;
        }
        return false;
    }

    private int getMagazineTypeAndRemoveOne(EntityPlayer player) {
        int bulletFound = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ContentHandler.getItem((String)"magazine") || player.field_71071_by.field_70462_a[slot].func_77960_j() == 0) continue;
            bulletFound = player.field_71071_by.field_70462_a[slot].func_77960_j();
            player.field_71071_by.func_70298_a(slot, 1);
            return bulletFound;
        }
        return bulletFound;
    }

    public boolean func_77662_d() {
        return true;
    }

    private int calculatePlayerSkillTimer(EntityPlayer player) {
        if (player.field_71068_ca >= 20) {
            return 12;
        }
        return 20 - player.field_71068_ca + 12;
    }
}

