/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemBase;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

@ContentInit
public class ItemVoidTear
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconOverlay;

    public ItemVoidTear() {
        super("void_tear");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "void_tear_overlay");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        String holds;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || new ItemStack((Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("itemID")), 1, (int)tag.func_74765_d("itemMeta")).func_77973_b() == null) {
            holds = "nothing";
        } else {
            ItemStack contents = new ItemStack((Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("itemID")), 1, (int)tag.func_74765_d("itemMeta"));
            String itemName = contents.func_82833_r();
            holds = "" + EnumChatFormatting.YELLOW + tag.func_74765_d("itemQuantity") + " of " + itemName;
        }
        this.formatTooltip(ImmutableMap.of((Object)"holds", (Object)holds), stack, list);
        if (stack.func_77978_p().func_74764_b("absorb")) {
            list.add(EnumChatFormatting.LIGHT_PURPLE + "Automagically absorbs items.");
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (renderPass == 1 && stack.func_77978_p().func_74764_b("absorb")) {
            return this.iconOverlay;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77978_p().func_74764_b("absorb") && this.findAndConsume(stack, player)) {
            stack.func_77978_p().func_74777_a("itemQuantity", Integer.valueOf(stack.func_77978_p().func_74765_d("itemQuantity") + 1).shortValue());
        }
    }

    private boolean findAndConsume(ItemStack stack, EntityPlayer player) {
        int suggestedSlot = -1;
        int count = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || !ContentHelper.getIdent((Item)player.field_71071_by.field_70462_a[slot].func_77973_b()).equals(stack.func_77978_p().func_74779_i("itemID")) || player.field_71071_by.field_70462_a[slot].func_77960_j() != stack.func_77978_p().func_74765_d("itemMeta")) continue;
            count += player.field_71071_by.field_70462_a[slot].field_77994_a;
            if (suggestedSlot != -1) continue;
            suggestedSlot = slot;
        }
        if (suggestedSlot != -1 && count > 64) {
            player.field_71071_by.func_70298_a(suggestedSlot, 1);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (stack.func_77978_p().func_74764_b("absorb")) {
                stack.func_77978_p().func_82580_o("absorb");
            } else {
                stack.func_77978_p().func_74757_a("absorb", true);
            }
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            return stack;
        }
        this.unloadContentsIntoInventory(stack, (IInventory)player.field_71071_by, player, true);
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (world.func_147438_o(x, y, z) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_147438_o(x, y, z);
            this.unloadContentsIntoInventory(stack, inventory, player, false);
            return true;
        }
        return false;
    }

    public void unloadContentsIntoInventory(ItemStack stack, IInventory inventory, EntityPlayer player, boolean playerInv) {
        int quantity;
        NBTTagCompound tearTag = stack.func_77978_p();
        if (tearTag == null) {
            return;
        }
        ItemStack contents = new ItemStack(ContentHandler.getItem((String)tearTag.func_74779_i("itemID")), 1, (int)tearTag.func_74765_d("itemMeta"));
        int minQuantity = quantity - contents.func_77976_d();
        for (quantity = tearTag.func_74765_d("itemQuantity"); quantity > Math.max(0, minQuantity) && !(playerInv ? !this.tryToAddToPlayerInventory(contents, inventory, player) : !this.tryToAddToInventory(contents, inventory)); --quantity) {
        }
        if (quantity == 0) {
            this.addEmptyTearToPlayerInventory(player);
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return;
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        tearTag.func_74777_a("itemQuantity", (short)quantity);
        stack.func_77982_d(tearTag);
    }

    private void addEmptyTearToPlayerInventory(EntityPlayer player) {
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(ContentHandler.getItem((String)"void_tear_empty")));
    }

    public boolean tryToAddToInventory(ItemStack contents, IInventory inventory) {
        int slot;
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null || !inventory.func_70301_a(slot).func_77969_a(contents) || inventory.func_70301_a((int)slot).field_77994_a == inventory.func_70301_a(slot).func_77976_d()) continue;
            ++inventory.func_70301_a((int)slot).field_77994_a;
            return true;
        }
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) != null) continue;
            inventory.func_70299_a(slot, new ItemStack(contents.func_77973_b(), contents.field_77994_a, contents.func_77960_j()));
            return true;
        }
        return false;
    }

    public boolean tryToAddToPlayerInventory(ItemStack contents, IInventory inventory, EntityPlayer player) {
        int slot;
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (slot >= player.field_71071_by.field_70462_a.length || inventory.func_70301_a(slot) == null || !inventory.func_70301_a(slot).func_77969_a(contents) || inventory.func_70301_a((int)slot).field_77994_a == inventory.func_70301_a(slot).func_77976_d()) continue;
            ++inventory.func_70301_a((int)slot).field_77994_a;
            return true;
        }
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (slot >= player.field_71071_by.field_70462_a.length || inventory.func_70301_a(slot) != null) continue;
            inventory.func_70299_a(slot, new ItemStack(contents.func_77973_b(), contents.field_77994_a, contents.func_77960_j()));
            return true;
        }
        return false;
    }
}

