/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentHandler;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.items.ItemSalamanderEye;
import xreliquary.util.NBTHelper;

@ContentInit
public class ItemWraithEye
extends ItemSalamanderEye {
    public ItemWraithEye() {
        super("wraith_eye");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "wraith_eye");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        return this.field_77791_bV;
    }

    @Override
    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        super.func_77663_a(ist, world, e, i, f);
        this.decrementCooldown(ist);
    }

    public ItemStack func_77659_a(ItemStack eye, World world, EntityPlayer par2EntityPlayer) {
        if (NBTHelper.getShort("cooldown", eye) > 0) {
            return eye;
        }
        if (eye.func_77978_p() != null && eye.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(par2EntityPlayer)).intValue()) {
            if (!world.field_72995_K) {
                par2EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Out of range!"));
            }
        } else if (eye.func_77978_p() != null && ContentHelper.areBlocksEqual((Block)world.func_147439_a(eye.func_77978_p().func_74762_e("nodeX" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeY" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeZ" + this.getWorld(par2EntityPlayer))), (Block)ContentHandler.getBlock((String)"wraith_node"))) {
            if (this.canTeleport(world, eye.func_77978_p().func_74762_e("nodeX" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeY" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeZ" + this.getWorld(par2EntityPlayer))) && this.findAndRemoveEnderPearl(par2EntityPlayer)) {
                this.teleportPlayer(world, eye.func_77978_p().func_74762_e("nodeX" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeY" + this.getWorld(par2EntityPlayer)), eye.func_77978_p().func_74762_e("nodeZ" + this.getWorld(par2EntityPlayer)), par2EntityPlayer);
                this.setCooldown(eye);
            }
        } else if (eye.func_77978_p() != null && eye.func_77978_p().func_74764_b("dimensionID")) {
            eye.func_77982_d(null);
            if (!world.field_72995_K) {
                par2EntityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Node dosen't exist!"));
            } else {
                par2EntityPlayer.func_85030_a("mob.endermen.death", 1.0f, 1.0f);
            }
        }
        return eye;
    }

    private void setCooldown(ItemStack ist) {
        NBTHelper.setShort("cooldown", ist, 20);
    }

    private void decrementCooldown(ItemStack ist) {
        if (NBTHelper.getShort("cooldown", ist) > 0) {
            NBTHelper.setShort("cooldown", ist, NBTHelper.getShort("cooldown", ist) - 1);
        }
    }

    private boolean findAndRemoveEnderPearl(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != Items.field_151079_bi) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return true;
        }
        return false;
    }

    private boolean canTeleport(World world, int x, int y, int z) {
        return world.func_147437_c(x, y + 1, z) && world.func_147437_c(x, y + 2, z);
    }

    private void teleportPlayer(World world, int x, int y, int z, EntityPlayer player) {
        player.func_70634_a((double)x + 0.5, (double)y + 0.875, (double)z + 0.5);
        player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.func_72869_a("portal", player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
        }
    }

    public void func_77624_a(ItemStack eye, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        String phrase = "Currently bound to";
        String position = null;
        if (eye.func_77978_p() != null && eye.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(par2EntityPlayer)).intValue()) {
            phrase = "Out of range!";
        } else {
            position = eye.func_77978_p() != null && eye.func_77978_p().func_74764_b("nodeX" + this.getWorld(par2EntityPlayer)) && eye.func_77978_p().func_74764_b("nodeY" + this.getWorld(par2EntityPlayer)) && eye.func_77978_p().func_74764_b("nodeZ" + this.getWorld(par2EntityPlayer)) ? "X: " + eye.func_77978_p().func_74762_e("nodeX" + this.getWorld(par2EntityPlayer)) + " Y: " + eye.func_77978_p().func_74762_e("nodeY" + this.getWorld(par2EntityPlayer)) + " Z: " + eye.func_77978_p().func_74762_e("nodeZ" + this.getWorld(par2EntityPlayer)) : "nowhere.";
        }
        this.formatTooltip(ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"position", (Object)position), eye, list);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if ((ist.func_77978_p() == null || !ist.func_77978_p().func_74764_b("dimensionID")) && ContentHelper.areBlocksEqual((Block)world.func_147439_a(x, y, z), (Block)ContentHandler.getBlock((String)"wraith_node"))) {
            this.setWraithNode(ist, x, y, z, Integer.valueOf(this.getWorld(player)), player);
            player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
            for (int particles = 0; particles < 12; ++particles) {
                world.func_72869_a("portal", (double)x + world.field_73012_v.nextDouble(), (double)y + world.field_73012_v.nextDouble(), (double)z + world.field_73012_v.nextDouble(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
            }
            return true;
        }
        return false;
    }

    public void setWraithNode(ItemStack eye, int x, int y, int z, int dimensionID, EntityPlayer player) {
        NBTHelper.setInteger("nodeX" + this.getWorld(player), eye, x);
        NBTHelper.setInteger("nodeY" + this.getWorld(player), eye, y);
        NBTHelper.setInteger("nodeZ" + this.getWorld(player), eye, z);
        NBTHelper.setInteger("dimensionID", eye, dimensionID);
    }

    public String getWorld(EntityPlayer player) {
        return Integer.valueOf(player.field_70170_p.field_73011_w.field_76574_g).toString();
    }
}

