/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.cable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.AbstractBlockConnectable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.IConnectable;
import mrriegel.storagenetwork.ModBlocks;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.cable.TileCable;
import mrriegel.storagenetwork.helper.InvHelper;
import mrriegel.storagenetwork.helper.Util;
import mrriegel.storagenetwork.master.TileMaster;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCable
extends AbstractBlockConnectable {
    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149711_c(1.4f);
        this.func_149647_a(CreativeTab.tab);
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!(worldIn.func_175625_s(pos) instanceof TileCable)) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileCable tile = (TileCable)worldIn.func_175625_s(pos);
        if (tile.getKind() == TileCable.Kind.exKabel || tile.getKind() == TileCable.Kind.imKabel || tile.getKind() == TileCable.Kind.storageKabel) {
            playerIn.openGui((Object)StorageNetwork.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.setConnections(worldIn, pos, state, false);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    boolean validInventory(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return InvHelper.hasItemHandler(worldIn, pos, side);
    }

    IBlockState getNewState(IBlockAccess world, BlockPos pos) {
        if (!(world.func_175625_s(pos) instanceof TileCable)) {
            return world.func_180495_p(pos);
        }
        TileCable tile = (TileCable)world.func_175625_s(pos);
        EnumFacing face = null;
        BlockPos con = null;
        Map<EnumFacing, EnumConnectType> oldMap = tile.getConnects();
        HashMap newMap = Maps.newHashMap();
        EnumFacing stor = null;
        for (Map.Entry<EnumFacing, EnumConnectType> e : oldMap.entrySet()) {
            if (e.getValue() != EnumConnectType.STORAGE) continue;
            stor = e.getKey();
            break;
        }
        boolean storage = false;
        boolean first = false;
        if (stor != null && this.getConnect(world, pos, pos.func_177972_a(stor)) == EnumConnectType.STORAGE) {
            newMap.put(stor, EnumConnectType.STORAGE);
            storage = true;
            first = true;
        }
        for (EnumFacing f : EnumFacing.values()) {
            if (stor == f && first) continue;
            EnumConnectType neu = this.getConnect(world, pos, pos.func_177972_a(f));
            if (neu == EnumConnectType.STORAGE) {
                if (!storage) {
                    newMap.put(f, neu);
                    storage = true;
                    continue;
                }
                newMap.put(f, EnumConnectType.NULL);
                continue;
            }
            newMap.put(f, neu);
        }
        tile.setConnects(newMap);
        if (tile.north == EnumConnectType.STORAGE) {
            face = EnumFacing.NORTH;
            con = pos.func_177978_c();
        } else if (tile.south == EnumConnectType.STORAGE) {
            face = EnumFacing.SOUTH;
            con = pos.func_177968_d();
        } else if (tile.east == EnumConnectType.STORAGE) {
            face = EnumFacing.EAST;
            con = pos.func_177974_f();
        } else if (tile.west == EnumConnectType.STORAGE) {
            face = EnumFacing.WEST;
            con = pos.func_177976_e();
        } else if (tile.down == EnumConnectType.STORAGE) {
            face = EnumFacing.DOWN;
            con = pos.func_177977_b();
        } else if (tile.up == EnumConnectType.STORAGE) {
            face = EnumFacing.UP;
            con = pos.func_177984_a();
        }
        tile.setInventoryFace(face);
        tile.setConnectedInventory(con);
        Map<EnumFacing, EnumConnectType> map = tile.getConnects();
        return world.func_180495_p(pos);
    }

    @Override
    public void setConnections(World worldIn, BlockPos pos, IBlockState state, boolean refresh) {
        state = this.getNewState((IBlockAccess)worldIn, pos);
        super.setConnections(worldIn, pos, state, refresh);
        if (refresh) {
            Util.updateTile(worldIn, pos);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        try {
            IBlockState foo = this.getNewState(worldIn, pos);
            return foo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.func_176221_a(state, worldIn, pos);
        }
    }

    public static EnumFacing get(BlockPos a, BlockPos b) {
        if (a.func_177984_a().equals((Object)b)) {
            return EnumFacing.DOWN;
        }
        if (a.func_177977_b().equals((Object)b)) {
            return EnumFacing.UP;
        }
        if (a.func_177976_e().equals((Object)b)) {
            return EnumFacing.EAST;
        }
        if (a.func_177974_f().equals((Object)b)) {
            return EnumFacing.WEST;
        }
        if (a.func_177978_c().equals((Object)b)) {
            return EnumFacing.SOUTH;
        }
        if (a.func_177968_d().equals((Object)b)) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!(worldIn.func_175625_s(pos) instanceof TileCable)) {
            return;
        }
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        TileCable tile = (TileCable)worldIn.func_175625_s(pos);
        float f = 0.3125f;
        float f1 = 0.6875f;
        float f2 = 0.3125f;
        float f3 = 0.6875f;
        float f4 = 0.3125f;
        float f5 = 0.6875f;
        BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        if (tile.north != EnumConnectType.NULL) {
            f2 = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (tile.south != EnumConnectType.NULL) {
            f3 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (tile.west != EnumConnectType.NULL) {
            f = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (tile.east != EnumConnectType.NULL) {
            f1 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (tile.down != EnumConnectType.NULL) {
            f4 = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (tile.up != EnumConnectType.NULL) {
            f5 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!(source.func_175625_s(pos) instanceof TileCable)) {
            return field_185505_j;
        }
        state = state.func_185899_b(source, pos);
        TileCable tile = (TileCable)source.func_175625_s(pos);
        float f = 0.3125f;
        float f1 = 0.6875f;
        float f2 = 0.3125f;
        float f3 = 0.6875f;
        float f4 = 0.3125f;
        float f5 = 0.6875f;
        if (tile == null) {
            return new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3);
        }
        AxisAlignedBB res = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (tile.north != EnumConnectType.NULL) {
            f2 = 0.0f;
        }
        if (tile.south != EnumConnectType.NULL) {
            f3 = 1.0f;
        }
        if (tile.west != EnumConnectType.NULL) {
            f = 0.0f;
        }
        if (tile.east != EnumConnectType.NULL) {
            f1 = 1.0f;
        }
        if (tile.down != EnumConnectType.NULL) {
            f4 = 0.0f;
        }
        if (tile.up != EnumConnectType.NULL) {
            f5 = 1.0f;
        }
        return new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3);
    }

    protected EnumConnectType getConnect(IBlockAccess worldIn, BlockPos orig, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        Block ori = worldIn.func_180495_p(orig).func_177230_c();
        if (worldIn.func_175625_s(pos) instanceof IConnectable || worldIn.func_175625_s(pos) instanceof TileMaster) {
            return EnumConnectType.CONNECT;
        }
        if (ori == ModBlocks.kabel) {
            return EnumConnectType.NULL;
        }
        EnumFacing face = BlockCable.get(orig, pos);
        if (!this.validInventory(worldIn, pos, face)) {
            return EnumConnectType.NULL;
        }
        return EnumConnectType.STORAGE;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileCable) {
            TileCable tile = (TileCable)tileentity;
            for (int i = 0; i < tile.getUpgrades().size(); ++i) {
                Util.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tile.getUpgrades().get(i));
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCable();
    }

    public static class PropertyConnection
    extends PropertyEnum<EnumConnectType> {
        String field_177703_b;

        public PropertyConnection(String name2) {
            super(name2, EnumConnectType.class, (Collection)Lists.newArrayList((Object[])EnumConnectType.values()));
            this.field_177703_b = name2;
        }

        public static PropertyConnection create(String name) {
            return new PropertyConnection(name);
        }

        public String func_177701_a() {
            return this.field_177703_b;
        }
    }

    public static class Item
    extends ItemBlock {
        public Item(Block block) {
            super(block);
        }

        public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            super.func_77624_a(stack, playerIn, tooltip, advanced);
            if (stack.func_77973_b() == net.minecraft.item.Item.func_150898_a((Block)ModBlocks.exKabel)) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_E", (Object[])new Object[0]));
            } else if (stack.func_77973_b() == net.minecraft.item.Item.func_150898_a((Block)ModBlocks.imKabel)) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_I", (Object[])new Object[0]));
            } else if (stack.func_77973_b() == net.minecraft.item.Item.func_150898_a((Block)ModBlocks.storageKabel)) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_S", (Object[])new Object[0]));
            } else if (stack.func_77973_b() == net.minecraft.item.Item.func_150898_a((Block)ModBlocks.kabel)) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_L", (Object[])new Object[0]));
            }
        }
    }

    public static enum EnumConnectType implements IStringSerializable
    {
        CONNECT("connect"),
        STORAGE("storage"),
        NULL("null");

        String name;

        private EnumConnectType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

