/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.helper.NBTHelper;
import mrriegel.storagenetwork.remote.ContainerRemote;
import mrriegel.storagenetwork.request.ContainerRequest;
import mrriegel.storagenetwork.request.TileRequest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SortMessage
implements IMessage,
IMessageHandler<SortMessage, IMessage> {
    BlockPos pos;
    boolean direction;
    TileRequest.EnumSortType sort;

    public SortMessage() {
    }

    public SortMessage(BlockPos pos, boolean direction, TileRequest.EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public IMessage onMessage(final SortMessage message, final MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerRemote) {
                    ItemStack s = ctx.getServerHandler().field_147369_b.field_71071_by.func_70448_g();
                    NBTHelper.setBoolean(s, "down", message.direction);
                    NBTHelper.setString(s, "sort", message.sort.toString());
                    return;
                }
                if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerRequest) {
                    TileEntity t = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
                    if (t instanceof TileRequest) {
                        TileRequest tile = (TileRequest)t;
                        tile.sort = message.sort;
                        tile.downwards = message.direction;
                    }
                    t.func_70296_d();
                }
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.direction = buf.readBoolean();
        this.sort = TileRequest.EnumSortType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.direction);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sort.toString());
    }
}

